/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.rollup;

import com.tridium.history.collection.PropertyColumn;
import com.tridium.history.rollup.BHistoryRollupRecord;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BFacets;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;

public class HistoryRollupColumns
implements ColumnList {
    private ArrayList<Column> list;
    private HashMap<String, Column> table;

    public static HistoryRollupColumns getColumns() {
        BHistoryRollupRecord rec = new BHistoryRollupRecord();
        Property[] props = rec.getPropertiesArray();
        HistoryRollupColumns columns = new HistoryRollupColumns(props.length);
        for (int i = 0; i < props.length; ++i) {
            Property prop = props[i];
            columns.addColumn(new PropertyColumn(props[i], null, null));
        }
        return columns;
    }

    public static HistoryRollupColumns getColumns(BITable<?> table) {
        BHistoryRollupRecord rec = new BHistoryRollupRecord();
        Property[] props = rec.getPropertiesArray();
        HistoryRollupColumns columns = new HistoryRollupColumns(props.length);
        ColumnList srcColumns = table.getColumns();
        Column valCol = srcColumns.get("value");
        Column timeCol = srcColumns.get("timestamp");
        for (int i = 0; i < props.length; ++i) {
            Property prop = props[i];
            BFacets facets = null;
            if (valCol != null && (prop.equals(BHistoryRollupRecord.avg) || prop.equals(BHistoryRollupRecord.max) || prop.equals(BHistoryRollupRecord.min) || prop.equals(BHistoryRollupRecord.sum))) {
                facets = valCol.getFacets();
            } else if (timeCol != null && (prop.equals(BHistoryRecord.timestamp) || prop.equals(BHistoryRollupRecord.endTimestamp))) {
                facets = timeCol.getFacets();
            }
            columns.addColumn(new PropertyColumn(prop, null, facets));
        }
        return columns;
    }

    public HistoryRollupColumns(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
        this.table = new HashMap();
    }

    public void addColumn(Column column) {
        this.list.add(column);
        this.table.put(column.getName(), column);
        if (this.list.size() != this.table.size()) {
            throw new BajaRuntimeException("Duplicate column: " + column.getName());
        }
    }

    public int size() {
        return this.list.size();
    }

    public Column get(int index) {
        return this.list.get(index);
    }

    public Column get(String name) {
        return this.table.get(name);
    }

    public int indexOf(String name) {
        int count = this.list.size();
        for (int i = 0; i < count; ++i) {
            if (!this.list.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public Column[] list() {
        return this.list.toArray(new Column[this.list.size()]);
    }
}

