/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.rollup;

import com.tridium.history.HistoryTableCursor;
import com.tridium.history.rollup.BRollupInterval;
import com.tridium.history.rollup.CollectiveRollupValue;
import com.tridium.history.rollup.HistoryRollupColumns;
import com.tridium.history.rollup.RollupCursor;
import com.tridium.history.rollup.RollupValue;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryRecord;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHistoryRollup
extends BObject
implements BITable<BHistoryRecord> {
    public static final Type TYPE = Sys.loadType(BHistoryRollup.class);
    private final BITable<BHistoryRecord> table;
    private final BRelTime rollupRelTimeInterval;
    private BRollupInterval rollupDefInterval;
    private ArrayList<BValue> list;
    private ColumnList columns;
    private final IFilter filter;
    private final BFacets tableFacets;

    public Type getType() {
        return TYPE;
    }

    public static BITable<BHistoryRecord> rollup(BITable<BHistoryRecord> table, BRelTime interval) {
        return BHistoryRollup.rollup(null, table, interval);
    }

    public static BITable<BHistoryRecord> rollup(OrdTarget base, BITable<BHistoryRecord> table, BRelTime interval) {
        if (table != null && interval != null) {
            return new BHistoryRollup(table, interval);
        }
        return null;
    }

    public static BITable<BHistoryRecord> rollup(OrdTarget base, BITable<BHistoryRecord> table, BRollupInterval interval) {
        if (table != null && interval != null) {
            return new BHistoryRollup(table, interval);
        }
        return null;
    }

    public static BITable<BHistoryRecord> rollup(OrdTarget base, BRelTime interval) {
        if (interval == null) {
            return null;
        }
        BObject baseTarget = base.get();
        if (baseTarget instanceof BITable) {
            return BHistoryRollup.rollup(base, (BITable<BHistoryRecord>)((BITable)baseTarget), interval);
        }
        return null;
    }

    public static BITable<BHistoryRecord> rollup(OrdTarget base, BRollupInterval interval) {
        if (interval == null || base == null) {
            return null;
        }
        BObject baseTarget = base.get();
        if (baseTarget instanceof BITable) {
            return BHistoryRollup.rollup(base, (BITable<BHistoryRecord>)((BITable)baseTarget), interval);
        }
        return null;
    }

    public BHistoryRollup(BITable<BHistoryRecord> table, BRelTime rollupInterval) {
        this(table, rollupInterval, null);
    }

    private BHistoryRollup(BITable<BHistoryRecord> table, BRollupInterval interval) {
        this(table, interval, null);
    }

    private BHistoryRollup(BITable<BHistoryRecord> table, BRelTime rollupInterval, IFilter filter) {
        this.table = table;
        this.rollupRelTimeInterval = rollupInterval;
        this.filter = filter;
        this.tableFacets = table.getTableFacets();
    }

    private BHistoryRollup(BITable<BHistoryRecord> table, BRollupInterval interval, IFilter filter) {
        this.table = table;
        this.rollupRelTimeInterval = BRelTime.DEFAULT;
        this.filter = filter;
        this.tableFacets = table.getTableFacets();
        this.rollupDefInterval = interval;
    }

    public TableCursor<BHistoryRecord> cursor() {
        RollupCursor rollupCursor = null != this.rollupDefInterval ? new RollupCursor((RollupValue)new CollectiveRollupValue(), this.table, this.rollupDefInterval) : new RollupCursor((RollupValue)new CollectiveRollupValue(), this.table, this.rollupRelTimeInterval);
        return new HistoryTableCursor(this, (Cursor<BHistoryRecord>)rollupCursor, this.filter);
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            this.columns = HistoryRollupColumns.getColumns(this.table);
        }
        return this.columns;
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    private synchronized void load() {
        if (this.list != null) {
            return;
        }
        TableCursor<BHistoryRecord> c = this.cursor();
        this.list = new ArrayList(128);
        while (c.next()) {
            BHistoryRecord row = (BHistoryRecord)c.get();
            if (this.filter != null && !this.filter.accept((Object)row)) continue;
            this.list.add(row.newCopy(true));
        }
    }
}

