/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.fox;

import com.tridium.history.BHistory;
import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.history.fox.FoxHistoryException;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

public class FoxHistorySpaceConnection
implements HistorySpaceConnection {
    BFoxHistorySpace space;
    Context cx;

    FoxHistorySpaceConnection(BFoxHistorySpace space, Context cx) {
        this.space = space;
        this.cx = cx;
    }

    @Override
    public BIHistory getHistory(BHistoryId historyId) {
        BIHistory cached = this.space.get(historyId);
        if (cached != null) {
            return cached;
        }
        try {
            BIHistory history = this.space.channel().getHistory(this.space, historyId);
            this.space.add(historyId, history);
            return history;
        }
        catch (Exception e) {
            throw new FoxHistoryException(historyId.toString(), e);
        }
    }

    @Override
    public BHistorySummary getSummary(BIHistory history) {
        try {
            return this.space.channel().getSummary(history.getId());
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public int getRecordCount(BIHistory history) {
        try {
            BHistorySummary summary = this.space.channel().getSummary(history.getId());
            return summary.getRecordCount();
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public BAbsTime getFirstTimestamp(BIHistory history) {
        try {
            BHistorySummary summary = this.space.channel().getSummary(history.getId());
            return summary.getFirstTimestamp();
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public BAbsTime getLastTimestamp(BIHistory history) {
        try {
            BHistorySummary summary = this.space.channel().getSummary(history.getId());
            return summary.getLastTimestamp();
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public BHistoryRecord getLastRecord(BIHistory history) {
        try {
            return this.space.channel().getLastRecord(history.getId());
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public void append(BIHistory history, BIHistoryRecordSet newRecords) throws HistoryException {
        try {
            this.space.channel().append(history.getId(), newRecords);
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public void update(BIHistory history, BHistoryRecord record) {
        try {
            if (record instanceof BTrendRecord) {
                ((BTrendRecord)record).setTrendFlags(((BTrendRecord)record).getTrendFlags().set(8, true));
            }
            this.space.channel().update(history.getId(), record);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxHistoryException("Cannot update record.", e);
        }
    }

    @Override
    public Cursor<BHistoryRecord> scan(BIHistory history) {
        return this.timeQueryCursor(history, null, null, false);
    }

    @Override
    public Cursor<BHistoryRecord> scan(BIHistory history, boolean descending) {
        return this.timeQueryCursor(history, null, null, descending);
    }

    @Override
    public BITable<BHistoryRecord> timeQuery(BIHistory history, BAbsTime startTime, BAbsTime endTime) {
        return this.timeQuery(history, startTime, endTime, false);
    }

    @Override
    public BITable<BHistoryRecord> timeQuery(BIHistory history, BAbsTime startTime, BAbsTime endTime, boolean descending) throws HistoryException {
        if (history instanceof BHistory) {
            return new BHistoryTimeQuery((BHistory)history, startTime, endTime, descending);
        }
        throw new HistoryException(history + " is not a BHistory.");
    }

    public Cursor<BHistoryRecord> timeQueryCursor(BIHistory history, BAbsTime startTime, BAbsTime endTime, boolean descending) throws HistoryException {
        try {
            return this.space.channel().timeQuery(history.getId(), descending, startTime, endTime);
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public void flush(BIHistory history) throws HistoryException {
        throw new UnsupportedOperationException("flush not supported remotely");
    }

    @Override
    public boolean exists(BHistoryId id) {
        if (this.space.get(id) != null) {
            return true;
        }
        try {
            return this.space.channel().exists(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxHistoryException(id.toString(), e);
        }
    }

    @Override
    public void createHistory(BHistoryConfig config) throws HistoryException {
        try {
            this.space.channel().createHistory(config);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxHistoryException("Cannot create history for " + (Object)((Object)config), e);
        }
    }

    @Override
    public void deleteHistory(BHistoryId id) {
        this.deleteHistories(new BOrd[]{BOrd.make((String)("history:" + id.toString()))});
    }

    @Override
    public void deleteHistories(BOrd[] ords) throws HistoryException {
        try {
            this.space.channel().deleteHistories(ords);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxHistoryException("Cannot delete histories.", e);
        }
    }

    @Override
    public void renameHistory(BHistoryId id, String historyName) throws HistoryException {
        try {
            this.space.channel().renameHistory(id, historyName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxHistoryException("Cannot rename history for " + id.toString(), e);
        }
    }

    @Override
    public void clearAllRecords(BHistoryId id) throws HistoryException {
        this.clearAllRecords(new BOrd[]{BOrd.make((String)("history:" + id.toString()))});
    }

    @Override
    public void clearAllRecords(BOrd[] ords) throws HistoryException {
        try {
            this.space.channel().clearAllRecords(ords);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxHistoryException("Cannot clear records.", e);
        }
    }

    @Override
    public void clearOldRecords(BHistoryId id, BAbsTime before) throws HistoryException {
        this.clearOldRecords(new BOrd[]{BOrd.make((String)("history:" + id.toString()))}, before);
    }

    @Override
    public void clearOldRecords(BOrd[] ords, BAbsTime before) throws HistoryException {
        try {
            this.space.channel().clearOldRecords(ords, before);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FoxHistoryException("Cannot clear records.", e);
        }
    }

    @Override
    public void close() {
    }

    private BFoxHistorySpace fox() {
        return this.space;
    }
}

