/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.Page;
import com.tridium.history.file.recstore.ReadBlock;
import com.tridium.history.file.recstore.RecordSpec;
import com.tridium.history.file.recstore.RecordStore;
import java.io.EOFException;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;

public class RecordStoreCursor
extends HistoryCursor {
    private RecordStore store;
    private Page page;
    private int startBlock;
    private BAbsTime end;
    private ReadBlock readBlock;

    public RecordStoreCursor(RecordStore store, BHistoryConfig config, RecordSpec start, BAbsTime end, Context cx) {
        super(config, config.makeRecord(store.getVersion()), cx);
        this.store = store;
        this.page = start.page;
        this.startBlock = start.block;
        this.end = end;
    }

    @Override
    protected boolean doNext(BHistoryRecord iteratorRec) {
        try {
            if (this.readBlock == null) {
                this.readBlock = new ReadBlock(this.store.getHeader().getBlockSize());
                this.readBlock.init(this.page, this.startBlock);
                if (this.readBlock.getBlocksInRec() == 0) {
                    this.readBlock = null;
                    return false;
                }
            } else if (!this.readBlock.nextBlock() || this.readBlock.getBlocksInRec() == 0) {
                this.page = this.page.nextPage();
                if (this.page == null) {
                    return false;
                }
                this.readBlock.init(this.page, 0);
            }
            iteratorRec.read(this.readBlock);
            if (this.end != null && !this.end.isNull()) {
                boolean afterEnd = iteratorRec.getTimestamp().isAfter(this.end);
                return !afterEnd;
            }
            return true;
        }
        catch (EOFException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

