/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.EmptyHistoryCursor;
import com.tridium.history.file.BFileHistoryTable;
import com.tridium.history.file.recstore.Page;
import com.tridium.history.file.recstore.ReadBlock;
import com.tridium.history.file.recstore.RecordSpec;
import com.tridium.history.file.recstore.RecordStoreCursor;
import com.tridium.history.file.recstore.RecordStoreDescendingCursor;
import com.tridium.history.file.recstore.RecordStoreHeader;
import com.tridium.history.io.RandomAccess;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.history.HistoryException;
import javax.baja.history.ITruncatable;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.util.BTypeSpec;

public class RecordStore {
    public static final int EQUAL_OR_AFTER = 0;
    public static final int EQUAL_OR_BEFORE = 1;
    public static final int EQUAL = 2;
    private static final int DIRTY_CACHE_SIZE = 5;
    private Page[] dirtyPages = null;
    private int oldestDirtyPageIndex = 0;
    private BHistoryConfig config;
    private BFileHistoryTable table;
    private int version = 2;
    private RecordStoreHeader header;
    private ByteBuffer writeBuffer;
    private Page firstPage;
    private Page lastPage;
    private int pageSize;
    private int pageCapacity;
    private ReadBlock updateReader;
    private int pageWriteCount;
    private int headerWriteCount;
    private int totalRecordAppends;

    public RecordStore(BHistoryConfig config, BFileHistoryTable table, int version) throws IOException {
        this.config = config;
        this.table = table;
        this.version = version;
        if (table.getAccess().length() == 0L) {
            throw new IOException("Invalid or corrupt record store.");
        }
        this.open();
    }

    public RecordStore(BHistoryConfig config, BFileHistoryTable table, int blockSize, int pageBlocks, int version) throws IOException {
        this.config = config;
        this.table = table;
        this.version = version;
        if (table.getAccess().length() == 0L) {
            this.create(blockSize, pageBlocks);
        } else {
            this.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordStoreHeader getHeader() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.header;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordCount() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.header.getRecordCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageCount() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return (int)((this.table.getAccess().length() - (long)this.header.getSize()) / (long)this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageSize() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.pageSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockSize() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.header.getBlockSize();
        }
    }

    int getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(int blockSize, int pageBlocks) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RandomAccess io = this.table.getAccess();
            io.seek(0L);
            this.pageSize = Page.computePageSize(blockSize, pageBlocks);
            this.pageCapacity = Page.computeCapacity(blockSize, pageBlocks);
            this.header = new RecordStoreHeader(blockSize, pageBlocks);
            this.header.write(io);
            ++this.headerWriteCount;
            this.writeBuffer = new ByteBuffer(blockSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RandomAccess io = this.table.getAccess();
            io.seek(0L);
            this.header = new RecordStoreHeader();
            this.header.read(io);
            this.pageSize = Page.computePageSize(this.header.getBlockSize(), this.header.getPageBlocks());
            this.pageCapacity = Page.computeCapacity(this.header.getBlockSize(), this.header.getPageBlocks());
            this.writeBuffer = new ByteBuffer(this.header.getBlockSize());
            int firstIndex = this.header.getFirstPage();
            int lastIndex = this.header.getLastPage();
            this.firstPage = firstIndex != -1 ? this.readPage(firstIndex) : null;
            this.lastPage = lastIndex != -1 ? (lastIndex == this.firstPage.index ? this.firstPage : this.readPage(lastIndex)) : null;
            this.updateReader = new ReadBlock(this.header.getBlockSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            boolean mod = false;
            if (this.firstPage != null) {
                boolean bl = mod = this.writePage(this.firstPage) || mod;
            }
            if (this.lastPage != null) {
                boolean bl = mod = this.writePage(this.lastPage) || mod;
            }
            if (this.dirtyPages != null) {
                for (int i = 0; i < 5; ++i) {
                    Page p = this.dirtyPages[i];
                    if (p == null) continue;
                    mod = this.writePage(p) || mod;
                }
                this.dirtyPages = null;
                this.oldestDirtyPageIndex = 0;
            }
            if (this.header.isDirty()) {
                RandomAccess io = this.table.getAccess();
                mod = true;
                io.seek(0L);
                this.header.write(io);
                ++this.headerWriteCount;
            }
            return mod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(BHistoryRecord rec) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            BCapacity capacity = this.config.getCapacity();
            boolean roll = false;
            int maxRecords = Integer.MAX_VALUE;
            if (capacity.isByRecordCount()) {
                BFullPolicy fullPolicy = this.config.getFullPolicy();
                maxRecords = capacity.getMaxRecords();
                if (fullPolicy == BFullPolicy.stop) {
                    if (this.header.getRecordCount() >= maxRecords) {
                        return;
                    }
                } else {
                    roll = true;
                }
            }
            ++this.totalRecordAppends;
            this.writeBuffer.reset();
            rec.write((DataOutput)this.writeBuffer);
            if (this.writeBuffer.getLength() > this.pageCapacity) {
                if (!(rec instanceof ITruncatable)) throw new IOException("Page overflow for record type " + rec.getType() + " content size: " + this.writeBuffer.getLength() + " > " + this.pageCapacity);
                if (!((ITruncatable)((Object)rec)).truncate(this.pageCapacity)) throw new IOException("Truncation failed, page overflow for record type " + rec.getType() + " content size: " + this.writeBuffer.getLength() + " > " + this.pageCapacity);
                this.writeBuffer.reset();
                rec.write((DataOutput)this.writeBuffer);
                if (this.writeBuffer.getLength() > this.pageCapacity) {
                    throw new IOException("Truncation insufficient, page overflow for record type " + rec.getType() + " content size: " + this.writeBuffer.getLength() + " > " + this.pageCapacity);
                }
            }
            Page page = this.getWritePage(this.writeBuffer.getLength(), roll);
            page.appendRecord(this.writeBuffer.getBytes(), 0, this.writeBuffer.getLength());
            this.header.incrementRecordCount();
            if (!roll) return;
            while (this.header.getRecordCount() > maxRecords) {
                this.firstPage.trimFromStart();
                this.header.decrementRecordCount();
                if (!this.firstPage.isEmpty()) continue;
                this.flush();
                this.firstPage = this.firstPage.nextPage();
                this.header.setFirstPage(this.firstPage.index);
                this.flush();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(BHistoryRecord oldRecord, BHistoryRecord newRecord) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RecordSpec spec = this.findRecord(newRecord.getTimestamp(), 2);
            if (spec == null) {
                throw new IOException("Record not found with timestamp " + newRecord.getTimestamp() + ".");
            }
            if (oldRecord != null) {
                this.updateReader.init(spec.page, spec.block);
                oldRecord.read(this.updateReader);
            }
            this.writeBuffer.reset();
            newRecord.write((DataOutput)this.writeBuffer);
            if (this.writeBuffer.getLength() > this.pageCapacity) {
                throw new IOException("Page overflow: " + this.writeBuffer.getLength() + " > " + this.pageCapacity);
            }
            Page p = spec.page;
            p.updateRecord(spec.block, this.writeBuffer.getBytes(), 0, this.writeBuffer.getLength());
            if (p != this.lastPage && p != this.firstPage) {
                if (this.dirtyPages == null) {
                    this.dirtyPages = new Page[5];
                    this.oldestDirtyPageIndex = 0;
                    this.dirtyPages[this.oldestDirtyPageIndex] = p;
                    return;
                }
                for (int i = 0; i < 5; ++i) {
                    if (this.dirtyPages[i] != null) continue;
                    this.dirtyPages[i] = p;
                    return;
                }
                this.writePage(this.dirtyPages[this.oldestDirtyPageIndex]);
                this.dirtyPages[this.oldestDirtyPageIndex] = p;
                this.oldestDirtyPageIndex = this.oldestDirtyPageIndex++;
                if (this.oldestDirtyPageIndex == 5) {
                    this.oldestDirtyPageIndex = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryCursor scan() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0 || this.firstPage == null) {
                return new EmptyHistoryCursor(this.config, this.config.makeRecord(), null);
            }
            return new RecordStoreCursor(this, this.config, new RecordSpec(this, this.firstPage, this.firstPage.getFirst()), null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryCursor query(BAbsTime startTime, BAbsTime endTime) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0 || this.firstPage == null) {
                return new EmptyHistoryCursor(this.config, this.config.makeRecord(this.version), null);
            }
            RecordSpec startRec = null;
            startRec = startTime == null || startTime.isNull() ? new RecordSpec(this, this.firstPage, this.firstPage.getFirst()) : this.findRecord(startTime, 0);
            if (startRec == null) {
                return new EmptyHistoryCursor(this.config, this.config.makeRecord(this.version), null);
            }
            if (startRec != null && endTime != null && !endTime.isNull() && startRec.getTimestamp().isAfter(endTime)) {
                return new EmptyHistoryCursor(this.table.getConfig(), this.config.makeRecord(this.version), null);
            }
            return new RecordStoreCursor(this, this.config, startRec, endTime, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryCursor queryDesc(BAbsTime startTime, BAbsTime endTime) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0 || this.firstPage == null) {
                return new EmptyHistoryCursor(this.config, this.config.makeRecord(), null);
            }
            RecordSpec endRect = null;
            endRect = endTime == null || endTime.isNull() ? new RecordSpec(this, this.lastPage, this.lastPage.getFree() - 1) : this.findRecord(endTime, 1);
            if (endRect == null) {
                return new EmptyHistoryCursor(this.config, this.config.makeRecord(), null);
            }
            if (endRect != null && startTime != null && endRect.getTimestamp().isBefore(startTime)) {
                return new EmptyHistoryCursor(this.table.getConfig(), this.config.makeRecord(), null);
            }
            return new RecordStoreDescendingCursor(this, this.config, endRect, startTime, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getFirstTimestamp() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0) {
                return BAbsTime.NULL;
            }
            RecordSpec spec = new RecordSpec(this, this.firstPage, this.firstPage.getFirst());
            return spec.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getLastTimestamp() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0) {
                return BAbsTime.NULL;
            }
            RecordSpec spec = new RecordSpec(this, this.lastPage, this.lastPage.getFree() - 1);
            return spec.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BHistoryRecord getLastRecord() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.header.getRecordCount() == 0) {
                return null;
            }
            RecordSpec spec = new RecordSpec(this, this.lastPage, this.lastPage.getFree() - 1);
            RecordStoreCursor c = new RecordStoreCursor(this, this.config, spec, null, null);
            if (c.next()) {
                return (BHistoryRecord)c.get();
            }
            return null;
        }
    }

    public RecordSpec findRecord(BAbsTime t, int searchMode) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            Page p;
            if (this.header.getRecordCount() == 0) {
                return null;
            }
            RecordSpec hiSpec = null;
            RecordSpec mSpec = new RecordSpec(this);
            RecordSpec loSpec = null;
            int pageCount = this.getPageCount();
            loSpec = new RecordSpec(this, this.firstPage, this.firstPage.getFirst());
            if (t.equals((Object)loSpec.getTimestamp())) {
                return loSpec;
            }
            hiSpec = new RecordSpec(this, this.lastPage, this.lastPage.getFirst());
            if (t.equals((Object)hiSpec.getTimestamp())) {
                return hiSpec;
            }
            if (t.isBefore(loSpec.getTimestamp())) {
                if (searchMode == 0) {
                    return loSpec;
                }
                return null;
            }
            if (t.isAfter(hiSpec.getTimestamp())) {
                mSpec.copyFrom(hiSpec);
            } else {
                int delta;
                do {
                    BAbsTime mid;
                    if (t.equals((Object)(mid = (mSpec = this.spec(mSpec, loSpec.page.index, hiSpec.page.index, pageCount)).getTimestamp()))) {
                        return mSpec;
                    }
                    if (t.isBefore(mid)) {
                        hiSpec.copyFrom(mSpec);
                        continue;
                    }
                    loSpec.copyFrom(mSpec);
                } while ((delta = this.pageDelta(loSpec.page.index, hiSpec.page.index, pageCount)) >= 2);
                if (delta == 0) {
                    mSpec.copyFrom(loSpec);
                } else if (t.isAfter(hiSpec.getTimestamp())) {
                    mSpec.copyFrom(hiSpec);
                } else {
                    mSpec.copyFrom(loSpec);
                }
            }
            loSpec.copyFrom(mSpec);
            hiSpec.set(mSpec.page, mSpec.page.getFree() - 1);
            if (loSpec.equals(hiSpec)) {
                if (searchMode == 1) {
                    return loSpec;
                }
                if (searchMode == 0) {
                    if (hiSpec.page.index == this.header.getLastPage()) {
                        return null;
                    }
                    p = hiSpec.page.nextPage();
                    hiSpec.set(p, p.getFirst());
                    return hiSpec;
                }
            }
            if (t.equals((Object)hiSpec.getTimestamp())) {
                return hiSpec;
            }
            if (t.isAfter(hiSpec.getTimestamp())) {
                if (searchMode == 1) {
                    return hiSpec;
                }
                if (searchMode == 0) {
                    if (hiSpec.page.index == this.header.getLastPage()) {
                        return null;
                    }
                    p = hiSpec.page.nextPage();
                    hiSpec.set(p, p.getFirst());
                    return hiSpec;
                }
            }
            mSpec.set(null, -1);
            while (true) {
                if (!mSpec.set(loSpec.page, (loSpec.block + hiSpec.block) / 2)) {
                    RecordSpec prev = new RecordSpec(this);
                    while (t.isAfter(loSpec.getTimestamp()) && !loSpec.equals(hiSpec)) {
                        prev.copyFrom(loSpec);
                        loSpec.set(loSpec.page, loSpec.block + loSpec.getBlocksInRec());
                    }
                    if (t.equals((Object)loSpec.getTimestamp())) {
                        return loSpec;
                    }
                    if (searchMode == 1) {
                        return prev;
                    }
                    if (searchMode == 0) {
                        return loSpec;
                    }
                }
                if (t.equals((Object)mSpec.getTimestamp())) {
                    return mSpec;
                }
                if (t.isAfter(mSpec.getTimestamp())) {
                    loSpec.copyFrom(mSpec);
                    continue;
                }
                hiSpec.copyFrom(mSpec);
            }
        }
    }

    private RecordSpec spec(RecordSpec spec, int p1, int p2, int count) throws IOException {
        int pageIndex = -1;
        pageIndex = p1 < p2 ? (p1 + p2) / 2 : (p1 + (count - p1 + p2 + 1) / 2) % count;
        Page p = this.readPage(pageIndex);
        if (spec == null) {
            spec = new RecordSpec(this, p, p.getFirst());
        } else {
            spec.set(p, p.getFirst());
        }
        return spec;
    }

    private int pageDelta(int p1, int p2, int count) {
        if (p1 == p2) {
            return 0;
        }
        if (p1 < p2) {
            return p2 - p1;
        }
        return p2 + count - p1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writePage(Page p) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (!p.isDirty()) {
                return false;
            }
            RandomAccess io = this.table.getAccess();
            io.seek((long)this.header.getSize() + (long)p.index * (long)this.pageSize);
            p.write(io);
            ++this.pageWriteCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page readPage(int index) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.lastPage != null && index == this.lastPage.index) {
                return this.lastPage;
            }
            if (this.firstPage != null && index == this.firstPage.index) {
                return this.firstPage;
            }
            if (this.dirtyPages != null) {
                for (int i = 0; i < 5; ++i) {
                    if (this.dirtyPages[i] == null || index != this.dirtyPages[i].index) continue;
                    return this.dirtyPages[i];
                }
            }
            Page p = new Page(this, index, this.header.getBlockSize(), this.header.getPageBlocks());
            this.readPage(p);
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPage(Page p) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RandomAccess io = this.table.getAccess();
            io.seek((long)this.header.getSize() + (long)p.index * (long)this.pageSize);
            p.read(io);
        }
    }

    private Page getWritePage(int bytesToWrite, boolean roll) throws IOException {
        if (this.lastPage == null) {
            this.newLastPage(roll);
        }
        if (!this.lastPage.hasFree(bytesToWrite)) {
            this.newLastPage(roll);
        }
        return this.lastPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getFirstPage() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.firstPage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getLastPage() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.lastPage;
        }
    }

    private void newLastPage(boolean roll) throws IOException {
        if (this.lastPage != null) {
            this.writePage(this.lastPage);
        }
        int lastIndex = this.header.getLastPage() + 1;
        if (this.header.getFirstPage() == -1 && this.header.getLastPage() == -1) {
            this.lastPage = new Page(this, lastIndex, this.header.getBlockSize(), this.header.getPageBlocks());
            this.writePage(this.lastPage);
            this.header.setLastPage(lastIndex);
            this.firstPage = this.lastPage;
            this.header.setFirstPage(this.firstPage.index);
            return;
        }
        if (roll) {
            int pageCount = this.getPageCount();
            if (lastIndex == pageCount) {
                int gap = this.firstPage.index;
                if (gap < 2) {
                    this.lastPage = new Page(this, lastIndex, this.header.getBlockSize(), this.header.getPageBlocks());
                    this.writePage(this.lastPage);
                    this.header.setLastPage(lastIndex);
                } else {
                    this.lastPage = this.readPage(0);
                    this.header.setRecordCount(this.header.getRecordCount() - this.lastPage.clear());
                    this.header.setLastPage(0);
                }
            } else {
                if (lastIndex == this.firstPage.index) {
                    this.lastPage = this.firstPage;
                    this.firstPage = this.firstPage.nextPage();
                    this.header.setFirstPage(this.firstPage.index);
                } else {
                    this.lastPage = this.readPage(lastIndex);
                }
                this.header.setRecordCount(this.header.getRecordCount() - this.lastPage.clear());
                this.header.setLastPage(this.lastPage.index);
            }
        } else {
            this.lastPage = new Page(this, lastIndex, this.header.getBlockSize(), this.header.getPageBlocks());
            this.writePage(this.lastPage);
            this.header.setLastPage(lastIndex);
            if (this.header.getFirstPage() == -1) {
                this.firstPage = this.lastPage;
                this.header.setFirstPage(this.firstPage.index);
            }
        }
    }

    public int getPageWriteCount() {
        return this.pageWriteCount;
    }

    public int getHeaderWriteCount() {
        return this.headerWriteCount;
    }

    public int getTotalRecordAppends() {
        return this.totalRecordAppends;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)this.config.getId().getHistoryDisplayName(), 2);
        out.prop((Object)"pageSize", this.pageSize);
        out.prop((Object)"pageCapacity", this.pageCapacity);
        out.prop((Object)"blockSize", this.header.getBlockSize());
        out.prop((Object)"pageBlocks", this.header.getPageBlocks());
        out.prop((Object)"firstPage", this.header.getFirstPage());
        out.prop((Object)"lastPage", this.header.getLastPage());
        out.prop((Object)"record appends", this.totalRecordAppends);
        out.prop((Object)"header writes)", this.headerWriteCount);
        out.prop((Object)"page writes", this.pageWriteCount);
        out.endProps();
    }

    public static BHistoryConfig cfg(BCapacity capacity, BFullPolicy fullPolicy) {
        BHistoryConfig cfg = new BHistoryConfig(BHistoryId.make("test", "var"), BTypeSpec.make((String)"history", (String)"StringTrendRecord"));
        cfg.setCapacity(capacity);
        cfg.setFullPolicy(fullPolicy);
        return cfg;
    }
}

