/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import com.tridium.history.file.fixed.Page;
import com.tridium.history.file.fixed.PageManager;
import java.io.IOException;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;

public class RecordSpec {
    private PageManager pageman;
    private Page page;
    int pageIndex = -1;
    int recIndex = -1;
    private int recCount;

    public RecordSpec(PageManager pageman) {
        this.pageman = pageman;
    }

    public RecordSpec(PageManager pageman, int pageIndex, int recIndex) throws IOException {
        this.pageman = pageman;
        this.set(pageIndex, recIndex);
    }

    public String toString() {
        return "rec:" + this.pageIndex + "," + this.recIndex;
    }

    public boolean equals(Object o) {
        if (o instanceof RecordSpec) {
            RecordSpec other = (RecordSpec)o;
            return other.pageIndex == this.pageIndex && other.recIndex == this.recIndex;
        }
        return false;
    }

    public void set(int pageIndex, int recIndex) throws IOException {
        this.pageIndex = pageIndex;
        this.recIndex = recIndex;
        if (this.page == null || this.page.index != pageIndex) {
            this.page = this.pageman.getPage(pageIndex);
            this.recCount = this.page.getRecordCount();
        }
    }

    public void copyFrom(RecordSpec other) {
        this.pageman = other.pageman;
        this.pageIndex = other.pageIndex;
        this.recIndex = other.recIndex;
        this.recCount = other.recCount;
        this.page = other.page;
    }

    public BHistoryRecord getRecord(BHistoryRecord rec) throws IOException {
        this.page.read(this.recIndex, rec);
        return rec;
    }

    public void setRecord(BHistoryRecord rec) throws IOException {
        this.page.set(this.recIndex, rec);
    }

    public BAbsTime getTimestamp() throws IOException {
        return this.page.readTimestamp(this.recIndex);
    }

    public boolean next() throws IOException {
        ++this.recIndex;
        if (this.recIndex == this.page.getMaxRecords()) {
            int newPageIndex = this.pageman.nextPage(this.pageIndex);
            if (newPageIndex == -1) {
                --this.recIndex;
                return false;
            }
            this.pageIndex = newPageIndex;
            try {
                this.page = this.pageman.getPage(this.pageIndex);
                this.recIndex = 0;
                if (this.page.getRecordCount() == 0) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                --this.recIndex;
                --this.pageIndex;
                return false;
            }
        }
        return true;
    }

    public boolean prev() throws IOException {
        --this.recIndex;
        if (this.recIndex == -1) {
            int newPageIndex = this.pageman.previousPage(this.pageIndex);
            this.pageIndex = newPageIndex == -1 ? this.pageman.lastPage() : newPageIndex;
            try {
                this.page = this.pageman.getPage(this.pageIndex);
                this.recIndex = this.page.getRecordCount() - 1 + this.page.getFirstIndex();
                if (this.page.getRecordCount() == 0) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ++this.recIndex;
                ++this.pageIndex;
                return false;
            }
        }
        return true;
    }
}

