/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import com.tridium.history.EmptyHistoryCursor;
import com.tridium.history.SchemaChangeException;
import com.tridium.history.file.BFileHistoryTable;
import com.tridium.history.file.fixed.Header;
import com.tridium.history.file.fixed.Page;
import com.tridium.history.file.fixed.PageHistoryCursor;
import com.tridium.history.file.fixed.PageHistoryDescendingCursor;
import com.tridium.history.file.fixed.RecordSpec;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.HistoryCursor;
import javax.baja.history.HistoryException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

public class PageManager {
    private static final int EQUAL_OR_AFTER = 0;
    private static final int EQUAL_OR_BEFORE = 1;
    private static final int EQUAL = 2;
    private static final BRelTime ONE_MILLI = BRelTime.make((long)1L);
    private BFileHistoryTable table;
    private Header header;
    private int recordSize;
    private int recordCount = -1;
    private int capacity;
    private Page firstPage;
    private Page lastPage;
    private Page recent;
    private int pageWriteCount;
    private int headerWriteCount;
    private int totalRecordAppends;
    private int firstPageHits;
    private int lastPageHits;
    private int pageMisses;
    private int recentPageHits;

    public PageManager(BFileHistoryTable table, int recordSize) {
        this.table = table;
        this.recordSize = recordSize;
    }

    public PageManager(BFileHistoryTable table, int pageSize, int recordSize, int capacity) {
        this.table = table;
        this.recordSize = recordSize;
        this.capacity = capacity;
        this.header = new Header(pageSize, recordSize, capacity);
    }

    public void create() throws IOException {
        if (this.header == null) {
            throw new IllegalStateException("For create, pageSize and recsPerPage must be specified.");
        }
        this.nextLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            int recCount;
            int excess;
            int prevPage;
            this.header = this.readHeader(null);
            if (this.header.getRecordSize() != this.recordSize) {
                throw new SchemaChangeException("Record length has changed: " + this.header.getRecordSize() + " != " + this.recordSize);
            }
            long len = this.table.length() - 64L;
            long pageSize = this.header.getPageSize();
            int extraBytes = (int)(len % pageSize);
            int pageCount = (int)(len / pageSize);
            if (extraBytes != 0) {
                this.header.setPageCount(pageCount);
                if (this.header.getLastPage() > pageCount - 1) {
                    this.header.setLastPage(pageCount - 1);
                }
                if (this.header.getFirstPage() > pageCount - 1) {
                    this.header.setFirstPage(this.header.getNextFirstPage());
                }
                this.writeHeader();
                this.table.setLength(64L + (long)pageCount * pageSize);
            }
            if (pageCount != this.header.getPageCount()) {
                this.header.setPageCount(pageCount);
                if (this.header.getLastPage() > pageCount - 1) {
                    this.header.setLastPage(pageCount - 1);
                }
                if (this.header.getFirstPage() > pageCount - 1) {
                    this.header.setFirstPage(this.header.getNextFirstPage());
                }
                this.writeHeader();
            }
            this.capacity = this.header.getCapacity();
            int firstIndex = this.header.getFirstPage();
            int lastIndex = this.header.getLastPage();
            this.firstPage = this.readPage(firstIndex);
            this.lastPage = firstIndex == lastIndex ? this.firstPage : this.readPage(lastIndex);
            if (this.lastPage.getRecordCount() == 0 && (prevPage = this.previousPage(this.lastPage.index)) != -1) {
                this.lastPage = this.readPage(prevPage);
                this.header.setPageCount(pageCount--);
                this.header.setLastPage(this.lastPage.index);
                this.writeHeader();
            }
            if ((excess = (recCount = this.computeRecordCount()) - this.capacity) > 0 && excess < this.header.getRecordsPerPage() && this.table.getConfig().getFullPolicy() == BFullPolicy.roll) {
                this.firstPage.trimFromStart(excess);
                this.computeRecordCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        boolean mod = false;
        Object object = this.table.getTableLock();
        synchronized (object) {
            mod = this.writePage(this.firstPage);
            mod = this.writePage(this.lastPage) || mod;
            mod = this.writePage(this.recent) || mod;
        }
        return mod;
    }

    public void close() {
        try {
            this.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recent = null;
        this.lastPage = null;
        this.firstPage = null;
        this.recordCount = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeRecordCount() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            int pageCount = this.header.getPageCount();
            if (pageCount == 0) {
                this.recordCount = 0;
                return 0;
            }
            int middlePages = 0;
            if (this.firstPage.index < this.lastPage.index) {
                middlePages = this.lastPage.index - this.firstPage.index - 1;
            } else if (this.lastPage.index < this.firstPage.index) {
                middlePages = pageCount - this.firstPage.index - 1 + this.lastPage.index;
            }
            int recsPerPage = this.header.getRecordsPerPage();
            this.recordCount = middlePages * recsPerPage;
            this.recordCount += this.firstPage.getRecordCount();
            if (this.firstPage != this.lastPage) {
                this.recordCount += this.lastPage.getRecordCount();
            }
            return this.recordCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordCount() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.recordCount != -1) {
                return this.recordCount;
            }
            return this.computeRecordCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getFirstTimestamp() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.firstPage.getRecordCount() == 0) {
                return BAbsTime.NULL;
            }
            return this.firstPage.readTimestamp(this.firstPage.getFirstIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getLastTimestamp() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.lastPage.getRecordCount() == 0) {
                return BAbsTime.NULL;
            }
            return this.lastPage.readTimestamp(this.lastPage.getLastIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BHistoryRecord getLastRecord() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.lastPage.getRecordCount() == 0) {
                return null;
            }
            BHistoryRecord rec = (BHistoryRecord)this.table.getConfig().getRecordType().getInstance();
            this.lastPage.read(this.lastPage.getLastIndex(), rec);
            return rec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(BHistoryRecord newRecord) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (!this.lastPage.append(newRecord)) {
                this.nextLast();
                if (!this.lastPage.append(newRecord)) {
                    throw new IOException("Cannot append record.");
                }
            }
            ++this.recordCount;
            ++this.totalRecordAppends;
            if (this.recordCount > this.capacity) {
                if (this.firstPage.trimFromStart(this.recordCount - this.capacity) == 0) {
                    this.nextFirst();
                    this.writeHeader();
                }
                this.recordCount = this.capacity;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(BHistoryRecord oldRecord, BHistoryRecord newRecord) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            BAbsTime t = newRecord.getTimestamp();
            RecordSpec spec = this.findRecord(t, 2);
            if (spec == null) {
                throw new IOException("Record not found with timestamp " + t + ".");
            }
            if (oldRecord != null) {
                spec.getRecord(oldRecord);
            }
            spec.setRecord(newRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BHistoryRecord> query(BAbsTime startTime, BAbsTime endTime) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            BasicContext cx;
            RecordSpec endRec;
            RecordSpec startRec;
            BHistoryRecord rec;
            block21: {
                BHistoryRecord afterEndRec;
                BHistoryRecord beforeStartRec;
                block20: {
                    block19: {
                        rec = this.table.getConfig().makeRecord(this.table.getVersion());
                        if (this.table.getRecordCount() == 0) {
                            return new EmptyHistoryCursor(this.table.getConfig(), rec, null);
                        }
                        beforeStartRec = null;
                        afterEndRec = null;
                        if (startTime == null || startTime.isNull()) {
                            startRec = new RecordSpec(this, this.firstPage.index, this.firstPage.getFirstIndex());
                        } else {
                            startRec = this.findRecord(startTime, 0);
                            try {
                                RecordSpec beforeStartRecSpec = this.findRecord(startTime.subtract(ONE_MILLI), 1);
                                if (beforeStartRecSpec != null) {
                                    beforeStartRec = beforeStartRecSpec.getRecord((BHistoryRecord)rec.newCopy());
                                }
                            }
                            catch (Exception e) {
                                if (!BHistoryService.logger.isLoggable(Level.FINE)) break block19;
                                BHistoryService.logger.log(Level.FINE, "Error computing record prior to requested query for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query start time " + startTime + ". Skipping prior record computation.", e);
                            }
                        }
                    }
                    if (endTime == null || endTime.isNull()) {
                        endRec = new RecordSpec(this, this.lastPage.index, this.lastPage.getLastIndex());
                    } else {
                        endRec = this.findRecord(endTime, 1);
                        try {
                            RecordSpec afterEndRecSpec = this.findRecord(endTime.add(ONE_MILLI), 0);
                            if (afterEndRecSpec != null) {
                                afterEndRec = afterEndRecSpec.getRecord((BHistoryRecord)rec.newCopy());
                            }
                        }
                        catch (Exception e) {
                            if (!BHistoryService.logger.isLoggable(Level.FINE)) break block20;
                            BHistoryService.logger.log(Level.FINE, "Error computing record after requested query for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query end time " + endTime + ". Skipping post record computation.", e);
                        }
                    }
                }
                cx = null;
                if (beforeStartRec != null || afterEndRec != null) {
                    try {
                        cx = new BasicContext((Context)null, HistoryCursor.makeBoundaryRecordFacets(beforeStartRec, afterEndRec));
                    }
                    catch (Exception e) {
                        if (!BHistoryService.logger.isLoggable(Level.FINE)) break block21;
                        BHistoryService.logger.log(Level.FINE, "Error creating context for query cursor for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query start time " + startTime + " and end time " + endTime + ".", e);
                    }
                }
            }
            if (startRec == null && endRec == null) {
                return new EmptyHistoryCursor(this.table.getConfig(), rec, (Context)cx);
            }
            if (startRec != null && endRec != null && startRec.getTimestamp().isAfter(endRec.getTimestamp())) {
                return new EmptyHistoryCursor(this.table.getConfig(), rec, (Context)cx);
            }
            return new PageHistoryCursor(this.table.getConfig(), rec, startRec, endRec, (Context)cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BHistoryRecord> queryDesc(BAbsTime startTime, BAbsTime endTime) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            BasicContext cx;
            RecordSpec endRec;
            RecordSpec startRec;
            BHistoryRecord rec;
            block21: {
                BHistoryRecord afterEndRec;
                BHistoryRecord beforeStartRec;
                block20: {
                    block19: {
                        rec = this.table.getConfig().makeRecord();
                        if (this.table.getRecordCount() == 0) {
                            return new EmptyHistoryCursor(this.table.getConfig(), rec, null);
                        }
                        beforeStartRec = null;
                        afterEndRec = null;
                        if (startTime == null || startTime.isNull()) {
                            startRec = new RecordSpec(this, this.firstPage.index, this.firstPage.getFirstIndex());
                        } else {
                            startRec = this.findRecord(startTime, 0);
                            try {
                                RecordSpec beforeStartRecSpec = this.findRecord(startTime.subtract(ONE_MILLI), 1);
                                if (beforeStartRecSpec != null) {
                                    beforeStartRec = beforeStartRecSpec.getRecord((BHistoryRecord)rec.newCopy());
                                }
                            }
                            catch (Exception e) {
                                if (!BHistoryService.logger.isLoggable(Level.FINE)) break block19;
                                BHistoryService.logger.log(Level.FINE, "Error computing record prior to requested queryDesc for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query start time " + startTime + ". Skipping prior record computation.", e);
                            }
                        }
                    }
                    if (endTime == null || endTime.isNull()) {
                        endRec = new RecordSpec(this, this.lastPage.index, this.lastPage.getLastIndex());
                    } else {
                        endRec = this.findRecord(endTime, 1);
                        try {
                            RecordSpec afterEndRecSpec = this.findRecord(endTime.add(ONE_MILLI), 0);
                            if (afterEndRecSpec != null) {
                                afterEndRec = afterEndRecSpec.getRecord((BHistoryRecord)rec.newCopy());
                            }
                        }
                        catch (Exception e) {
                            if (!BHistoryService.logger.isLoggable(Level.FINE)) break block20;
                            BHistoryService.logger.log(Level.FINE, "Error computing record after requested queryDesc for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query end time " + endTime + ". Skipping post record computation.", e);
                        }
                    }
                }
                cx = null;
                if (beforeStartRec != null || afterEndRec != null) {
                    try {
                        cx = new BasicContext((Context)null, HistoryCursor.makeBoundaryRecordFacets(afterEndRec, beforeStartRec));
                    }
                    catch (Exception e) {
                        if (!BHistoryService.logger.isLoggable(Level.FINE)) break block21;
                        BHistoryService.logger.log(Level.FINE, "Error creating context for queryDesc cursor for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query start time " + startTime + " and end time " + endTime + ".", e);
                    }
                }
            }
            if (startRec == null && endRec == null) {
                return new EmptyHistoryCursor(this.table.getConfig(), rec, (Context)cx);
            }
            if (startRec != null && endRec != null && startRec.getTimestamp().isAfter(endRec.getTimestamp())) {
                return new EmptyHistoryCursor(this.table.getConfig(), rec, (Context)cx);
            }
            return new PageHistoryDescendingCursor(this.table.getConfig(), rec, endRec, startRec, (Context)cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordSpec findRecord(BAbsTime key, int searchType) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RecordSpec hiSpec = null;
            RecordSpec iSpec = null;
            RecordSpec loSpec = null;
            boolean movedLo = true;
            boolean movedHi = true;
            BAbsTime ts = null;
            int count = this.getRecordCount();
            if (count == 0) {
                return null;
            }
            int firstIndex = 0;
            int lastIndex = count - 1;
            int lo = firstIndex;
            int hi = lastIndex;
            if (count == 1) {
                RecordSpec temp = this.getRecordSpec(null, lo);
                ts = temp.getTimestamp();
                int cmp = key.compareTo((Object)ts);
                if (cmp == 0) {
                    return temp;
                }
                if (cmp < 0) {
                    return searchType == 0 ? temp : null;
                }
                return searchType == 1 ? temp : null;
            }
            while (true) {
                if (movedLo) {
                    movedLo = false;
                    ts = (loSpec = this.getRecordSpec(loSpec, lo)).getTimestamp();
                    if (key.equals((Object)ts)) {
                        return loSpec;
                    }
                }
                if (movedHi) {
                    movedHi = false;
                    ts = (hiSpec = this.getRecordSpec(hiSpec, hi)).getTimestamp();
                    if (key.equals((Object)ts)) {
                        return hiSpec;
                    }
                }
                if (lo == hi - 1) {
                    if (lo == firstIndex && key.compareTo((Object)(ts = (loSpec = this.getRecordSpec(loSpec, lo)).getTimestamp())) < 0) {
                        if (searchType == 0) {
                            return loSpec;
                        }
                        return null;
                    }
                    if (hi == lastIndex && key.compareTo((Object)(ts = (hiSpec = this.getRecordSpec(hiSpec, hi)).getTimestamp())) > 0) {
                        if (searchType == 1) {
                            return hiSpec;
                        }
                        return null;
                    }
                    if (searchType == 0) {
                        return hiSpec;
                    }
                    if (searchType == 1) {
                        return loSpec;
                    }
                    return null;
                }
                int i = (hi + lo) / 2;
                ts = (iSpec = this.getRecordSpec(iSpec, i)).getTimestamp();
                int cmp = key.compareTo((Object)ts);
                if (cmp < 0) {
                    hi = i;
                    hiSpec.copyFrom(iSpec);
                    movedHi = true;
                    continue;
                }
                if (cmp <= 0) break;
                lo = i;
                loSpec.copyFrom(iSpec);
                movedLo = true;
            }
            return iSpec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirstRecordIndex() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.firstPage.getFirstIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastRecordIndex() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            int pageCount = this.header.getPageCount();
            int recsPerPage = this.header.getRecordsPerPage();
            return pageCount * recsPerPage + this.lastPage.getLastIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordSpec getRecordSpec(RecordSpec spec, int recIndex) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            int firstCount;
            if (spec == null) {
                spec = new RecordSpec(this);
            }
            if (recIndex < (firstCount = this.firstPage.getRecordCount())) {
                spec.set(this.firstPage.index, this.firstPage.getFirstIndex() + recIndex);
            } else {
                int recsPerPage = this.header.getRecordsPerPage();
                int logicalPageIndex = 1 + (recIndex - firstCount) / recsPerPage;
                int pageRecIndex = recIndex - firstCount - (logicalPageIndex - 1) * recsPerPage;
                int pageIndex = (this.firstPage.index + logicalPageIndex) % this.header.getMaxPages();
                spec.set(pageIndex, pageRecIndex);
            }
            return spec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getTimestamp(int recIndex) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            int recsPerPage = this.header.getRecordsPerPage();
            int pageIndex = recIndex / recsPerPage;
            int pageRecIndex = recIndex - pageIndex * recsPerPage;
            Page p = this.getPage(pageIndex);
            BAbsTime t = p.readTimestamp(pageRecIndex);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nextPage(int pageIndex) {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (pageIndex == this.header.getLastPage()) {
                return -1;
            }
            return this.header.next(pageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int previousPage(int pageIndex) {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (pageIndex == this.header.getFirstPage()) {
                return -1;
            }
            return this.header.previous(pageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Page getPage(int index) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (index == -1) {
                return null;
            }
            if (index == this.firstPage.index) {
                ++this.firstPageHits;
                return this.firstPage;
            }
            if (index == this.lastPage.index) {
                ++this.lastPageHits;
                return this.lastPage;
            }
            if (this.recent != null && index == this.recent.index) {
                ++this.recentPageHits;
                return this.recent;
            }
            ++this.pageMisses;
            Page p = this.readPage(index);
            this.writePage(this.recent);
            this.recent = p;
            return p;
        }
    }

    int firstPage() {
        return this.firstPage.index;
    }

    int lastPage() {
        return this.lastPage.index;
    }

    int pageCount() {
        return this.header.getPageCount();
    }

    private Header readHeader(Header header) throws IOException {
        if (header == null) {
            header = new Header();
        }
        this.table.seek(0L);
        header.read(this.table.in());
        return header;
    }

    private Page readPage(int index) throws IOException {
        int pageSize = this.header.getPageSize();
        this.table.seek(64L + (long)pageSize * (long)index);
        Page p = new Page(index, pageSize, this.recordSize);
        p.read(this.table.in());
        return p;
    }

    private void nextFirst() throws IOException {
        int newFirst = this.header.getNextFirstPage();
        this.header.setFirstPage(newFirst);
        if (newFirst == this.lastPage.index) {
            this.firstPage = this.lastPage;
        } else if (this.recent != null && newFirst == this.recent.index) {
            this.firstPage = this.recent;
            this.recent = null;
        } else {
            this.firstPage = this.readPage(newFirst);
        }
    }

    private void nextLast() throws IOException {
        this.writePage(this.lastPage);
        int pageSize = this.header.getPageSize();
        int newLast = this.header.getNextLastPage();
        if (newLast == this.header.getFirstPage()) {
            this.nextFirst();
            this.writeHeader();
            this.lastPage = new Page(newLast, pageSize, this.header.getRecordSize());
            this.writePage(this.lastPage);
            this.header.setLastPage(newLast);
            this.writeHeader();
        } else {
            if (this.recent != null && newLast == this.recent.index) {
                this.recent = null;
            }
            this.lastPage = new Page(newLast, pageSize, this.header.getRecordSize());
            this.writePage(this.lastPage);
            this.header.setLastPage(newLast);
            if (this.header.getPageCount() == 0) {
                this.firstPage = this.lastPage;
                this.header.setFirstPage(0);
            }
            if (newLast == this.header.getPageCount()) {
                this.header.incrementPageCount();
            }
            this.writeHeader();
        }
    }

    private boolean writeHeader() throws IOException {
        if (!this.header.isDirty()) {
            return false;
        }
        this.table.seek(0L);
        this.header.write(this.table.out());
        ++this.headerWriteCount;
        return true;
    }

    private boolean writePage(Page page) throws IOException {
        if (page == null || !page.isDirty()) {
            return false;
        }
        this.table.seek(64L + (long)this.header.getPageSize() * (long)page.index);
        page.write(this.table.out());
        ++this.pageWriteCount;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter out) throws IOException {
        out.println("\n\n=== " + (Object)((Object)this.table.getConfig().getId()) + " ===");
        Object object = this.table.getTableLock();
        synchronized (object) {
            int first = this.header.getFirstPage();
            int last = this.header.getLastPage();
            int pageCount = this.header.getPageCount();
            BHistoryConfig config = this.table.getConfig();
            BHistoryRecord rec = config.makeRecord();
            out.println("---------- Header ----------");
            this.header.dump(out);
            out.println("----------------------------");
            for (int i = 0; i < pageCount; ++i) {
                out.print(i);
                out.print(": ");
                Page p = this.getPage(i);
                boolean sp = false;
                if (i == first) {
                    sp = true;
                    out.print("[first]");
                }
                if (i == last) {
                    sp = true;
                    out.print("[last]");
                }
                if (this.recent != null && i == this.recent.index) {
                    sp = true;
                    out.print("[recent]");
                }
                if (sp) {
                    out.print(" ");
                }
                if (first < last && (i < first || i > last)) {
                    out.print("[unused] ");
                } else if (i > last && i < first) {
                    out.print("[unused] ");
                }
                out.print(p.getRecordCount());
                out.print(" records");
                if (p.getRecordCount() != 0) {
                    out.print(' ');
                    p.read(p.getFirstIndex(), rec);
                    out.print(p.getFirstIndex() + ": " + rec);
                    out.print(" - ");
                    p.read(p.getLastIndex(), rec);
                    out.print(p.getLastIndex() + ": " + rec);
                }
                out.println();
            }
            out.flush();
        }
    }

    public void spy(SpyWriter out) throws IOException {
        out.startProps();
        out.trTitle((Object)this.table.getConfig().getId().getHistoryDisplayName(), 2);
        out.prop((Object)"pageSize", this.header.getPageSize());
        out.prop((Object)"recordSize", this.recordSize);
        out.prop((Object)"capacity", this.capacity);
        out.prop((Object)"firstPage", this.header.getFirstPage());
        out.prop((Object)"lastPage", this.header.getLastPage());
        out.prop((Object)"recordCount", this.recordCount);
        out.prop((Object)"record appends", this.totalRecordAppends);
        out.prop((Object)"header writes", this.headerWriteCount);
        out.prop((Object)"page writes", this.pageWriteCount);
        out.prop((Object)"first page hits", this.firstPageHits);
        out.prop((Object)"last page hits", this.lastPageHits);
        out.prop((Object)"recent page hits", this.recentPageHits);
        out.prop((Object)"pages misses", this.pageMisses);
        out.endProps();
    }

    public int getPageWriteCount() {
        return this.pageWriteCount;
    }

    public int getHeaderWriteCount() {
        return this.headerWriteCount;
    }

    public int getTotalRecordAppends() {
        return this.totalRecordAppends;
    }
}

