/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;

public class Page {
    private static final int HEADER_SIZE = 8;
    public final int index;
    private int recSize;
    private int first;
    private int last;
    private byte[] buf;
    private int maxRecords;
    private boolean dirty;
    private PageInput pageIn;
    private PageOutput pageOut;

    public Page(int index, int size, int recSize) {
        this.index = index;
        this.recSize = recSize;
        this.buf = new byte[size];
        this.last = -1;
        this.first = -1;
        this.maxRecords = Page.computeRecordsPerPage(size, recSize);
        this.pageOut = new PageOutput();
        this.pageIn = new PageInput();
        this.dirty = true;
    }

    public static int computeRecordsPerPage(int pageSize, int recSize) {
        return (pageSize - 8) / recSize;
    }

    public int getRecordCount() {
        if (this.first == -1) {
            return 0;
        }
        return this.last - this.first + 1;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public int trimFromStart(int trimCount) {
        if (this.first + trimCount > this.maxRecords) {
            throw new IllegalArgumentException(this.first + trimCount + " > " + this.maxRecords);
        }
        this.first += trimCount;
        this.dirty = true;
        return this.getRecordCount();
    }

    public synchronized boolean isDirty() {
        return this.dirty;
    }

    public synchronized void read(DataInput in) throws IOException {
        in.readFully(this.buf);
        this.pageOut.reset();
        this.pageIn.reset();
        this.first = this.pageIn.readInt();
        this.last = this.pageIn.readInt();
        this.dirty = false;
    }

    public synchronized void write(DataOutput out) throws IOException {
        this.pageOut.seek(0);
        this.pageOut.writeInt(this.first);
        this.pageOut.writeInt(this.last);
        out.write(this.buf, 0, this.buf.length);
        this.dirty = false;
    }

    public synchronized boolean isFull() {
        return 8 + (this.last + 1) * this.recSize + this.recSize > this.buf.length;
    }

    public synchronized int getFirstIndex() {
        return this.first;
    }

    public synchronized int getLastIndex() {
        return this.last;
    }

    public synchronized void read(int index, BHistoryRecord rec) throws IOException {
        this.pageIn.seek(index * this.recSize + 8);
        rec.read(this.pageIn);
    }

    public synchronized BAbsTime readTimestamp(int index) throws IOException {
        this.pageIn.seek(index * this.recSize + 8);
        return (BAbsTime)BAbsTime.DEFAULT.decode48((DataInput)this.pageIn);
    }

    public synchronized boolean append(BHistoryRecord rec) throws IOException {
        if (this.last + 1 == this.maxRecords) {
            return false;
        }
        if (this.first == -1) {
            this.last = 0;
            this.first = 0;
        } else {
            ++this.last;
        }
        this.pageOut.seek(this.last * this.recSize + 8);
        rec.write(this.pageOut);
        this.pageIn.seek(this.last * this.recSize + 8);
        rec.read(this.pageIn);
        this.dirty = true;
        return true;
    }

    public synchronized boolean set(int index, BHistoryRecord rec) throws IOException {
        if (index >= this.maxRecords) {
            return false;
        }
        this.pageOut.seek(index * this.recSize + 8);
        rec.write(this.pageOut);
        this.dirty = true;
        return true;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Page ").append(this.index);
        s.append(": first=").append(this.first);
        s.append(" last=").append(this.last);
        return s.toString();
    }

    private final class PageInput
    implements DataInput {
        private int offset;

        public PageInput() {
            this.reset();
        }

        public void reset() {
            this.offset = 0;
        }

        public void seek(int newOffset) {
            this.offset = newOffset;
        }

        public int read() throws IOException {
            try {
                return Page.this.buf[this.offset++] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EOFException();
            }
        }

        public int read(byte[] rbuf) throws IOException {
            return this.read(rbuf, 0, Page.this.buf.length);
        }

        public int read(byte[] rbuf, int roffset, int rlen) throws IOException {
            int bytes = Math.min(rlen, Page.this.buf.length - this.offset);
            System.arraycopy(Page.this.buf, this.offset, rbuf, roffset, bytes);
            this.offset += bytes;
            return bytes;
        }

        @Override
        public void readFully(byte[] rbuf) throws IOException {
            this.readFully(rbuf, 0, rbuf.length);
        }

        @Override
        public void readFully(byte[] rbuf, int roffset, int rlen) throws IOException {
            int bytes = this.read(rbuf, roffset, rlen);
            if (bytes != rlen) {
                throw new EOFException();
            }
        }

        @Override
        public int skipBytes(int n) throws IOException {
            this.offset += n;
            if (this.offset >= Page.this.buf.length) {
                throw new EOFException();
            }
            return n;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.read() != 0;
        }

        @Override
        public byte readByte() throws IOException {
            return (byte)this.read();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.read();
        }

        @Override
        public short readShort() throws IOException {
            return (short)((this.read() << 8) + this.read());
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return (this.read() << 8) + this.read();
        }

        @Override
        public char readChar() throws IOException {
            return (char)((this.read() << 8) + this.read());
        }

        @Override
        public int readInt() throws IOException {
            return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + (this.read() << 0);
        }

        @Override
        public long readLong() throws IOException {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            throw new UnsupportedOperationException("readUTF not supported");
        }
    }

    private final class PageOutput
    implements DataOutput {
        private int offset;

        public PageOutput() {
            this.reset();
        }

        public void reset() {
            this.offset = 0;
        }

        public void seek(int newOffset) {
            this.offset = newOffset;
        }

        @Override
        public void write(int b) {
            ((Page)Page.this).buf[this.offset++] = (byte)b;
        }

        @Override
        public void write(byte[] wbuf) {
            this.write(wbuf, 0, wbuf.length);
        }

        @Override
        public void write(byte[] wbuf, int woffset, int wlen) {
            System.arraycopy(wbuf, woffset, Page.this.buf, this.offset, wlen);
            this.offset += wlen;
        }

        @Override
        public void writeBoolean(boolean v) {
            this.write(v ? 1 : 0);
        }

        @Override
        public void writeByte(int v) {
            this.write(v);
        }

        @Override
        public void writeShort(int v) {
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }

        @Override
        public void writeChar(int v) {
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }

        @Override
        public void writeInt(int v) {
            this.write(v >>> 24 & 0xFF);
            this.write(v >>> 16 & 0xFF);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }

        @Override
        public void writeLong(long v) {
            this.write((int)(v >>> 56) & 0xFF);
            this.write((int)(v >>> 48) & 0xFF);
            this.write((int)(v >>> 40) & 0xFF);
            this.write((int)(v >>> 32) & 0xFF);
            this.write((int)(v >>> 24) & 0xFF);
            this.write((int)(v >>> 16) & 0xFF);
            this.write((int)(v >>> 8) & 0xFF);
            this.write((int)(v >>> 0) & 0xFF);
        }

        @Override
        public void writeFloat(float v) {
            this.writeInt(Float.floatToIntBits(v));
        }

        @Override
        public void writeDouble(double v) {
            this.writeLong(Double.doubleToLongBits(v));
        }

        @Override
        public void writeBytes(String s) {
            int strlen = s.length();
            for (int i = 0; i < strlen; ++i) {
                this.write((byte)s.charAt(i));
            }
        }

        @Override
        public void writeChars(String s) {
            int strlen = s.length();
            for (int i = 0; i < strlen; ++i) {
                char v = s.charAt(i);
                this.write(v >>> 8 & 0xFF);
                this.write(v >>> 0 & 0xFF);
            }
        }

        @Override
        public void writeUTF(String s) throws UTFDataFormatException {
            throw new UnsupportedOperationException("writeUTF not supported");
        }
    }
}

