/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.exporters;

import com.tridium.file.exporters.BITableToCsv;
import com.tridium.history.BHistory;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.baja.file.ExportOp;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHistoryToCsv
extends BITableToCsv {
    public static final Type TYPE = Sys.loadType(BHistoryToCsv.class);

    public Type getType() {
        return TYPE;
    }

    public void export(ExportOp op) throws Exception {
        op.mergeFacets(this.getFacets());
        BHistory history = (BHistory)op.get();
        PrintWriter out = new PrintWriter(new OutputStreamWriter(op.getOutputStream(), StandardCharsets.UTF_8));
        if (this.getIncludeBOM()) {
            out.print("\ufeff");
            out.flush();
        }
        if (this.getIncludeHeaders()) {
            out.print("history:" + history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
            out.print(this.getLineEnding());
            out.print(this.getLineEnding());
            out.flush();
        }
        this.export(history, op);
    }
}

