/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.history.HistoryBqlRow;
import com.tridium.util.HistoryCategoryUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Row;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;

public final class HistoryDbCursor
extends AbstractTableCursor<BHistoryConfig> {
    private final Cursor<BHistoryConfig> inner;

    public HistoryDbCursor(BHistoryDatabase db, Cursor<BHistoryConfig> inner) {
        super((BITable)db);
        this.inner = inner;
    }

    public Context getContext() {
        return this.inner.getContext();
    }

    protected boolean advanceCursor() {
        BUser currentUser = BUser.getCurrentAuthenticatedUser();
        if (currentUser == null) {
            return this.inner.next();
        }
        BPermissionsMap pmap = currentUser.getPermissions();
        if (pmap.isSuperUser()) {
            return this.inner.next();
        }
        String stationName = Sys.getStation().getStationName();
        while (this.inner.next()) {
            BHistoryConfig config = (BHistoryConfig)((Object)this.inner.get());
            BCategoryMask mask = HistoryCategoryUtil.getAppliedCategoryMask((BOrd)BOrd.make((String)("history:" + config.getId().encodeToString())), (String)stationName);
            BPermissions permissions = pmap.getCategoryPermissions(mask);
            if (!permissions.hasOperatorRead()) continue;
            return true;
        }
        return false;
    }

    public Row<BHistoryConfig> row() {
        return new HistoryBqlRow<BValue>(this.getTable(), (BValue)this.inner.get());
    }

    protected void closeCursor() {
        this.inner.close();
    }
}

