/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.history.BHistory;
import com.tridium.history.db.BHistoryDbTable;
import com.tridium.history.db.BHistoryQueryResult;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.db.TableHandle;
import javax.baja.bql.BqlQuery;
import javax.baja.bql.Queryable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;

public class BLocalDbHistory
extends BHistory
implements Queryable {
    public static final Type TYPE = Sys.loadType(BLocalDbHistory.class);
    private TableHandle tableHandle;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BLocalDbHistory(BLocalHistoryDatabase db, BHistoryId id) {
        super(db, id);
    }

    public String getNavDisplayName(Context cx) {
        BObject obj;
        boolean fullName = false;
        if (cx != null && (obj = cx.getFacet("fullHistoryDisplayName")) instanceof BBoolean) {
            fullName = ((BBoolean)obj).getBoolean();
        }
        String result = null;
        BFormat displayName = BHistory.getHistoryDisplayNameFormat(this);
        result = displayName != null ? displayName.format((Object)this, cx) : SlotPath.unescape((String)this.getId().getHistoryName());
        if (fullName) {
            StringBuffer sb = new StringBuffer();
            sb.append(SlotPath.unescape((String)this.getId().getDeviceName()));
            sb.append('/');
            sb.append(result);
            return sb.toString();
        }
        return result;
    }

    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null) {
            return cx.getUser().getPermissionsFor((BIProtected)this);
        }
        return BPermissions.all;
    }

    @Override
    public BTypeSpec getRecordType() {
        return this.getConfig().getRecordType();
    }

    @Override
    public BHistoryConfig getConfig() throws HistoryException {
        return this.getTable().getConfig();
    }

    public void setConfig(BHistoryConfig config) {
        this.getTable().setConfig(config);
    }

    public TableCursor<BHistoryRecord> cursor() {
        try (HistorySpaceConnection conn = ((BHistorySpace)this.getSpace()).getConnection(null);){
            TableCursor tableCursor = conn.timeQuery(this, null, null).cursor();
            return tableCursor;
        }
    }

    public ColumnList getColumns() {
        try (HistorySpaceConnection conn = ((BHistorySpace)this.getSpace()).getConnection(null);){
            ColumnList columnList = conn.timeQuery(this, null, null).getColumns();
            return columnList;
        }
    }

    public BFacets getTableFacets() {
        try (HistorySpaceConnection conn = ((BHistorySpace)this.getSpace()).getConnection(null);){
            BFacets bFacets = conn.timeQuery(this, null, null).getTableFacets();
            return bFacets;
        }
    }

    @Override
    public Cursor<BHistoryRecord> timeQueryCursor(BAbsTime startTime, BAbsTime endTime, boolean descending) {
        return this.getTable().timeQuery(startTime, endTime, descending);
    }

    public BObject bqlQuery(OrdTarget base, OrdQuery q) {
        return new BHistoryQueryResult(this, (BqlQuery)q);
    }

    Cursor<BHistoryRecord> doBqlQuery(BqlQuery q) {
        return this.getTable().bqlQuery(q);
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized int updateHistorySubscriptionCount(BComponent source, int change, Context cx) {
        return this.getTable().updateHistorySubscriptionCount(source, change);
    }

    protected synchronized TableHandle getTable() throws HistoryException {
        if (this.tableHandle == null || !this.tableHandle.isBound()) {
            BHistoryDbTable table = ((BLocalHistoryDatabase)this.getHistorySpace()).getTable(this.getId());
            if (table == null) {
                throw new HistoryNotFoundException(this.getId());
            }
            if (!table.getConfig().getId().equals((Object)this.getId())) {
                throw new HistoryException("id mismatch " + (Object)((Object)table.getConfig().getId()) + " != " + (Object)((Object)this.getId()));
            }
            this.tableHandle = table.getTableHandle();
        }
        if (this.tableHandle == null) {
            throw new HistoryNotFoundException(this.getId());
        }
        return this.tableHandle;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 1200) {
            return this.getTable();
        }
        return super.fw(x, a, b, c, d);
    }
}

