/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import javax.baja.collection.AbstractCursor;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BRolloverValue;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

public class DeltaCursor
extends AbstractCursor<BHistoryRecord> {
    private final Cursor<BHistoryRecord> cursor;
    private final BRolloverValue minValue;
    private final BRolloverValue maxValue;
    private final BNumericTrendRecord referenceRecord;
    private BHistoryRecord iteratorRec;
    private boolean firstRecord = true;
    private double lastValue = Double.NaN;
    private BStatus lastStatus = BStatus.DEFAULT;

    public DeltaCursor(Cursor<BHistoryRecord> cursor, BRolloverValue minValue, BRolloverValue maxValue, BNumericTrendRecord referenceRecord) {
        this.cursor = cursor;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.referenceRecord = referenceRecord;
    }

    public Context getContext() {
        return this.cursor.getContext();
    }

    protected boolean advanceCursor() {
        boolean retVal = this.cursor.next();
        if (retVal) {
            BHistoryRecord obj = (BHistoryRecord)this.cursor.get();
            if (obj instanceof BNumericTrendRecord) {
                double deltaVal;
                BNumericTrendRecord rec = (BNumericTrendRecord)obj;
                double val = rec.getValue();
                BStatus stat = rec.getStatus();
                if (this.firstRecord) {
                    this.firstRecord = false;
                    if (this.referenceRecord == null) {
                        this.lastValue = val;
                        this.lastStatus = stat;
                        return this.next();
                    }
                    this.lastValue = this.referenceRecord.getValue();
                    this.lastStatus = this.referenceRecord.getStatus();
                }
                if (this.maxValue != null && !this.maxValue.getUnspecified() && val < this.lastValue) {
                    double min = 0.0;
                    if (this.minValue != null && !this.minValue.getUnspecified()) {
                        min = this.minValue.getValue();
                    }
                    deltaVal = this.maxValue.getValue() - this.lastValue + val - min;
                } else {
                    deltaVal = val - this.lastValue;
                }
                BStatus status = BStatus.make((int)(stat.getBits() | this.lastStatus.getBits()), (BFacets)BFacets.make((BFacets)this.lastStatus.getFacets(), (BFacets)stat.getFacets()));
                if (!Double.isNaN(val)) {
                    this.lastValue = val;
                    this.lastStatus = stat;
                }
                rec.setValue(deltaVal);
                rec.setStatus(status);
                this.iteratorRec = rec;
            } else if (obj instanceof BHistoryRecord) {
                this.iteratorRec = obj;
            } else {
                retVal = false;
            }
        }
        return retVal;
    }

    public boolean nextComponent() {
        return false;
    }

    protected BHistoryRecord doGet() {
        return this.iteratorRec;
    }
}

