/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.bql.collection.TypeColumnList;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryMirror;
import com.tridium.history.BIHistoryNavSupport;
import com.tridium.history.HistoryBqlRow;
import com.tridium.history.IdCursor;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.util.ArrayUtil;
import com.tridium.util.HistoryCategoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.baja.agent.AgentList;
import javax.baja.bql.BIRelational;
import javax.baja.category.BCategoryMask;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.LexiconText;

public class BHistoryFolder
extends BObject
implements BISpaceNode,
BITable<BHistoryId>,
BIRelational<BIObject> {
    public static final Type TYPE = Sys.loadType(BHistoryFolder.class);
    private static final BIcon icon = BIcon.std((String)"folder.png");
    private static final BIcon defaultFolderIcon = BIcon.std((String)"deviceFolder.png");
    static final LexiconText defaultFolderTxt = LexiconText.make((String)"history", (String)"space.history.defaultFolder");
    private static ThreadLocal<BHistoryFolder> retrievingNavChildren = new ThreadLocal();
    BHistorySpace space;
    BOrd navOrd;
    BOrd ordInSpace;
    String[] folderPath;
    String folderId;
    BINavNode navParent;
    ColumnList columnList;

    public Type getType() {
        return TYPE;
    }

    public BHistoryFolder(BHistorySpace space, String[] folderPath, BINavNode navParent) {
        this.space = space;
        this.folderPath = folderPath;
        this.navParent = navParent;
        if (folderPath == null) {
            this.folderId = "history:///";
            this.ordInSpace = BOrd.make((String)"history:///");
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("history:/");
            for (int i = 0; i < folderPath.length; ++i) {
                sb.append("/").append(SlotPath.escape((String)folderPath[i]));
            }
            this.folderId = sb.toString();
            this.ordInSpace = BOrd.make((String)this.folderId);
        }
    }

    public String getHistoryFolderName() {
        if (this.folderPath != null) {
            return this.folderPath[this.folderPath.length - 1];
        }
        return "/";
    }

    public BSpace getSpace() {
        return this.space;
    }

    public BOrd getOrdInSession() {
        return this.getOrdInSpace();
    }

    public BOrd getOrdInSpace() {
        if (this.space == null) {
            return null;
        }
        return this.ordInSpace;
    }

    public boolean isPendingMove() {
        return false;
    }

    public void setPendingMove(boolean pendingMove) {
    }

    public BOrd getNavOrd() {
        if (this.navOrd == null) {
            this.navOrd = BOrd.make((String)(this.space.getNavOrd() + this.folderId.substring(8)));
        }
        return this.navOrd;
    }

    public String getNavName() {
        return this.folderId;
    }

    public String getNavDisplayName(Context cx) {
        if (this.folderPath != null) {
            return this.folderPath[this.folderPath.length - 1];
        }
        return defaultFolderTxt.getText(cx);
    }

    public BIcon getNavIcon() {
        return this.getIcon();
    }

    public String getNavDescription(Context cx) {
        return null;
    }

    public BINavNode getNavParent() {
        return this.navParent;
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String name) {
        BINavNode node;
        boolean init;
        Map folderCache = (Map)this.space.fw(9904);
        if (folderCache == null) {
            return null;
        }
        Map childFolders = (Map)folderCache.get((Object)this);
        boolean bl = init = childFolders == null;
        if (init) {
            this.getNavChildren();
            childFolders = (Map)folderCache.get((Object)this);
        }
        if ((node = (BINavNode)childFolders.get(name)) == null && !init && this.space instanceof BHistoryDatabase) {
            this.getNavChildren();
            childFolders = (Map)folderCache.get((Object)this);
            node = (BINavNode)childFolders.get(name);
        }
        return node;
    }

    public BINavNode resolveNavChild(String name) {
        BINavNode child = this.getNavChild(name);
        if (child == null) {
            throw new UnresolvedException(name);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public BINavNode[] getNavChildren() {
        try {
            Object[] devNames;
            retrievingNavChildren.set(this);
            Map folderCache = (Map)this.space.fw(9904);
            if (folderCache == null) {
                BINavNode[] bINavNodeArray = new BINavNode[]{};
                return bINavNodeArray;
            }
            if (BIHistoryNavSupport.getHistoryNavSupport() != null && BIHistoryNavSupport.getHistoryNavSupport().performingRefresh((BINavNode)this)) {
                Object[] keys = folderCache.keySet().toArray();
                int len = keys != null ? keys.length : 0;
                for (int i = 0; i < len; ++i) {
                    if (!(keys[i] instanceof BHistoryFolder)) continue;
                    BHistoryFolder key = (BHistoryFolder)((Object)keys[i]);
                    if (!key.folderId.startsWith(this.folderId)) continue;
                    folderCache.remove((Object)key);
                }
                folderCache.remove((Object)this);
            }
            Map<String, BINavNode> childFolders = Collections.synchronizedMap(new HashMap());
            if (this.folderPath == null) {
                BHistoryDevice[] devs = this.space.listDevices();
                if (devs == null) {
                    BINavNode[] i = null;
                    return i;
                }
                int len = devs.length;
                devNames = new String[len];
                for (int i = 0; i < devs.length; ++i) {
                    devNames[i] = devs[i].getDeviceName();
                    childFolders.put((String)devNames[i], (BINavNode)devs[i]);
                }
                SortUtil.sort((Object[])devNames, (Object[])devs);
                folderCache.put(this, childFolders);
                BHistoryDevice[] i = devs;
                return i;
            }
            if (this.space instanceof BFoxHistorySpace) {
                BFoxHistorySpace fSpace = (BFoxHistorySpace)this.space;
                try {
                    BINavNode[] children = fSpace.channel().getFolderNavChildren(fSpace, this.folderPath, (BINavNode)this, childFolders);
                    folderCache.put(this, childFolders);
                    devNames = children;
                    return devNames;
                }
                catch (Exception e) {
                    System.out.println("Could not load nav children for " + this.folderId);
                    e.printStackTrace();
                    devNames = new BINavNode[]{};
                    retrievingNavChildren.set(null);
                    return devNames;
                }
            }
            String[] aNames = BHistoryService.getSortPropertiesForGroup((BObject)this.space, this.folderPath[0]);
            if (aNames != null && aNames.length > 0) {
                ArrayList<BHistoryFolder> historyFolders = new ArrayList<BHistoryFolder>();
                ArrayList<String> historyFolderNames = new ArrayList<String>();
                ArrayList<BHistoryMirror> myHistories = new ArrayList<BHistoryMirror>();
                ArrayList<String> historyNames = new ArrayList<String>();
                if (this.space instanceof BLocalHistoryDatabase) {
                    TableCursor<BHistoryConfig> c = ((BLocalHistoryDatabase)this.space).cursor();
                    while (c.next()) {
                        Object val;
                        BHistoryConfig config = (BHistoryConfig)((Object)c.get());
                        boolean match = true;
                        for (int k = 1; k < this.folderPath.length; ++k) {
                            val = config.get(aNames[k - 1]);
                            if (val != null && this.folderPath[k].equals(val.toString())) continue;
                            match = false;
                            break;
                        }
                        if (!match) continue;
                        HistorySpaceConnection conn = this.space.getConnection(null);
                        val = null;
                        try {
                            BIHistory history = conn.getHistory(config.getId());
                            if (aNames.length > this.folderPath.length - 1) {
                                String str;
                                BValue v = config.get(aNames[this.folderPath.length - 1]);
                                String val2 = null;
                                if (v != null && (str = v.toString()) != null && str.length() > 0) {
                                    val2 = str;
                                }
                                if (val2 != null) {
                                    String folderName = val2;
                                    if (historyFolderNames.contains(folderName)) continue;
                                    historyFolderNames.add(folderName);
                                    String[] path = new String[this.folderPath.length + 1];
                                    for (int x = 0; x < this.folderPath.length; ++x) {
                                        path[x] = this.folderPath[x];
                                    }
                                    path[this.folderPath.length] = folderName;
                                    BHistoryFolder f = new BHistoryFolder(this.space, path, (BINavNode)this);
                                    historyFolders.add(f);
                                    childFolders.put(this.folderId + "/" + SlotPath.escape((String)folderName), (BINavNode)f);
                                    continue;
                                }
                                if (this.folderPath.length <= 1) continue;
                                BHistoryMirror mirror = new BHistoryMirror(history, (BINavNode)this);
                                myHistories.add(mirror);
                                historyNames.add(history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
                                childFolders.put(mirror.getNavName(), (BINavNode)mirror);
                                continue;
                            }
                            if (this.folderPath.length <= 1) continue;
                            BHistoryMirror mirror = new BHistoryMirror(history, (BINavNode)this);
                            myHistories.add(mirror);
                            historyNames.add(history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
                            childFolders.put(mirror.getNavName(), (BINavNode)mirror);
                        }
                        catch (Throwable history) {
                            val = history;
                            throw history;
                        }
                        finally {
                            if (conn == null) continue;
                            if (val != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable history) {
                                    ((Throwable)val).addSuppressed(history);
                                }
                                continue;
                            }
                            conn.close();
                        }
                    }
                } else {
                    BHistoryDevice[] devs = this.space.listDevices();
                    int len = devs.length;
                    for (int i = 0; i < len; ++i) {
                        BIHistory[] histories = this.space.listHistories(devs[i]);
                        int num = histories.length;
                        for (int j = 0; j < num; ++j) {
                            Object val;
                            boolean match = true;
                            for (int k = 1; k < this.folderPath.length; ++k) {
                                val = histories[j].get(aNames[k - 1]);
                                if (val != null && this.folderPath[k].equals(val.toString())) continue;
                                match = false;
                                break;
                            }
                            if (!match) continue;
                            if (aNames.length > this.folderPath.length - 1) {
                                String str;
                                BValue v = histories[j].get(aNames[this.folderPath.length - 1]);
                                val = null;
                                if (v != null && (str = v.toString()) != null && str.length() > 0) {
                                    val = str;
                                }
                                if (val != null) {
                                    BValue folderName = val;
                                    if (historyFolderNames.contains(folderName)) continue;
                                    historyFolderNames.add((String)folderName);
                                    String[] path = new String[this.folderPath.length + 1];
                                    for (int x = 0; x < this.folderPath.length; ++x) {
                                        path[x] = this.folderPath[x];
                                    }
                                    path[this.folderPath.length] = folderName;
                                    BHistoryFolder f = new BHistoryFolder(this.space, path, (BINavNode)this);
                                    historyFolders.add(f);
                                    childFolders.put(this.folderId + "/" + SlotPath.escape((String)folderName), (BINavNode)f);
                                    continue;
                                }
                                if (this.folderPath.length <= 1) continue;
                                BHistoryMirror mirror = new BHistoryMirror(histories[j], (BINavNode)this);
                                myHistories.add(mirror);
                                historyNames.add(histories[j].getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
                                childFolders.put(mirror.getNavName(), (BINavNode)mirror);
                                continue;
                            }
                            if (this.folderPath.length <= 1) continue;
                            BHistoryMirror mirror = new BHistoryMirror(histories[j], (BINavNode)this);
                            myHistories.add(mirror);
                            historyNames.add(histories[j].getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
                            childFolders.put(mirror.getNavName(), (BINavNode)mirror);
                        }
                    }
                }
                Object[] names = historyFolderNames.toArray(new String[historyFolderNames.size()]);
                Object[] folders = historyFolders.toArray(new BINavNode[historyFolders.size()]);
                SortUtil.sort((Object[])names, (Object[])folders);
                Object[] hNames = historyNames.toArray(new String[historyNames.size()]);
                Object[] hists = myHistories.toArray(new BINavNode[myHistories.size()]);
                SortUtil.sort((Object[])hNames, (Object[])hists);
                folderCache.put(this, childFolders);
                BINavNode[] bINavNodeArray = (BINavNode[])ArrayUtil.add((Object[])folders, (Object[])hists);
                return bINavNodeArray;
            }
            folderCache.put(this, childFolders);
            BINavNode[] bINavNodeArray = new BINavNode[]{};
            return bINavNodeArray;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            retrievingNavChildren.set(null);
        }
    }

    public void addNavChild(BINavNode child) {
        throw new UnsupportedOperationException();
    }

    public void removeNavChild(BINavNode child) {
        throw new UnsupportedOperationException();
    }

    public BITable<BIObject> getRelation(String id, Context cx) {
        BOrd histOrd = BOrd.make((BOrd)this.getOrdInSpace(), (OrdQuery)new HistoryQuery(id));
        try {
            return (BITable)histOrd.get((BObject)BLocalHost.INSTANCE, cx);
        }
        catch (UnresolvedException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCursor<BHistoryId> cursor() {
        ArrayList<BIHistory> myHistories = new ArrayList<BIHistory>();
        ArrayList<String> historyNames = new ArrayList<String>();
        Map folderCache = (Map)this.space.fw(9904);
        if (this.folderPath != null && folderCache != null) {
            Map childFolders = (Map)folderCache.get((Object)this);
            if (childFolders == null) {
                this.getNavChildren();
                childFolders = (Map)folderCache.get((Object)this);
            }
            if (childFolders != null) {
                Map map = childFolders;
                synchronized (map) {
                    for (Object obj : childFolders.values()) {
                        if (!(obj instanceof BIHistory)) continue;
                        BIHistory history = (BIHistory)obj;
                        myHistories.add(history);
                        historyNames.add(history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
                    }
                }
            }
        }
        Object[] hNames = historyNames.toArray(new String[historyNames.size()]);
        Object[] hists = myHistories.toArray(new BIHistory[myHistories.size()]);
        SortUtil.sort((Object[])hNames, (Object[])hists);
        return new HistoryIdTableCursor(this, new IdCursor((BIHistory[])hists, Context.NULL));
    }

    public ColumnList getColumns() {
        if (this.columnList == null) {
            this.columnList = new TypeColumnList(BHistoryId.TYPE, Context.NULL);
        }
        return this.columnList;
    }

    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.add("workbench:NavContainerView");
        agents.remove("workbench:CollectionTable");
        return agents;
    }

    public BIcon getIcon() {
        if (this.folderPath != null) {
            return icon;
        }
        return defaultFolderIcon;
    }

    public boolean equals(Object obj) {
        BIHistoryNavSupport support = BIHistoryNavSupport.getHistoryNavSupport();
        if (support != null && support.performingRefresh(this.navParent) && this != retrievingNavChildren.get()) {
            return this == obj;
        }
        if (obj instanceof BHistoryFolder) {
            return this.folderId.equals(((BHistoryFolder)((Object)obj)).folderId);
        }
        return false;
    }

    public int hashCode() {
        return this.folderId.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"FolderCache", 1);
        Map folderCache = (Map)this.space.fw(9904);
        if (folderCache != null) {
            Map map = (Map)folderCache.get((Object)this);
            if (map != null) {
                Map map2 = map;
                synchronized (map2) {
                    for (Object nKey : map.keySet()) {
                        BINavNode node = (BINavNode)map.get(nKey);
                        String navName = node.getNavName();
                        out.tr().td().a(SlotPath.escape((String)navName), (Object)navName).w((Object)" [").safe((Object)node.getNavOrd()).w((Object)"]").endTd().endTr();
                    }
                }
            } else {
                out.prop((Object)"History nav children not lazy loaded yet.", (Object)"");
            }
        } else {
            out.prop((Object)"FolderCache is null", (Object)"");
        }
        out.endProps();
    }

    public static class HistoryIdTableCursor
    extends AbstractTableCursor<BHistoryId> {
        private final IdCursor inner;

        public HistoryIdTableCursor(BITable<BHistoryId> table, IdCursor inner) {
            super(table);
            this.inner = inner;
        }

        public Context getContext() {
            return this.inner.getContext();
        }

        protected boolean advanceCursor() {
            BUser currentUser = BUser.getCurrentAuthenticatedUser();
            if (currentUser == null) {
                return this.inner.next();
            }
            BPermissionsMap pmap = currentUser.getPermissions();
            if (pmap.isSuperUser()) {
                return this.inner.next();
            }
            String stationName = Sys.getStation().getStationName();
            while (this.inner.next()) {
                BHistoryId id = (BHistoryId)((Object)this.inner.get());
                BCategoryMask mask = HistoryCategoryUtil.getAppliedCategoryMask((BOrd)BOrd.make((String)("history:" + id.encodeToString())), (String)stationName);
                BPermissions permissions = pmap.getCategoryPermissions(mask);
                if (!permissions.hasOperatorRead()) continue;
                return true;
            }
            return false;
        }

        public Row<BHistoryId> row() {
            return new HistoryBqlRow<BValue>(this.getTable(), (BValue)this.inner.get());
        }

        protected void closeCursor() {
            this.inner.close();
        }
    }
}

