/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.HistoryProperty;
import com.tridium.history.HistoryPropertyCursor;
import com.tridium.history.HistorySlot;
import com.tridium.history.HistorySlotCursor;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.history.util.HistoryUtil;
import com.tridium.util.HistoryCategoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIChartableHistoryAgent;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.history.BITrendHistoryAgent;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;

public abstract class BHistory
extends BObject
implements BIHistory,
BITable<BHistoryRecord> {
    public static final Type TYPE = Sys.loadType(BHistory.class);
    private static final BIcon icon = BIcon.std((String)"history.png");
    public static final Context FULL_DISPLAY_NAME_CX = BFacets.make((String)"fullHistoryDisplayName", (boolean)true);
    static Type historyImportType = null;
    static Logger log = Logger.getLogger("history");
    static AgentFilter trendFilter = AgentFilter.is((Type)BITrendHistoryAgent.TYPE);
    static AgentFilter chartableFilter = AgentFilter.is((Type)BIChartableHistoryAgent.TYPE);
    private final BHistoryId id;
    private final BHistorySpace space;
    private HashMap<Subscriber, BComponent> subscribers = null;

    public Type getType() {
        return TYPE;
    }

    public BHistory(BHistorySpace space, BHistoryId id) {
        this.space = space;
        this.id = id;
    }

    public BHistorySpace getHistorySpace() {
        return this.space;
    }

    @Override
    public BHistoryId getId() {
        return this.id;
    }

    public abstract Cursor<BHistoryRecord> timeQueryCursor(BAbsTime var1, BAbsTime var2, boolean var3) throws HistoryException;

    public abstract int updateHistorySubscriptionCount(BComponent var1, int var2, Context var3);

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BIHistory)) {
            return false;
        }
        BIHistory other = (BIHistory)o;
        return other.getId().equals((Object)this.getId()) && other.getSpace().equals((Object)this.getSpace());
    }

    public BCategoryMask getCategoryMask() {
        return HistoryCategoryUtil.getCategoryMask((BOrd)this.getNavOrd(), (String)Sys.getStation().getStationName());
    }

    public BCategoryMask getAppliedCategoryMask() {
        return HistoryCategoryUtil.getAppliedCategoryMask((BOrd)this.getNavOrd(), (String)Sys.getStation().getStationName());
    }

    public boolean canRead(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorRead();
    }

    public boolean canWrite(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasAdminWrite();
    }

    public boolean canInvoke(OrdTarget cx) {
        return false;
    }

    public BSpace getSpace() {
        return this.space;
    }

    public BOrd getOrdInSession() {
        return this.getOrdInSpace();
    }

    public BOrd getOrdInSpace() {
        return BOrd.make((String)("history:" + (Object)((Object)this.getId())));
    }

    public String getNavName() {
        return this.getId().getHistoryName();
    }

    public String getNavDescription(Context cx) {
        return this.getConfig().toString();
    }

    public BINavNode getNavParent() {
        return this.getHistorySpace().getDevice(this.getId().getDeviceName());
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BINavNode getNavChild(String navName) {
        return null;
    }

    public BINavNode resolveNavChild(String navName) {
        throw new UnresolvedException();
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public BOrd getNavOrd() {
        BSpace space = this.getSpace();
        if (space == null) {
            return null;
        }
        BOrd spaceNav = space.getNavOrd();
        return BOrd.make((BOrd)spaceNav, (String)("history:" + (Object)((Object)this.getId())));
    }

    public BIcon getNavIcon() {
        return this.getIcon();
    }

    public int getNavHashCode() {
        return this.getId().hashCode();
    }

    public boolean isNavEqual(BINavNode node) {
        if (!(node instanceof BIHistory)) {
            return false;
        }
        return this.getId().equals((Object)((BIHistory)node).getId());
    }

    public boolean isPendingMove() {
        return false;
    }

    public void setPendingMove(boolean pendingMove) {
    }

    public final boolean canSubscribe(Context cx) {
        try {
            BComponent source = this.getSourceComponent(cx);
            if (source != null) {
                if (!(source instanceof BIPollableHistorySource)) {
                    return true;
                }
                source.lease();
                return ((BIPollableHistorySource)source).historyPollingEnabled();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSubscribed() {
        BHistory bHistory = this;
        synchronized (bHistory) {
            if (this.subscribers != null && this.subscribers.size() > 0) {
                return true;
            }
        }
        BComponent source = this.getSourceComponent(null);
        if (source == null) {
            return false;
        }
        return this.updateHistorySubscriptionCount(source, 0, null) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void subscribe(Subscriber subscriber, Context cx) {
        BComponent source = this.getSourceComponent(null);
        if (source == null) {
            throw new HistoryException("History source could not be found for history " + (Object)((Object)this.getId()));
        }
        if (source instanceof BIPollableHistorySource) {
            source.lease();
            if (!((BIPollableHistorySource)source).historyPollingEnabled()) {
                throw new HistoryException("On Demand Poll is disabled for the history source " + source.getSlotPath().toDisplayString());
            }
        }
        boolean subscribed = false;
        HashMap<Subscriber, BComponent> mySubscribers = null;
        Object object = this;
        synchronized (object) {
            BComponent oldSource = null;
            if (this.subscribers != null && (oldSource = this.subscribers.get(subscriber)) != null && source != oldSource) {
                throw new HistoryException("History already subscribed to different source, must unsubscribe first.");
            }
            subscribed = subscriber.isSubscribed(source);
            if (subscribed && oldSource == null) {
                throw new HistoryException("History source already subscribed to this subscriber for a different purpose, must unsubscribe before subscribing.");
            }
            if (this.subscribers == null) {
                this.subscribers = new HashMap();
            }
            this.subscribers.put(subscriber, source);
            mySubscribers = this.subscribers;
        }
        object = mySubscribers;
        synchronized (object) {
            if (!subscribed) {
                subscriber.subscribe(source, 0, null);
                this.updateHistorySubscriptionCount(source, 1, cx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsubscribe(Subscriber subscriber, Context cx) {
        BComponent source = null;
        HashMap<Subscriber, BComponent> mySubscribers = null;
        Object object = this;
        synchronized (object) {
            if (this.subscribers == null) {
                return;
            }
            mySubscribers = this.subscribers;
            source = this.subscribers.get(subscriber);
            this.subscribers.remove(subscriber);
            if (this.subscribers.size() < 1) {
                this.subscribers = null;
            }
        }
        object = mySubscribers;
        synchronized (object) {
            if (source != null && subscriber.isSubscribed(source)) {
                try {
                    this.updateHistorySubscriptionCount(source, -1, cx);
                }
                finally {
                    subscriber.unsubscribe(source, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsubscribeAll(Context cx) {
        Subscriber[] subs = null;
        BComponent[] sources = null;
        HashMap<Subscriber, BComponent> mySubscribers = null;
        Object object = this;
        synchronized (object) {
            if (this.subscribers == null) {
                return;
            }
            mySubscribers = this.subscribers;
            int size = this.subscribers.size();
            if (size > 0) {
                subs = this.subscribers.keySet().toArray(new Subscriber[size]);
                size = subs.length;
                sources = new BComponent[size];
                for (int i = 0; i < size; ++i) {
                    sources[i] = this.subscribers.get(subs[i]);
                }
            }
            this.subscribers.clear();
            this.subscribers = null;
        }
        object = mySubscribers;
        synchronized (object) {
            BFacets facets;
            boolean skipSubscribeCount = false;
            if (cx != null && (facets = cx.getFacets()) != null) {
                skipSubscribeCount = facets.getb("skipSubscribeCount", false);
            }
            for (int i = 0; i < subs.length; ++i) {
                if (subs[i] == null || !subs[i].isSubscribed(sources[i])) continue;
                try {
                    if (skipSubscribeCount) continue;
                    this.updateHistorySubscriptionCount(sources[i], -1, cx);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    subs[i].unsubscribe(sources[i], null);
                }
            }
        }
    }

    private BComponent getSourceComponent(Context cx) {
        return HistoryUtil.getSourceComponent(this, cx);
    }

    public String getDisplayName(Context cx) {
        return this.getNavDisplayName(cx);
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot instanceof HistorySlot) {
            slot = ((HistorySlot)slot).slot;
        }
        return this.getConfig().getDisplayName(slot, cx);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot instanceof HistorySlot) {
            slot = ((HistorySlot)slot).slot;
        }
        return this.getConfig().getSlotFacets(slot);
    }

    public String propertyValueToString(Property prop, Context cx) {
        if (prop instanceof HistoryProperty) {
            prop = (Property)((HistoryProperty)prop).slot;
        }
        return this.getConfig().propertyValueToString(prop, cx);
    }

    public Slot getSlot(String name) {
        Slot slot = this.getConfig().getSlot(name);
        if (slot == null) {
            return null;
        }
        return HistoryProperty.makeSlot(this.getType(), slot);
    }

    public Property getProperty(String name) {
        Property prop = this.getConfig().getProperty(name);
        if (prop == null) {
            return null;
        }
        return HistoryProperty.makeProperty(this.getType(), prop);
    }

    public int getSlotCount() {
        return this.getConfig().getSlotCount();
    }

    public int getSlotCount(Class<?> cls) {
        return this.getConfig().getSlotCount(cls);
    }

    public Slot[] getSlotsArray() {
        int len;
        Slot[] slots = this.getConfig().getSlotsArray();
        int n = len = slots != null ? slots.length : 0;
        if (len < 1) {
            return slots;
        }
        Slot[] result = new Slot[len];
        for (int i = 0; i < len; ++i) {
            result[i] = HistoryProperty.makeSlot(this.getType(), slots[i]);
        }
        return result;
    }

    public SlotCursor<Slot> getSlots() {
        SlotCursor c = this.getConfig().getSlots();
        if (c == null) {
            return null;
        }
        return new HistorySlotCursor(this, c);
    }

    public Property[] getPropertiesArray() {
        int len;
        Property[] props = this.getConfig().getPropertiesArray();
        int n = len = props != null ? props.length : 0;
        if (len < 1) {
            return props;
        }
        Property[] result = new Property[len];
        for (int i = 0; i < len; ++i) {
            result[i] = HistoryProperty.makeProperty(this.getType(), props[i]);
        }
        return result;
    }

    public Property[] getFrozenPropertiesArray() {
        int len;
        Property[] props = this.getConfig().getFrozenPropertiesArray();
        int n = len = props != null ? props.length : 0;
        if (len < 1) {
            return props;
        }
        Property[] result = new Property[len];
        for (int i = 0; i < len; ++i) {
            result[i] = HistoryProperty.makeProperty(this.getType(), props[i]);
        }
        return result;
    }

    public Property[] getDynamicPropertiesArray() {
        int len;
        Property[] props = this.getConfig().getDynamicPropertiesArray();
        int n = len = props != null ? props.length : 0;
        if (len < 1) {
            return props;
        }
        Property[] result = new Property[len];
        for (int i = 0; i < len; ++i) {
            result[i] = HistoryProperty.makeProperty(this.getType(), props[i]);
        }
        return result;
    }

    public SlotCursor<Property> getProperties() {
        SlotCursor c = this.getConfig().getProperties();
        if (c == null) {
            return null;
        }
        return new HistoryPropertyCursor(this, (SlotCursor<Property>)c);
    }

    public BComplex loadSlots() {
        return null;
    }

    public void lease() {
    }

    public void lease(int depth, long millis) {
    }

    public BValue get(Property prop) {
        if (prop instanceof HistoryProperty) {
            prop = (Property)((HistoryProperty)prop).slot;
        }
        return this.getConfig().get(prop);
    }

    public BValue get(String propertyName) {
        return this.getConfig().get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Property property, BValue value, Context cx) {
        block25: {
            this.checkAdminWriteOnHistory(cx);
            String propName = property.getName();
            BIPropertyContainer src = null;
            BHistoryDatabase db = null;
            BHistoryConfig localConfig = null;
            try {
                if (this.space instanceof BFoxHistorySpace) {
                    ((BFoxHistorySpace)this.space).channel().setProperty(this.getId(), propName, value, cx);
                    return;
                }
                if (this.space instanceof BHistoryDatabase) {
                    BValue oldVal = this.get(property);
                    if (value.equivalent((Object)oldVal) && oldVal.equivalent((Object)(src = this.getPropertySource(cx)).get(propName))) {
                        return;
                    }
                } else {
                    log.log(Level.SEVERE, "Could not set value on history config, invalid space type " + this.space.getType());
                    return;
                }
                db = (BHistoryDatabase)this.space;
                localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
                localConfig.set(localConfig.getProperty(propName), value.newCopy(true), BHistory.getHistoryAuditContext(cx, this.getId()));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not set value on history config.", e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                return;
            }
            boolean commitToHistory = true;
            try {
                if (src == null) {
                    src = this.getPropertySource(cx);
                }
                if (src != null) {
                    src.loadSlots();
                    Property srcProp = src.getProperty(propName);
                    try {
                        if (srcProp == null && BHistory.shouldLease(src)) {
                            src.lease();
                            srcProp = src.getProperty(propName);
                        }
                        if (srcProp == null) {
                            throw new NoSuchSlotException("No src prop");
                        }
                        if (srcProp.isDynamic() && property.isFrozen() && propName.equals("systemTags") && property.isEquivalentToDefaultValue(value)) {
                            src.remove(srcProp, cx);
                        } else {
                            src.set(srcProp, value.newCopy(true), cx);
                            if (src instanceof BHistoryConfig && ((BHistoryConfig)src).getParent() instanceof BIHistorySource) {
                                localConfig = null;
                            }
                        }
                        break block25;
                    }
                    catch (NoSuchSlotException nsse) {
                        if (property.isDynamic() || !propName.equals("systemTags") || !property.isEquivalentToDefaultValue(value)) {
                            BHistoryConfig config = this.getConfig();
                            Property configProp = config.getProperty(propName);
                            int flags = configProp != null ? config.getFlags((Slot)configProp) : 0;
                            BFacets facets = configProp != null ? config.getSlotFacets((Slot)configProp) : null;
                            src.add(propName, value.newCopy(true), flags, facets, cx);
                        }
                        break block25;
                    }
                }
                if (log.isLoggable(Level.WARNING) && this.isNotDynamicMetadataProperty(propName)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Trying to set a non-metadata property ('");
                    sb.append(propName).append("') on a history (");
                    sb.append(this.getId().toString());
                    sb.append(") with an unreachable source.  Changes to non-metadata ");
                    sb.append("properties may not be persisted for histories with an unreachable source.");
                    log.warning(sb.toString());
                }
            }
            catch (PermissionException pe) {
                if (this.isNotDynamicMetadataProperty(propName)) {
                    commitToHistory = false;
                    throw pe;
                }
            }
            finally {
                if (db != null && localConfig != null && commitToHistory) {
                    db.setConfig(localConfig);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String propName, BValue value) {
        block25: {
            Property property = this.getProperty(propName);
            BIPropertyContainer src = null;
            BHistoryDatabase db = null;
            BHistoryConfig localConfig = null;
            try {
                if (this.space instanceof BFoxHistorySpace) {
                    ((BFoxHistorySpace)this.space).channel().setProperty(this.getId(), propName, value, null);
                    return;
                }
                if (this.space instanceof BHistoryDatabase) {
                    BValue oldVal = this.get(propName);
                    if (value.equivalent((Object)oldVal) && oldVal.equivalent((Object)(src = this.getPropertySource(null)).get(propName))) {
                        return;
                    }
                } else {
                    log.log(Level.SEVERE, "Could not set value on history config, invalid space type " + this.space.getType());
                    return;
                }
                db = (BHistoryDatabase)this.space;
                localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
                localConfig.set(propName, value.newCopy(true));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not set value on history config.", e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                return;
            }
            boolean commitToHistory = true;
            try {
                if (src == null) {
                    src = this.getPropertySource(null);
                }
                if (src != null) {
                    src.loadSlots();
                    Property srcProp = src.getProperty(propName);
                    try {
                        if (srcProp == null && BHistory.shouldLease(src)) {
                            src.lease();
                            srcProp = src.getProperty(propName);
                        }
                        if (srcProp == null) {
                            throw new NoSuchSlotException("No src prop");
                        }
                        if (srcProp.isDynamic() && property.isFrozen() && propName.equals("systemTags") && property.isEquivalentToDefaultValue(value)) {
                            src.remove(srcProp, null);
                        } else {
                            src.set(propName, value.newCopy(true));
                            if (src instanceof BHistoryConfig && ((BHistoryConfig)src).getParent() instanceof BIHistorySource) {
                                localConfig = null;
                            }
                        }
                        break block25;
                    }
                    catch (NoSuchSlotException nsse) {
                        if (property.isDynamic() || !propName.equals("systemTags") || !property.isEquivalentToDefaultValue(value)) {
                            BHistoryConfig config = this.getConfig();
                            Property configProp = config.getProperty(propName);
                            int flags = configProp != null ? config.getFlags((Slot)configProp) : 0;
                            BFacets facets = configProp != null ? config.getSlotFacets((Slot)configProp) : null;
                            src.add(propName, value.newCopy(true), flags, facets, null);
                        }
                        break block25;
                    }
                }
                if (log.isLoggable(Level.WARNING) && this.isNotDynamicMetadataProperty(propName)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Trying to set a non-metadata property ('");
                    sb.append(propName).append("') on a history (");
                    sb.append(this.getId().toString());
                    sb.append(") with an unreachable source.  Changes to non-metadata ");
                    sb.append("properties may not be persisted for histories with an unreachable source.");
                    log.warning(sb.toString());
                }
            }
            catch (PermissionException pe) {
                if (this.isNotDynamicMetadataProperty(propName)) {
                    commitToHistory = false;
                    throw pe;
                }
            }
            finally {
                if (db != null && localConfig != null && commitToHistory) {
                    db.setConfig(localConfig);
                }
            }
        }
    }

    public int getFlags(Slot slot) {
        if (slot instanceof HistorySlot) {
            slot = ((HistorySlot)slot).slot;
        }
        int flags = this.getConfig().getFlags(slot);
        if (!this.getPermissions(null).hasAdminWrite()) {
            flags |= 1;
        } else {
            Slot srcSlot;
            BIPropertyContainer src = this.getPropertySource(null);
            Slot slot2 = srcSlot = src != null ? src.getSlot(slot.getName()) : null;
            if (src == null && (slot.isFrozen() || (flags & 0x4000) == 0) || srcSlot != null && (src.getFlags(srcSlot) & 1) != 0) {
                flags |= 1;
            }
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlags(Slot slot, int flags, Context cx) {
        this.checkAdminWriteOnHistory(cx);
        String slotName = slot.getName();
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        try {
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().setPropertyFlags(this.getId(), slotName, flags, cx);
                return;
            }
            if (!(this.space instanceof BHistoryDatabase)) {
                log.log(Level.SEVERE, "Could not set flags on history config, invalid space type " + this.space.getType());
                return;
            }
            db = (BHistoryDatabase)this.space;
            localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
            localConfig.setFlags(localConfig.getSlot(slotName), flags, BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not set flags on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return;
        }
        boolean commitToHistory = true;
        try {
            BIPropertyContainer src = this.getPropertySource(cx);
            if (src != null) {
                src.loadSlots();
                Slot srcSlot = src.getSlot(slotName);
                if (srcSlot == null && BHistory.shouldLease(src)) {
                    src.lease();
                    srcSlot = src.getSlot(slotName);
                }
                if (srcSlot != null || src instanceof BHistoryConfig) {
                    src.setFlags(srcSlot, flags, cx);
                }
            } else if (log.isLoggable(Level.WARNING) && this.isNotDynamicMetadataProperty(slot)) {
                StringBuffer sb = new StringBuffer();
                sb.append("Trying to set non-metadata flags on slot ('");
                sb.append(slotName).append("') on a history (");
                sb.append(this.getId().toString());
                sb.append(") with an unreachable source.  Non-metadata ");
                sb.append("properties may not be persisted for histories with an unreachable source.");
                log.warning(sb.toString());
            }
        }
        catch (PermissionException pe) {
            if (this.isNotDynamicMetadataProperty(slot)) {
                commitToHistory = false;
                throw pe;
            }
        }
        finally {
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property add(String name, BValue value, int flags, BFacets facets, Context cx) {
        Property property;
        this.checkAdminWriteOnHistory(cx);
        Property newProp = null;
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        try {
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().addProperty(this.getId(), name, value, flags, facets, cx);
                return null;
            }
            if (!(this.space instanceof BHistoryDatabase)) {
                log.log(Level.SEVERE, "Could not add value on history config, invalid space type " + this.space.getType());
                return null;
            }
            db = (BHistoryDatabase)this.space;
            localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
            newProp = localConfig.add(name, value.newCopy(true), flags, facets, BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not add value on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return null;
        }
        boolean commitToHistory = true;
        try {
            BIPropertyContainer src = this.getPropertySource(cx);
            if (src != null) {
                Property prop;
                src.loadSlots();
                if (BHistory.shouldLease(src)) {
                    src.lease();
                }
                if ((prop = src.getProperty(name)) == null) {
                    prop = src.add(name, value, flags, facets, cx);
                } else {
                    src.set(prop, value, cx);
                    src.setFlags((Slot)prop, flags, cx);
                    src.setFacets((Slot)prop, facets, cx);
                }
                if (src instanceof BHistoryConfig && ((BHistoryConfig)src).getParent() instanceof BIHistorySource) {
                    localConfig = null;
                }
            } else if (log.isLoggable(Level.WARNING) && (flags & 0x4000) == 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("Trying to add a non-metadata property ('");
                sb.append(name).append("') on a history (");
                sb.append(this.getId().toString());
                sb.append(") with an unreachable source.  Changes to non-metadata ");
                sb.append("properties may not be persisted for histories with an unreachable source.");
                log.warning(sb.toString());
            }
            if (newProp == null) {
                property = null;
                return property;
            }
            property = HistoryProperty.makeProperty(this.getType(), newProp);
            return property;
        }
        catch (PermissionException pe) {
            if ((flags & 0x4000) == 0) {
                commitToHistory = false;
                throw pe;
            }
            property = null;
            return property;
        }
        finally {
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name, Context cx) {
        this.checkAdminWriteOnHistory(cx);
        NoSuchSlotException nsse = null;
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        try {
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().removeProperty(this.getId(), name, cx);
                return;
            }
            if (!(this.space instanceof BHistoryDatabase)) {
                log.log(Level.SEVERE, "Could not remove value on history config, invalid space type " + this.space.getType());
                return;
            }
            db = (BHistoryDatabase)this.space;
            localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
            localConfig.remove(name, BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (NoSuchSlotException nse) {
            nsse = nse;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not remove value on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return;
        }
        boolean commitToHistory = true;
        try {
            block20: {
                BIPropertyContainer src = this.getPropertySource(cx);
                if (src != null) {
                    src.loadSlots();
                    Slot srcSlot = src.getSlot(name);
                    if (srcSlot == null && BHistory.shouldLease(src)) {
                        src.lease();
                    }
                    try {
                        src.remove(name, cx);
                        if (src instanceof BHistoryConfig && ((BHistoryConfig)src).getParent() instanceof BIHistorySource) {
                            localConfig = null;
                        }
                    }
                    catch (NoSuchSlotException nse) {
                        if (nsse != null) break block20;
                        nsse = nse;
                    }
                }
            }
            if (nsse != null) {
                throw nsse;
            }
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
        catch (PermissionException pe) {
            try {
                if (this.isNotDynamicMetadataProperty(name)) {
                    commitToHistory = false;
                    throw pe;
                }
                if (db != null && localConfig != null && commitToHistory) {
                    db.setConfig(localConfig);
                }
            }
            catch (Throwable throwable) {
                if (db != null && localConfig != null && commitToHistory) {
                    db.setConfig(localConfig);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Property slot, Context cx) {
        this.checkAdminWriteOnHistory(cx);
        NoSuchSlotException nsse = null;
        String propName = slot.getName();
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        try {
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().removeProperty(this.getId(), propName, cx);
                return;
            }
            if (!(this.space instanceof BHistoryDatabase)) {
                log.log(Level.SEVERE, "Could not remove value on history config, invalid space type " + this.space.getType());
                return;
            }
            db = (BHistoryDatabase)this.space;
            localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
            localConfig.remove(propName, BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (NoSuchSlotException nse) {
            nsse = nse;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not remove value on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return;
        }
        boolean commitToHistory = true;
        try {
            block20: {
                BIPropertyContainer src = this.getPropertySource(cx);
                if (src != null) {
                    src.loadSlots();
                    Slot srcSlot = src.getSlot(propName);
                    if (srcSlot == null && BHistory.shouldLease(src)) {
                        src.lease();
                    }
                    try {
                        src.remove(propName, cx);
                        if (src instanceof BHistoryConfig && ((BHistoryConfig)src).getParent() instanceof BIHistorySource) {
                            localConfig = null;
                        }
                    }
                    catch (NoSuchSlotException nse) {
                        if (nsse != null) break block20;
                        nsse = nse;
                    }
                }
            }
            if (nsse != null) {
                throw nsse;
            }
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
        catch (PermissionException pe) {
            try {
                if (this.isNotDynamicMetadataProperty((Slot)slot)) {
                    commitToHistory = false;
                    throw pe;
                }
                if (db != null && localConfig != null && commitToHistory) {
                    db.setConfig(localConfig);
                }
            }
            catch (Throwable throwable) {
                if (db != null && localConfig != null && commitToHistory) {
                    db.setConfig(localConfig);
                }
                throw throwable;
            }
        }
    }

    public void removeAll(Context cx) {
        this.checkAdminWriteOnHistory(cx);
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        try {
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().removeAllProperties(this.getId(), cx);
                return;
            }
            if (!(this.space instanceof BHistoryDatabase)) {
                log.log(Level.SEVERE, "Could not remove all properties on history config, invalid space type " + this.space.getType());
                return;
            }
            db = (BHistoryDatabase)this.space;
            localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
            localConfig.removeAll(BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not remove all properties on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return;
        }
        boolean commitToHistory = true;
        try {
            BIPropertyContainer src = this.getPropertySource(cx);
            if (src != null) {
                src.loadSlots();
                if (BHistory.shouldLease(src)) {
                    src.lease();
                }
                src.removeAll(cx);
                if (src instanceof BHistoryConfig && ((BHistoryConfig)src).getParent() instanceof BIHistorySource) {
                    localConfig = null;
                }
            }
        }
        catch (PermissionException pe) {
            commitToHistory = false;
            throw pe;
        }
        finally {
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(Property slot, String newName, Context cx) {
        this.checkAdminWriteOnHistory(cx);
        String propName = slot.getName();
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        try {
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().renameProperty(this.getId(), propName, newName, cx);
                return;
            }
            if (!(this.space instanceof BHistoryDatabase)) {
                log.log(Level.SEVERE, "Could not rename property on history config, invalid space type " + this.space.getType());
                return;
            }
            db = (BHistoryDatabase)this.space;
            localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
            localConfig.rename(localConfig.getProperty(propName), newName, BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not rename property on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return;
        }
        boolean commitToHistory = true;
        try {
            BIPropertyContainer src = this.getPropertySource(cx);
            if (src != null) {
                src.loadSlots();
                Property srcProp = src.getProperty(propName);
                if (srcProp == null && BHistory.shouldLease(src)) {
                    src.lease();
                    srcProp = src.getProperty(propName);
                }
                if (srcProp != null || src instanceof BHistoryConfig) {
                    src.rename(srcProp, newName, cx);
                }
            } else if (log.isLoggable(Level.WARNING) && this.isNotDynamicMetadataProperty((Slot)slot)) {
                StringBuffer sb = new StringBuffer();
                sb.append("Trying to rename a non-metadata property ('");
                sb.append(propName).append("') on a history (");
                sb.append(this.getId().toString());
                sb.append(") with an unreachable source.  Changes to non-metadata ");
                sb.append("properties may not be persisted for histories with an unreachable source.");
                log.warning(sb.toString());
            }
        }
        catch (PermissionException pe) {
            if (this.isNotDynamicMetadataProperty((Slot)slot)) {
                commitToHistory = false;
                throw pe;
            }
        }
        finally {
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(Slot slot, BFacets facets, Context cx) {
        this.checkAdminWriteOnHistory(cx);
        String slotName = slot.getName();
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        try {
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().setPropertyFacets(this.getId(), slotName, facets, cx);
                return;
            }
            if (!(this.space instanceof BHistoryDatabase)) {
                log.log(Level.SEVERE, "Could not set facets on history config, invalid space type " + this.space.getType());
                return;
            }
            db = (BHistoryDatabase)this.space;
            localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
            localConfig.setFacets(localConfig.getSlot(slotName), facets, BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not set facets on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return;
        }
        boolean commitToHistory = true;
        try {
            BIPropertyContainer src = this.getPropertySource(cx);
            if (src != null) {
                src.loadSlots();
                Slot srcSlot = src.getSlot(slotName);
                if (srcSlot == null && BHistory.shouldLease(src)) {
                    src.lease();
                    srcSlot = src.getSlot(slotName);
                }
                if (srcSlot != null || src instanceof BHistoryConfig) {
                    src.setFacets(srcSlot, facets, cx);
                }
            } else if (log.isLoggable(Level.WARNING) && this.isNotDynamicMetadataProperty(slot)) {
                StringBuffer sb = new StringBuffer();
                sb.append("Trying to set facets on a non-metadata slot ('");
                sb.append(slotName).append("') on a history (");
                sb.append(this.getId().toString());
                sb.append(") with an unreachable source.  Changes to non-metadata ");
                sb.append("properties may not be persisted for histories with an unreachable source.");
                log.warning(sb.toString());
            }
        }
        catch (PermissionException pe) {
            if (this.isNotDynamicMetadataProperty(slot)) {
                commitToHistory = false;
                throw pe;
            }
        }
        finally {
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
    }

    public void reorder(Property[] dynamicProperties, Context cx) {
        this.checkAdminWriteOnHistory(cx);
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        int len = dynamicProperties.length;
        String[] propNames = new String[len];
        for (int i = 0; i < len; ++i) {
            propNames[i] = dynamicProperties[i].getName();
        }
        try {
            Property[] srcProps;
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().reorderProperties(this.getId(), propNames, cx);
                return;
            }
            if (this.space instanceof BHistoryDatabase) {
                db = (BHistoryDatabase)this.space;
                localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
                srcProps = new Property[len];
                for (int i = 0; i < len; ++i) {
                    srcProps[i] = localConfig.getProperty(propNames[i]);
                }
            } else {
                log.log(Level.SEVERE, "Could not reorder properties on history config, invalid space type " + this.space.getType());
                return;
            }
            localConfig.reorder(srcProps, BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not reorder properties on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return;
        }
        boolean commitToHistory = true;
        try {
            BIPropertyContainer src = this.getPropertySource(cx);
            if (src != null) {
                src.loadSlots();
                if (BHistory.shouldLease(src)) {
                    src.lease();
                }
                ArrayList<Property> srcSlots = new ArrayList<Property>();
                for (int i = 0; i < len; ++i) {
                    Property prop = src.getProperty(propNames[i]);
                    if (prop == null) continue;
                    srcSlots.add(prop);
                }
                Property[] compare = src.getDynamicPropertiesArray();
                int cLen = compare != null ? compare.length : 0;
                for (int i = 0; i < cLen; ++i) {
                    if (srcSlots.contains(compare[i])) continue;
                    srcSlots.add(compare[i]);
                }
                src.reorder(srcSlots.toArray(new Property[srcSlots.size()]), cx);
            }
        }
        catch (PermissionException pe) {
            commitToHistory = false;
            throw pe;
        }
        finally {
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
    }

    public void reorderToTop(Property dynamicProperty, Context cx) {
        this.checkAdminWriteOnHistory(cx);
        String propName = dynamicProperty.getName();
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        try {
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().reorderPropertyToTop(this.getId(), propName, cx);
                return;
            }
            if (!(this.space instanceof BHistoryDatabase)) {
                log.log(Level.SEVERE, "Could not reorder property to top on history config, invalid space type " + this.space.getType());
                return;
            }
            db = (BHistoryDatabase)this.space;
            localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
            localConfig.reorderToTop(localConfig.getProperty(propName), BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not reorder property to top on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return;
        }
        boolean commitToHistory = true;
        try {
            BIPropertyContainer src = this.getPropertySource(cx);
            if (src != null) {
                src.loadSlots();
                Property srcProp = src.getProperty(propName);
                if (srcProp == null && BHistory.shouldLease(src)) {
                    src.lease();
                    srcProp = src.getProperty(propName);
                }
                if (srcProp != null || src instanceof BHistoryConfig) {
                    src.reorderToTop(srcProp, cx);
                }
            }
        }
        catch (PermissionException pe) {
            commitToHistory = false;
            throw pe;
        }
        finally {
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
    }

    public void reorderToBottom(Property dynamicProperty, Context cx) {
        this.checkAdminWriteOnHistory(cx);
        String propName = dynamicProperty.getName();
        BHistoryDatabase db = null;
        BHistoryConfig localConfig = null;
        try {
            if (this.space instanceof BFoxHistorySpace) {
                ((BFoxHistorySpace)this.space).channel().reorderPropertyToBottom(this.getId(), propName, cx);
                return;
            }
            if (!(this.space instanceof BHistoryDatabase)) {
                log.log(Level.SEVERE, "Could not reorder property to bottom on history config, invalid space type " + this.space.getType());
                return;
            }
            db = (BHistoryDatabase)this.space;
            localConfig = (BHistoryConfig)db.getConfig(this.getId()).newCopy(true);
            localConfig.reorderToBottom(localConfig.getProperty(propName), BHistory.getHistoryAuditContext(cx, this.getId()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not reorder property to bottom on history config.", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return;
        }
        boolean commitToHistory = true;
        try {
            BIPropertyContainer src = this.getPropertySource(cx);
            if (src != null) {
                src.loadSlots();
                Property srcProp = src.getProperty(propName);
                if (srcProp == null && BHistory.shouldLease(src)) {
                    src.lease();
                    srcProp = src.getProperty(propName);
                }
                if (srcProp != null || src instanceof BHistoryConfig) {
                    src.reorderToBottom(srcProp, cx);
                }
            }
        }
        catch (PermissionException pe) {
            commitToHistory = false;
            throw pe;
        }
        finally {
            if (db != null && localConfig != null && commitToHistory) {
                db.setConfig(localConfig);
            }
        }
    }

    private void checkAdminWriteOnHistory(Context cx) {
        BPermissions permissions = this.getPermissions(cx);
        if (!permissions.hasAdminWrite()) {
            throw new PermissionException("Missing admin write permission on history (" + permissions + " < " + BPermissions.adminWrite + ')');
        }
    }

    private boolean isNotDynamicMetadataProperty(String slotName) {
        return this.isNotDynamicMetadataProperty(this.getSlot(slotName));
    }

    private boolean isNotDynamicMetadataProperty(Slot slot) {
        return slot == null || slot.isFrozen() || (this.getFlags(slot) & 0x4000) == 0;
    }

    private BIPropertyContainer getPropertySource(Context cx) {
        BIPropertyContainer source = this.getPropertySource();
        if (cx != null && cx.getUser() != null && source instanceof BIProtected && !((BIProtected)source).getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("User cannot access history source");
        }
        return source;
    }

    private BIPropertyContainer getPropertySource() {
        BValue val;
        boolean lease;
        BComponent comp;
        block8: {
            comp = null;
            try {
                comp = this.getSourceComponent(null);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block8;
                log.log(Level.FINE, "Cannot find source component for history " + (Object)((Object)this.getId()), e);
            }
        }
        if (comp == null) {
            return null;
        }
        comp.loadSlots();
        boolean bl = lease = !comp.isRunning() && comp.isMounted();
        if (historyImportType == null) {
            historyImportType = BTypeSpec.make((String)"driver", (String)"HistoryImport").getResolvedType();
        }
        if (comp.getType().is(historyImportType) && (val = comp.get("configOverrides")) instanceof BIPropertyContainer) {
            return (BIPropertyContainer)val;
        }
        BHistoryId myId = this.getId();
        if (comp instanceof BHistoryConfig && myId.equals((Object)((BHistoryConfig)comp).getId())) {
            return comp;
        }
        SlotCursor c = comp.getProperties();
        while (c.next(BHistoryConfig.class)) {
            BHistoryConfig config = (BHistoryConfig)c.get();
            config.loadSlots();
            if (lease) {
                config.lease();
            }
            if (!myId.equals((Object)config.getId())) continue;
            return config;
        }
        return null;
    }

    private static boolean shouldLease(BIPropertyContainer src) {
        if (src instanceof BComponent) {
            BComponent comp = (BComponent)src;
            return !comp.isRunning() && comp.isMounted();
        }
        return false;
    }

    private static final Context getHistoryAuditContext(Context cx, BHistoryId id) {
        if (cx != null) {
            try {
                String[] names = new String[]{SlotPath.escape((String)id.getDeviceName()), SlotPath.escape((String)id.getHistoryName())};
                SlotPath path = new SlotPath("history", names);
                return new BasicContext(cx, BFacets.make((String)"auditTargetSlotPathScheme", (BIDataValue)BString.make((String)path.getScheme()), (String)"auditTargetSlotPathBody", (BIDataValue)BString.make((String)path.getBody())));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cx;
    }

    public static BFormat getHistoryDisplayNameFormat(BIHistory history) {
        try {
            BFormat val;
            BValue displayName = history.get("historyDisplayName");
            if (displayName instanceof BFormat && (val = (BFormat)displayName).getFormat().length() != 0) {
                return val;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setHistoryDisplayNameFormat(BIHistory history, BFormat newName, Context context) {
        boolean slotExists;
        BFormat oldName = (BFormat)history.get("historyDisplayName");
        boolean bl = slotExists = oldName != null;
        if (newName == null || newName.getFormat().length() == 0) {
            if (slotExists) {
                history.remove("historyDisplayName", context);
            }
        } else if (slotExists) {
            history.set(history.getProperty("historyDisplayName"), (BValue)newName, context);
        } else {
            history.add("historyDisplayName", (BValue)newName, 4, BFacets.NULL, context);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        BHistoryConfig config = this.getConfig();
        BHistoryRecord rec = config.makeRecord();
        list.toTop("history:HistoryTable");
        if (!(rec instanceof BTrendRecord)) {
            list.remove(list.filter(trendFilter));
        } else {
            boolean chartable;
            Type valueType = rec.get(((BTrendRecord)rec).getValueProperty()).getType();
            boolean bl = chartable = valueType == BDouble.TYPE || valueType == BFloat.TYPE || valueType == BInteger.TYPE || valueType == BBoolean.TYPE || valueType == BDynamicEnum.TYPE;
            if (!chartable) {
                list.remove(list.filter(chartableFilter));
            } else {
                list.toTop(chartableFilter);
            }
        }
        return list;
    }
}

