/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.dataRecovery.BDataRecoveryEmptyKey;
import com.tridium.history.BDataRecoveryHistoryId;
import com.tridium.history.log.BLogHistoryService;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BIAgent;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.DuplicateHistoryException;
import javax.baja.history.HistoryEventListener;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.io.BIEncodable;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDataRecoveryHistoryRecorder
extends BObject
implements BIAgent,
HistoryEventListener {
    public static final Type TYPE = Sys.loadType(BDataRecoveryHistoryRecorder.class);
    protected static final byte[] EMPTY_DATA = new byte[0];
    protected static final BIEncodable EMPTY_KEY = BDataRecoveryEmptyKey.INSTANCE;
    public static final Logger LOG = Logger.getLogger("history.dataRecovery");
    private BIDataRecoveryService dataRecoveryService;
    private BLogHistoryService logHistoryService;
    private BHistorySpace db;
    private static final Object ENCOUNTER_LOCK = new Object();
    private static int uniqueHistoryNamesEncountered = 0;
    private static final HashMap<BHistoryId, Integer> historyIdToEncounterOrder = new HashMap();
    private static final LinkedHashMap<Integer, String> MRUHistoryNameEntries = new LinkedHashMap<Integer, String>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, String> eldest) {
            return this.size() > 10;
        }
    };
    private final HashMap<Integer, String> encounterOrderToHistoryName = new HashMap();

    public Type getType() {
        return TYPE;
    }

    public final void setDataRecoveryService(BIDataRecoveryService service) {
        this.dataRecoveryService = service;
    }

    public final BIDataRecoveryService getDataRecoveryService() {
        return this.dataRecoveryService;
    }

    public final void setHistorySpace(BHistorySpace space) {
        this.db = space;
    }

    public final BHistorySpace getHistorySpace() {
        return this.db;
    }

    public final void setLogHistoryService(BLogHistoryService service) {
        this.logHistoryService = service;
    }

    public final BLogHistoryService getLogHistoryService() {
        return this.logHistoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetHistoryIdMap() throws Exception {
        Object object = ENCOUNTER_LOCK;
        synchronized (object) {
            Set<Map.Entry<Integer, String>> mruEntries = MRUHistoryNameEntries.entrySet();
            for (Map.Entry<Integer, String> entry : mruEntries) {
                String historyName = entry.getValue();
                Integer historyHandle = entry.getKey();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Preserving history name mapping " + historyName + " -> " + historyHandle);
                }
                this.dataRecoveryService.append((BIDataRecoverySource)this.db, EMPTY_KEY, new HistoryNameEntry(historyName, historyHandle).toRecoveryBytes());
            }
            MRUHistoryNameEntries.clear();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Resetting history id map");
            }
            historyIdToEncounterOrder.clear();
            uniqueHistoryNamesEncountered = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void historyEvent(BHistoryEvent event) {
        block12: {
            try {
                if (!this.isEventCritical(event)) break block12;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Recording history event '" + (Object)((Object)event) + "'");
                }
                BHistoryId historyId = event.getHistoryId();
                Integer historyEncounterHandle = null;
                HistoryNameEntry historyNameEntry = null;
                Object object = ENCOUNTER_LOCK;
                synchronized (object) {
                    historyEncounterHandle = historyIdToEncounterOrder.get((Object)historyId);
                    if (historyEncounterHandle == null) {
                        historyEncounterHandle = ++uniqueHistoryNamesEncountered;
                        historyIdToEncounterOrder.put(historyId, historyEncounterHandle);
                        historyNameEntry = new HistoryNameEntry(historyId.getHistoryName(), historyEncounterHandle);
                    }
                    MRUHistoryNameEntries.put(historyEncounterHandle, historyId.getHistoryName());
                }
                BDataRecoveryHistoryId alternativeIdEncodable = BDataRecoveryHistoryId.make("^", String.valueOf(historyEncounterHandle));
                BHistoryEvent alternativeHistoryEvent = BHistoryEvent.makeStorageEvent(event, (BIEncodable)alternativeIdEncodable, true);
                if (historyNameEntry != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Recording history name mapping " + historyId.getHistoryName() + " -> " + historyEncounterHandle);
                    }
                    this.dataRecoveryService.append((BIDataRecoverySource)this.db, EMPTY_KEY, historyNameEntry.toRecoveryBytes());
                }
                this.dataRecoveryService.append((BIDataRecoverySource)this.db, (BIEncodable)alternativeHistoryEvent, EMPTY_DATA);
            }
            catch (DataRecoveryServiceInFaultException drsife) {
                try {
                    ((BHistoryDatabase)this.db).removeHistoryEventListener(this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LOG.log(Level.WARNING, "DataRecoveryService in fault, could not append history event '" + (Object)((Object)event) + "'. Stopped data recovery history recording.", drsife);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "DataRecoveryService could not record history event '" + (Object)((Object)event) + "'", e);
            }
        }
    }

    public boolean restore(BHistorySpace db, IDataRecoveryRecord rec) throws Exception {
        BHistoryEvent referenceEvent = BHistoryEvent.makeDbSaved();
        BHistoryEvent event = null;
        HistoryNameEntry nameEntry = null;
        byte[] key = rec.getKey();
        ByteBuffer keyBuffer = new ByteBuffer(key);
        byte[] data = rec.getData();
        if (data != null && data.length != 0) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
            nameEntry = new HistoryNameEntry();
            nameEntry.fromRecoveryBytes(dis);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Restoring history name mapping " + nameEntry.getEncounterOrder() + " -> " + nameEntry.getHistoryName());
            }
            this.encounterOrderToHistoryName.put(nameEntry.getEncounterOrder(), nameEntry.getHistoryName());
            return true;
        }
        event = (BHistoryEvent)referenceEvent.decode((DataInput)keyBuffer);
        if (event != null) {
            try {
                String actualHistoryName = this.encounterOrderToHistoryName.get(Integer.valueOf(event.getHistoryId().getHistoryName()));
                if (actualHistoryName == null) {
                    LOG.log(Level.SEVERE, "DataRecoveryService could not restore history event " + (Object)((Object)event) + ", no history name mapping found");
                    throw new Exception("Unknown history name mapping for " + event.getHistoryId().getHistoryName());
                }
                BHistoryId alternativeHistoryId = BHistoryId.make(event.getHistoryId().getDeviceName(), actualHistoryName);
                event = BHistoryEvent.makeReplayEvent(event, alternativeHistoryId, true);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "DataRecoveryService could not restore history event " + (Object)((Object)event), ex);
                throw ex;
            }
        }
        BHistoryEvent privilegedEvent = event;
        boolean restored = false;
        try {
            restored = AccessController.doPrivileged(() -> {
                try (HistorySpaceConnection conn = db.getConnection(null);){
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Restoring history event " + (Object)((Object)privilegedEvent));
                    }
                    switch (privilegedEvent.getId()) {
                        case 0: {
                            BHistoryConfig config = privilegedEvent.getConfig();
                            if (config == null) return true;
                            try {
                                conn.createHistory(config);
                                return true;
                            }
                            catch (DuplicateHistoryException dhe) {
                                if (!LOG.isLoggable(Level.FINE)) return true;
                                LOG.log(Level.FINE, "History already exists, could not restore history creation event " + (Object)((Object)privilegedEvent), (Throwable)((Object)dhe));
                                return true;
                            }
                        }
                        case 1: {
                            conn.deleteHistory(privilegedEvent.getHistoryId());
                            return true;
                        }
                        case 2: {
                            BIHistory history = conn.getHistory(privilegedEvent.getHistoryId());
                            BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                            BIHistoryRecordSet records = privilegedEvent.getRecordSet();
                            if (lastTimestamp == null || lastTimestamp.isNull()) {
                                conn.append(history, records);
                                return true;
                            }
                            int count = records.getRecordCount();
                            int i = 0;
                            while (i < count) {
                                BHistoryRecord record = records.getRecord(i);
                                if (record.getTimestamp().isAfter(lastTimestamp)) {
                                    conn.append(history, record);
                                }
                                ++i;
                            }
                            return true;
                        }
                        case 3: {
                            BIHistory historyUp = conn.getHistory(privilegedEvent.getHistoryId());
                            conn.update(historyUp, (BHistoryRecord)privilegedEvent.getRecordSet());
                            return true;
                        }
                        case 4: {
                            conn.clearAllRecords(privilegedEvent.getHistoryId());
                            return true;
                        }
                        case 5: {
                            conn.clearOldRecords(privilegedEvent.getHistoryId(), privilegedEvent.getClearOldTime());
                            return true;
                        }
                        case 6: {
                            conn.renameHistory(privilegedEvent.getHistoryId(), privilegedEvent.getNewHistoryName());
                            return true;
                        }
                        case 7: {
                            ((HistoryDatabaseConnection)conn).resizeHistory(privilegedEvent.getHistoryId(), privilegedEvent.getCapacity(), privilegedEvent.getFullPolicy());
                            return true;
                        }
                        case 12: {
                            ((BHistoryDatabase)db).setConfig(privilegedEvent.getConfig());
                            return true;
                        }
                    }
                    LOG.severe("DataRecoveryService could not restore unexpected history event '" + (Object)((Object)privilegedEvent) + "'");
                    Boolean bl = false;
                    return bl;
                }
                catch (Exception ex) {
                    if (privilegedEvent != null) {
                        LOG.log(Level.SEVERE, "DataRecoveryService could not restore history event " + (Object)((Object)privilegedEvent), ex);
                        throw ex;
                    }
                    LOG.log(Level.SEVERE, "DataRecoveryService could not restore null history event", ex);
                    throw ex;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return restored;
    }

    public void restoreComplete() {
        this.encounterOrderToHistoryName.clear();
    }

    public boolean isEventCritical(BHistoryEvent event) {
        if (this.dataRecoveryService == null) {
            return false;
        }
        if (!this.dataRecoveryService.isEnabled()) {
            return false;
        }
        if (event == null) {
            return false;
        }
        switch (event.getId()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                BHistoryId eventHistoryId = event.getHistoryId();
                BHistoryConfig config = this.db.getConfig(eventHistoryId);
                if (config != null && Flags.isNonCritical((BComplex)config, (Slot)BHistoryConfig.id)) {
                    return false;
                }
                BHistoryId logHistoryId = null;
                try {
                    logHistoryId = this.logHistoryService.getHistoryConfig().getId();
                }
                catch (Throwable t) {
                    logHistoryId = BHistoryId.make(Sys.getStation().getStationName(), "LogHistory");
                }
                return !event.getHistoryId().equals((Object)logHistoryId);
            }
        }
        return false;
    }

    public static class HistoryNameEntry {
        public static final int MAGIC = 45323;
        private String historyName;
        int encounterOrder;

        public HistoryNameEntry() {
            this.historyName = null;
            this.encounterOrder = -1;
        }

        public HistoryNameEntry(String historyName, int encounterOrder) {
            this.historyName = historyName;
            this.encounterOrder = encounterOrder;
        }

        public final String getHistoryName() {
            return this.historyName;
        }

        public final int getEncounterOrder() {
            return this.encounterOrder;
        }

        public final byte[] toRecoveryBytes() throws Exception {
            ByteBuffer buffer = new ByteBuffer();
            buffer.writeInt(45323);
            buffer.writeUTF(this.historyName);
            buffer.writeInt(this.encounterOrder);
            return buffer.toByteArray();
        }

        public final void fromRecoveryBytes(DataInputStream dis) throws Exception {
            int magic = dis.readInt();
            if (magic != 45323) {
                throw new Exception("Wrong magic number ( " + magic + " ) while reading history table of contents");
            }
            this.historyName = dis.readUTF();
            this.encounterOrder = dis.readInt();
        }

        public final String toString() {
            return "mapped " + this.historyName + " to " + this.encounterOrder;
        }
    }
}

