/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm.req;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfReadRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfHttp.comm.rsp.BDdfHttpInspectReadResponse;
import com.tridium.ddfHttp.identify.BIDdfHttpInspectUrl;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDdfHttpInspectReadRequest
extends BDdfReadRequest {
    public static final Type TYPE = Sys.loadType(BDdfHttpInspectReadRequest.class);
    protected String urlAddress = "";

    public Type getType() {
        return TYPE;
    }

    public byte[] toByteArray() {
        String deviceUrl;
        String readUrl;
        BDdfIdParams readParameters = this.getReadParameters();
        BDdfIdParams deviceId = this.getDeviceId();
        if (readParameters instanceof BIDdfHttpInspectUrl) {
            readUrl = ((BIDdfHttpInspectUrl)readParameters).getUrl();
            if (readUrl.trim().length() == 0 || readUrl.trim().equals("-")) {
                readUrl = null;
            }
        } else {
            readUrl = null;
        }
        if (deviceId instanceof BIDdfHttpInspectUrl) {
            deviceUrl = ((BIDdfHttpInspectUrl)deviceId).getUrl();
            if (deviceUrl.trim().length() == 0 || deviceUrl.trim().equals("-")) {
                deviceUrl = null;
            }
        } else {
            deviceUrl = null;
        }
        if (readUrl == null && deviceUrl == null) {
            throw new BajaRuntimeException("No URL!");
        }
        if (deviceUrl != null && readUrl != null) {
            if (deviceUrl.endsWith("/")) {
                deviceUrl = deviceUrl.substring(0, deviceUrl.length() - 1);
            }
            if (readUrl.startsWith("/")) {
                readUrl = readUrl.substring(1);
            }
            this.urlAddress = deviceUrl + '/' + readUrl;
        } else if (deviceUrl == null) {
            this.urlAddress = readUrl;
        } else if (readUrl == null) {
            this.urlAddress = deviceUrl;
        } else {
            throw new IllegalStateException("Program Execution should not have made it here");
        }
        return this.urlAddress.getBytes();
    }

    public BIDdfResponse processReceive(IDdfDataFrame ddfDataFrame) throws DdfResponseException {
        return new BDdfHttpInspectReadResponse(ddfDataFrame, this.urlAddress);
    }
}

