/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfNullReceiver;
import com.tridium.ddfHttp.comm.BDdfHttpCommunicator;
import com.tridium.ddfHttp.comm.BDdfHttpTransmitter;
import javax.baja.net.HttpException;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDdfHttpReceiver
extends BDdfNullReceiver {
    public static final Type TYPE = Sys.loadType(BDdfHttpReceiver.class);
    DdfHttpReceiveFrame receiveFrame = new DdfHttpReceiveFrame(this);

    public Type getType() {
        return TYPE;
    }

    public BDdfHttpReceiver() {
        this.setResponseTimeout(BRelTime.makeSeconds((int)10));
    }

    public BDdfHttpCommunicator getHttpCommunicator() {
        return (BDdfHttpCommunicator)this.getDdfCommunicator();
    }

    protected IDdfDataFrame doReceiveFrame() throws Exception {
        this.resetReceiveBuffer();
        BDdfHttpTransmitter httpTransmitter = this.getHttpCommunicator().getHttpTransmitter();
        try {
            this.getInternalHttpBuffer().write(httpTransmitter.getHttpHelper().waitReceiveNextAndClose());
        }
        catch (HttpException he) {
            this.receiveFrame.httpException = he;
        }
        return this.receiveFrame;
    }

    protected void resetReceiveBuffer() {
        this.receiveFrame.reset();
        this.receiveFrame.httpException = null;
    }

    protected DdfHttpReceiveFrame getInternalHttpBuffer() {
        return this.receiveFrame;
    }

    public static class DdfHttpReceiveFrame
    extends ByteBuffer
    implements IDdfDataFrame {
        public HttpException httpException = null;
        protected final BDdfHttpReceiver httpReceiver = null;

        protected DdfHttpReceiveFrame(BDdfHttpReceiver httpReceiver) {
            super(512);
        }

        public byte[] getFrameBytes() {
            return this.getBytes();
        }

        public HttpException getHttpException() {
            return this.httpException;
        }

        public int getFrameSize() {
            return this.getLength();
        }

        public BSimple getFrameTag() {
            return this.httpReceiver.computeTag(this);
        }

        public IDdfDataFrame getFrameCopy() {
            DdfHttpReceiveFrame retVal = new DdfHttpReceiveFrame(this.httpReceiver);
            retVal.write(this.toByteArray());
            retVal.httpException = this.httpException;
            return retVal;
        }
    }
}

