/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionCommunicator;
import com.tridium.ddfHttp.comm.BDdfHttpReceiver;
import com.tridium.ddfHttp.comm.BDdfHttpTransmitter;
import com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword;
import com.tridium.ddfHttp.comm.DdfHttpHelper;
import com.tridium.ddfHttp.comm.req.BIDdfHttpCredentialsReq;
import com.tridium.ddfHttp.comm.req.BIDdfHttpStreamRequest;
import java.net.MalformedURLException;
import javax.baja.security.BICredentials;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDdfHttpCommunicator
extends BDdfSingleTransactionCommunicator {
    public static final Property transmitter = BDdfHttpCommunicator.newProperty((int)0, (BValue)new BDdfHttpTransmitter(), null);
    public static final Property receiver = BDdfHttpCommunicator.newProperty((int)0, (BValue)new BDdfHttpReceiver(), null);
    public static final Property credentials = BDdfHttpCommunicator.newProperty((int)0, (BValue)new BDdfHttpUserNameAndPassword(), (BFacets)DdfFacets.combine((BFacets)MGR_INCLUDE, (BFacets)MGR_OPTIONAL_IN_TABLE));
    public static final Type TYPE = Sys.loadType(BDdfHttpCommunicator.class);
    HttpUrlChecker httpUrlChecker;

    public BDdfTransmitter getTransmitter() {
        return (BDdfTransmitter)this.get(transmitter);
    }

    public void setTransmitter(BDdfTransmitter v) {
        this.set(transmitter, (BValue)v, null);
    }

    public BDdfReceiver getReceiver() {
        return (BDdfReceiver)this.get(receiver);
    }

    public void setReceiver(BDdfReceiver v) {
        this.set(receiver, (BValue)v, null);
    }

    public BDdfHttpUserNameAndPassword getCredentials() {
        return (BDdfHttpUserNameAndPassword)this.get(credentials);
    }

    public void setCredentials(BDdfHttpUserNameAndPassword v) {
        this.set(credentials, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDdfHttpTransmitter getHttpTransmitter() {
        return (BDdfHttpTransmitter)this.getDdfTransmitter();
    }

    public BDdfHttpReceiver getHttpReceiver() {
        return (BDdfHttpReceiver)this.getDdfReceiver();
    }

    public BICredentials getHttpCredentials(BIDdfRequest ddfHttpRequest) {
        if (ddfHttpRequest instanceof BIDdfHttpCredentialsReq) {
            BICredentials reqCredentials = ((BIDdfHttpCredentialsReq)ddfHttpRequest).getCredentials();
            if (reqCredentials == null) {
                return this.getCredentials();
            }
            return reqCredentials;
        }
        return this.getCredentials();
    }

    public String getHttpContentType(BIDdfRequest ddfHttpRequest) {
        return "application/x-www-form-urlencoded";
    }

    public int getSoTimeout(BIDdfRequest ddfHttpRequest) {
        return (int)ddfHttpRequest.getResponseTimeout().getMillis();
    }

    protected void preProcessStreamRequest(BIDdfHttpStreamRequest ddfRequest) {
        ddfRequest.setResponseTimeout(BRelTime.DEFAULT);
    }

    protected void preValidateUrl(BIDdfRequest ddfRequest) throws Exception {
        if (this.httpUrlChecker == null) {
            this.httpUrlChecker = new HttpUrlChecker();
        }
        this.httpUrlChecker.checkUrl(ddfRequest);
    }

    public void doCommunicate(BIDdfRequest ddfRequest) {
        if (ddfRequest instanceof BIDdfHttpStreamRequest) {
            this.preProcessStreamRequest((BIDdfHttpStreamRequest)ddfRequest);
        }
        try {
            this.preValidateUrl(ddfRequest);
            super.doCommunicate(ddfRequest);
        }
        catch (Exception e) {
            DdfRequestUtil.processTimeout((BIDdfRequest)ddfRequest);
        }
    }

    public boolean traceText() {
        return false;
    }

    class HttpUrlChecker
    extends DdfHttpHelper {
        HttpUrlChecker() {
            super(BDdfHttpCommunicator.this.getHttpTransmitter());
        }

        void checkUrl(BIDdfRequest ddfRequest) throws MalformedURLException {
            this.mostRecentDdfRequest = ddfRequest;
            this.httpCommunicator = BDdfHttpCommunicator.this;
            this.parseJavaUrl();
            String host = this.mostRecentJavaUrl.getHost();
            if (host.length() == 0 || host.equals("###.###.###.###") || host.equals("[***DEFAULT***]")) {
                throw new MalformedURLException("Invalid host: " + host);
            }
        }
    }
}

