/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import com.tridium.schedule.ScheduleUtil;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BEnumSetSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BEnumSet;

@NiagaraType
@NiagaraProperty(name="set", type="BEnumSet", defaultValue="BEnumSet.DEFAULT", flags=0x10000000, facets={@Facet(name="BFacets.RANGE", value="BEnumRange.make(ScheduleUtil.weekdays)")}, override=true)
public class BWeekdaySchedule
extends BEnumSetSchedule {
    public static final Property set = BWeekdaySchedule.newProperty((int)0x10000000, (BValue)BEnumSet.DEFAULT, (BFacets)BFacets.make((String)"range", (BIDataValue)BEnumRange.make((String[])ScheduleUtil.weekdays)));
    public static final Type TYPE = Sys.loadType(BWeekdaySchedule.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BWeekdaySchedule() {
    }

    public BWeekdaySchedule(BWeekday day) {
        this.add((BEnum)day);
    }

    @Override
    public boolean isAlwaysEffective() {
        if (super.isAlwaysEffective()) {
            return true;
        }
        BEnumSet set = this.getSet();
        if (!set.contains(0)) {
            return false;
        }
        if (!set.contains(1)) {
            return false;
        }
        if (!set.contains(2)) {
            return false;
        }
        if (!set.contains(3)) {
            return false;
        }
        if (!set.contains(4)) {
            return false;
        }
        if (!set.contains(5)) {
            return false;
        }
        return set.contains(6);
    }

    @Override
    public boolean isEffective(BAbsTime at) {
        return this.isEffective(at.getWeekday().getOrdinal());
    }

    @Override
    public int getMax() {
        return 6;
    }

    @Override
    public int getMin() {
        return 0;
    }

    @Override
    public BAbsTime nextEvent(BAbsTime from) {
        if (this.isAlwaysEffective() || this.isNeverEffective()) {
            return null;
        }
        from = BAbsTime.make((int)from.getYear(), (BMonth)from.getMonth(), (int)from.getDay(), (int)0, (int)0, (int)0, (int)0, (BTimeZone)from.getTimeZone());
        boolean effective = this.isEffective(from);
        BWeekday wd = from.getWeekday();
        int dayOfYear = from.getDayOfYear();
        int year = from.getYear();
        while (this.contains(wd.getOrdinal()) == effective) {
            ++dayOfYear;
            wd = wd.next();
        }
        while (dayOfYear > BAbsTime.getDaysInYear((int)year)) {
            dayOfYear -= BAbsTime.getDaysInYear((int)year);
            ++year;
        }
        return BAbsTime.makeDayOfYear((int)year, (int)dayOfYear, (int)0, (int)0, (int)0, (int)0, (BTimeZone)from.getTimeZone());
    }
}

