/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BEnumSetSchedule;
import javax.baja.schedule.BMonthSchedule;
import javax.baja.schedule.BWeekOfMonthSchedule;
import javax.baja.schedule.BWeekdaySchedule;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BWeekAndDaySchedule
extends BCompositeSchedule {
    public static final Property union = BWeekAndDaySchedule.newProperty((int)0x10000001, (boolean)false, null);
    public static final Property months = BWeekAndDaySchedule.newProperty((int)0, (BValue)new BMonthSchedule().initEffectiveWhenEmpty(true).initSingleSelection(true), null);
    public static final Property weeksOfMonth = BWeekAndDaySchedule.newProperty((int)0, (BValue)new BWeekOfMonthSchedule().initEffectiveWhenEmpty(true).initSingleSelection(true), null);
    public static final Property weekdays = BWeekAndDaySchedule.newProperty((int)0, (BValue)new BWeekdaySchedule().initEffectiveWhenEmpty(true).initSingleSelection(true), null);
    public static final Type TYPE = Sys.loadType(BWeekAndDaySchedule.class);

    public BMonthSchedule getMonths() {
        return (BMonthSchedule)this.get(months);
    }

    public void setMonths(BMonthSchedule v) {
        this.set(months, (BValue)v, null);
    }

    public BWeekOfMonthSchedule getWeeksOfMonth() {
        return (BWeekOfMonthSchedule)this.get(weeksOfMonth);
    }

    public void setWeeksOfMonth(BWeekOfMonthSchedule v) {
        this.set(weeksOfMonth, (BValue)v, null);
    }

    public BWeekdaySchedule getWeekdays() {
        return (BWeekdaySchedule)this.get(weekdays);
    }

    public void setWeekdays(BWeekdaySchedule v) {
        this.set(weekdays, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public int getMonth() {
        return this.getField(this.getMonths());
    }

    public int getWeek() {
        return this.getField(this.getWeeksOfMonth());
    }

    public int getWeekday() {
        return this.getField(this.getWeekdays());
    }

    public void setMonth(int val) {
        this.getMonths().clear();
        if (val == -1) {
            this.getMonths().setAlwaysEffective(true);
        } else {
            this.getWeekdays().setAlwaysEffective(false);
            this.getMonths().add(val);
        }
    }

    public void setWeek(int val) {
        this.getWeeksOfMonth().clear();
        if (val == -1) {
            this.getWeeksOfMonth().setAlwaysEffective(true);
        } else {
            this.getWeekdays().setAlwaysEffective(false);
            this.getWeeksOfMonth().add(val);
        }
    }

    public void setWeekday(int val) {
        this.getWeekdays().clear();
        if (val == -1) {
            this.getWeekdays().setAlwaysEffective(true);
        } else {
            this.getWeekdays().setAlwaysEffective(false);
            this.getWeekdays().add(val);
        }
    }

    public String toString(Context cx) {
        Lexicon l = Lexicon.make(BAbstractSchedule.class);
        boolean criteria = false;
        StringBuffer buf = new StringBuffer(l.get("type.weekAndDaySchedule"));
        buf.append(": ");
        int i = this.getWeekday();
        if (i >= 0) {
            BWeekday w = BWeekday.make((int)i);
            buf.append(w.getShortDisplayTag(cx));
            criteria = true;
        }
        if ((i = this.getWeek()) >= 0) {
            if (criteria) {
                buf.append(' ');
            }
            if (i == 6) {
                buf.append(l.get("week.last7days"));
            } else if (i < 6) {
                buf.append(l.get("week.week")).append(' ').append(i);
            } else {
                buf.append(l.get("week.calendarWeek")).append(' ').append(i - 6);
            }
            criteria = true;
        } else if (criteria) {
            buf.append(' ').append(l.get("week.everyWeek"));
        }
        i = this.getMonth();
        if (i >= 0) {
            if (criteria) {
                buf.append(' ');
            }
            if (i == 12) {
                buf.append(l.get("month.jan_mar_may_jul_sep_nov"));
            } else if (i == 13) {
                buf.append(l.get("month.feb_apr_jun_aug_oct_dec"));
            } else {
                BMonth m = BMonth.make((int)i);
                buf.append(m.getShortDisplayTag(cx));
            }
            criteria = true;
        } else if (criteria) {
            buf.append(' ').append(l.get("month.everyMonth"));
        }
        if (!criteria) {
            buf.append("*");
        }
        return buf.toString();
    }

    protected int getField(BEnumSetSchedule sch) {
        if (this.getAlwaysEffective()) {
            return -1;
        }
        if (sch.isAlwaysEffective()) {
            return -1;
        }
        return sch.first();
    }
}

