/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BScheduleReference
extends BAbstractSchedule {
    public static final Property ref = BScheduleReference.newProperty((int)0x10000000, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BScheduleReference.class);
    private static final BComponentEventMask mask = BComponentEventMask.make((int)8196);
    private BAbstractSchedule instance = null;
    private boolean errorLogged = false;
    Subscriber subscriber = new CalendarSubscriber();

    public BOrd getRef() {
        return (BOrd)this.get(ref);
    }

    public void setRef(BOrd v) {
        this.set(ref, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property p, Context c) {
        if (p == ref && this.instance != null) {
            if (this.isRunning()) {
                this.instance.removeReference(this);
            }
            this.instance = null;
            this.subscriber.unsubscribeAll();
            this.getSchedule();
        }
        super.changed(p, c);
    }

    public BAbstractSchedule getSchedule() {
        BAbstractSchedule s;
        block12: {
            s = this.instance;
            boolean running = this.isRunning();
            try {
                if (s == null) {
                    BOrd tmp = this.getRef();
                    if (tmp.isNull()) {
                        return null;
                    }
                    if (running) {
                        s = (BAbstractSchedule)tmp.get((BObject)this);
                        s.addReference(this);
                    } else {
                        BAbstractSchedule root = this.getRootSchedule();
                        BOrd refBase = (BOrd)root.get("refBase");
                        if (refBase == null) {
                            refBase = this.getAbsoluteOrd();
                        }
                        tmp = BOrd.make((BOrd)refBase, (BOrd)tmp);
                        s = (BAbstractSchedule)tmp.get();
                        s.lease(Integer.MAX_VALUE);
                    }
                    this.instance = s;
                    this.subscribeToCalendar();
                } else if (!running && !s.isSubscribed()) {
                    s.lease(Integer.MAX_VALUE);
                }
            }
            catch (Exception x) {
                if (this.errorLogged) break block12;
                log.log(Level.SEVERE, "(" + (Object)((Object)this) + ") Bad Reference: " + this.getRef(), x);
                this.errorLogged = true;
            }
        }
        if (s == null && !this.getRef().equals((Object)BOrd.NULL) && !this.errorLogged) {
            log.severe("(" + (Object)((Object)this) + ") Bad Reference: " + this.getRef());
            this.errorLogged = true;
        } else if (s != null) {
            this.errorLogged = false;
        }
        return s;
    }

    @Override
    public boolean isEffective(BAbsTime at) {
        BAbstractSchedule s = this.getSchedule();
        if (s == null) {
            return false;
        }
        return s.isEffective(at);
    }

    @Override
    public BAbsTime nextEvent(BAbsTime after) {
        BAbstractSchedule s = this.getSchedule();
        if (s == null) {
            return null;
        }
        return s.nextEvent(after);
    }

    public void started() throws Exception {
        super.started();
        if (Sys.isStationStarted()) {
            this.getSchedule();
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.getSchedule();
    }

    public void stopped() throws Exception {
        if (this.instance != null) {
            this.instance.removeReference(this);
        }
        this.instance = null;
        this.subscriber.unsubscribeAll();
        super.stopped();
    }

    public String toString(Context cx) {
        Lexicon l = Lexicon.make(BAbstractSchedule.class);
        return l.get("type.scheduleReference") + ": " + this.getRef().toString(cx);
    }

    private void subscribeToCalendar() {
        this.subscriber.unsubscribeAll();
        if (this.instance != null) {
            for (BAbstractSchedule parent = this.instance; parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BComponent)) continue;
                this.subscriber.subscribe((BComponent)parent);
            }
        }
    }

    void handleComponentEvent(BComponentEvent event) {
        if (event.getId() == 13) {
            if (this.instance != null) {
                this.setRef(this.instance.getSlotPathOrd());
            }
        } else if (event.getId() == 2) {
            BValue removed = event.getValue();
            BAbstractSchedule comp = this.instance;
            while (comp != null) {
                if (comp.equals(removed)) {
                    this.setRef(BOrd.NULL);
                    comp = null;
                    continue;
                }
                comp = comp.getParent();
            }
        }
    }

    class CalendarSubscriber
    extends Subscriber {
        public CalendarSubscriber() {
            this.setMask(mask);
        }

        public void event(BComponentEvent e) {
            BScheduleReference.this.handleComponentEvent(e);
        }
    }
}

