/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import com.tridium.schedule.ScheduleUtil;
import javax.baja.data.BIDataValue;
import javax.baja.schedule.BEnumSetSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BEnumSet;

public class BDayOfMonthSchedule
extends BEnumSetSchedule {
    public static final Property set = BDayOfMonthSchedule.newProperty((int)0x10000000, (BValue)BEnumSet.DEFAULT, (BFacets)BFacets.make((String)"range", (BIDataValue)BEnumRange.make((String[])ScheduleUtil.daysOfMonth)));
    public static final Type TYPE = Sys.loadType(BDayOfMonthSchedule.class);

    @Override
    public BEnumSet getSet() {
        return (BEnumSet)this.get(set);
    }

    @Override
    public void setSet(BEnumSet v) {
        this.set(set, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public int getMax() {
        return 35;
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public boolean isAlwaysEffective() {
        if (super.isAlwaysEffective()) {
            return true;
        }
        for (int i = 1; i <= 31; ++i) {
            if (this.contains(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEffective(BAbsTime at) {
        if (this.isAlwaysEffective()) {
            return true;
        }
        if (this.isNeverEffective()) {
            return false;
        }
        return this.isEffective(at.getDay(), BAbsTime.getDaysInMonth((int)at.getYear(), (BMonth)at.getMonth()));
    }

    @Override
    public BAbsTime nextEvent(BAbsTime after) {
        if (this.isAlwaysEffective() || this.isNeverEffective()) {
            return null;
        }
        boolean effective = this.isEffective(after);
        int cur = after.getDay();
        int daysInMonth = BAbsTime.getDaysInMonth((int)after.getYear(), (BMonth)after.getMonth());
        while (++cur <= daysInMonth) {
            if (this.isEffective(cur, daysInMonth) == effective) continue;
            return BAbsTime.make((int)after.getYear(), (BMonth)after.getMonth(), (int)cur, (int)0, (int)0, (int)0, (int)0, (BTimeZone)after.getTimeZone());
        }
        int year = after.getYear();
        BMonth month = after.getMonth();
        if (month == BMonth.december) {
            ++year;
            month = BMonth.january;
        } else {
            month = BMonth.make((int)(month.getOrdinal() + 1));
        }
        return BAbsTime.make((int)year, (BMonth)month, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)after.getTimeZone());
    }

    private final boolean isEffective(int dy, int daysInMonth) {
        if (this.isEffective(dy)) {
            return true;
        }
        if (dy == daysInMonth && this.contains(32)) {
            return true;
        }
        if (this.contains(33)) {
            return dy > daysInMonth - 7;
        }
        if (this.contains(34)) {
            return (dy & 1) != 0;
        }
        if (this.contains(35)) {
            return dy % 2 == 0;
        }
        return false;
    }
}

