/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BDateRangeSchedule
extends BAbstractSchedule {
    public static final Property start = BDateRangeSchedule.newProperty((int)0, (BValue)new BDateSchedule(), null);
    public static final Property end = BDateRangeSchedule.newProperty((int)0, (BValue)new BDateSchedule(), null);
    public static final Type TYPE = Sys.loadType(BDateRangeSchedule.class);

    public BDateSchedule getStart() {
        return (BDateSchedule)this.get(start);
    }

    public void setStart(BDateSchedule v) {
        this.set(start, (BValue)v, null);
    }

    public BDateSchedule getEnd() {
        return (BDateSchedule)this.get(end);
    }

    public void setEnd(BDateSchedule v) {
        this.set(end, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isEffective(BAbsTime arg) {
        if (this.getAlwaysEffective()) {
            return true;
        }
        BDateSchedule str = this.getStart();
        BDateSchedule end = this.getEnd();
        int strTo = str.compareTo(arg);
        int endTo = end.compareTo(arg);
        int tmp = str.getYear();
        int argYear = arg.getYear();
        if (tmp >= 0 && tmp > argYear) {
            return false;
        }
        tmp = end.getYear();
        if (tmp >= 0 && tmp < argYear) {
            return false;
        }
        if (str.compareTo(end) <= 0) {
            return strTo <= 0 && endTo >= 0;
        }
        return strTo <= 0 || endTo >= 0;
    }

    @Override
    public BAbsTime nextEvent(BAbsTime t) {
        BAbsTime startNext = this.getStart().nextEvent(t);
        BAbsTime endNext = this.getEnd().nextEvent(t);
        if (startNext == null) {
            return endNext;
        }
        if (endNext == null) {
            return startNext;
        }
        if (startNext.isBefore(endNext)) {
            return startNext;
        }
        return endNext;
    }

    public String toString(Context cx) {
        String s = this.getStart().criteriaString(cx);
        String e = this.getEnd().criteriaString(cx);
        Lexicon l = Lexicon.make(BAbstractSchedule.class);
        return l.get("type.dateRangeSchedule") + ": " + s + " - " + e;
    }
}

