/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BBooleanScheduleSelector;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BEnumScheduleSelector;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BNumericScheduleSelector;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BStringScheduleSelector;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public abstract class BAbstractScheduleSelector
extends BComponent {
    public static final Property container = BAbstractScheduleSelector.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Property schedule = BAbstractScheduleSelector.newProperty((int)256, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Action updateScheduleList = BAbstractScheduleSelector.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAbstractScheduleSelector.class);
    Context noWriteContext = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "schedule:noWriteContext";
        }
    };
    private static final BIcon icon = BIcon.std((String)"schedule.png");
    private static final String LINK_ERROR_BAD_RANGE = "selector.link.error.badRange";
    static final String SCHEDULE_CONTAINER_LINK = "ScheduleLink";
    static Lexicon lexicon = Lexicon.make(BAbstractSchedule.class);
    Subscriber subscriber = new ContainerSubscriber();

    public BOrd getContainer() {
        return (BOrd)this.get(container);
    }

    public void setContainer(BOrd v) {
        this.set(container, (BValue)v, null);
    }

    public BDynamicEnum getSchedule() {
        return (BDynamicEnum)this.get(schedule);
    }

    public void setSchedule(BDynamicEnum v) {
        this.set(schedule, (BValue)v, null);
    }

    public void updateScheduleList() {
        this.invoke(updateScheduleList, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.subscribeToContainer();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.unsubscribeFromContainer();
    }

    protected LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        if (targetSlot == schedule) {
            source.lease();
            BFacets sourceFacets = source.getSlotFacets(sourceSlot);
            if (!this.getSchedule().getRange().equals((Object)sourceFacets.get("range"))) {
                return LinkCheck.makeInvalid((String)lexicon.get(LINK_ERROR_BAD_RANGE));
            }
        }
        return LinkCheck.makeValid();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!Sys.atSteadyState()) {
            return;
        }
        if (cx == this.noWriteContext || cx == Context.decoding || !this.isRunning()) {
            return;
        }
        if (p.equals(schedule)) {
            this.linkSchedule(this, schedule, this.getSchedule().getDisplayTag(cx), this.getSchedule().getOrdinal());
        }
        if (p.equals(container)) {
            this.removeCurrentLink();
            this.subscribeToContainer();
            this.fillInScheduleEnums(this, schedule);
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        BLink link;
        if (oldValue instanceof BLink && (link = (BLink)oldValue).getTargetSlotName().equals(schedule.getName())) {
            this.doUpdateScheduleList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribeToContainer() {
        BComponent scheduleContainer = null;
        BComponent[] kids = null;
        Class<?> scheduleClass = null;
        try {
            this.unsubscribeFromContainer();
            scheduleContainer = this.getScheduleContainer();
            if (scheduleContainer != null) {
                this.subscriber.subscribe(scheduleContainer);
                scheduleClass = this.getScheduleClass(this);
                if (scheduleClass != null && (kids = (BComponent[])scheduleContainer.getChildren(scheduleClass)) != null) {
                    for (int i = 0; i < kids.length; ++i) {
                        this.subscriber.subscribe(kids[i]);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            scheduleContainer = null;
            kids = null;
            scheduleClass = null;
        }
    }

    private void unsubscribeFromContainer() {
        try {
            this.subscriber.unsubscribeAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Class<?> getScheduleClass(BComponent scheduleSelector) {
        try {
            if (scheduleSelector instanceof BBooleanScheduleSelector) {
                return BBooleanSchedule.class;
            }
            if (scheduleSelector instanceof BNumericScheduleSelector) {
                return BNumericSchedule.class;
            }
            if (scheduleSelector instanceof BStringScheduleSelector) {
                return BStringSchedule.class;
            }
            if (scheduleSelector instanceof BEnumScheduleSelector) {
                return BEnumSchedule.class;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void doUpdateScheduleList() {
        try {
            this.fillInScheduleEnums(this, schedule);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BComponent getCurrentScheduleComponent(BComponent scheduleSelector) {
        BComponent sourceComponent = null;
        BLink link = null;
        try {
            link = (BLink)this.get(SCHEDULE_CONTAINER_LINK);
            if (link != null) {
                sourceComponent = link.getSourceComponent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            link = null;
        }
        return sourceComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentSchedule(BComponent scheduleSelector) {
        String currentSchedule = SlotPath.escape((String)lexicon.get("selector.nullString"));
        BComponent sourceComponent = null;
        try {
            sourceComponent = this.getCurrentScheduleComponent(scheduleSelector);
            if (sourceComponent != null) {
                currentSchedule = sourceComponent.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sourceComponent = null;
        }
        return currentSchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BComponent getScheduleContainer() {
        BComponent scheduleContainer = null;
        BOrd containerOrd = null;
        try {
            containerOrd = this.getContainer();
            if (containerOrd != null && !containerOrd.isNull()) {
                try {
                    scheduleContainer = (BComponent)containerOrd.resolve().get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            containerOrd = null;
        }
        return scheduleContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillInScheduleEnums(BComponent scheduleSelector, Property field) {
        String currentSchedule = null;
        BComponent scheduleContainer = null;
        BComponent[] kids = null;
        Class<?> scheduleClass = null;
        try {
            currentSchedule = this.getCurrentSchedule(scheduleSelector);
            scheduleContainer = this.getScheduleContainer();
            if (scheduleContainer != null && (scheduleClass = this.getScheduleClass(this)) != null) {
                kids = (BComponent[])scheduleContainer.getChildren(scheduleClass);
            }
            this.fillInScheduleEnums(scheduleSelector, field, kids, currentSchedule);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            currentSchedule = null;
            scheduleContainer = null;
            kids = null;
            scheduleClass = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillInScheduleEnums(BComponent scheduleSelector, Property field, BComponent[] kids, String currentSchedule) {
        String[] scheduleList = null;
        Object tag = null;
        int index = 0;
        try {
            if (kids != null) {
                try {
                    scheduleList = new String[kids.length + 1];
                    scheduleList[index++] = SlotPath.escape((String)lexicon.get("selector.nullString"));
                    for (int i = 0; i < kids.length; ++i) {
                        scheduleList[index++] = kids[i].getName();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (scheduleList == null) {
                scheduleList = new String[]{SlotPath.escape((String)lexicon.get("selector.nullString"))};
            }
            scheduleSelector.set(field, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])scheduleList)), this.noWriteContext);
            if (currentSchedule != null) {
                scheduleSelector.set(field, (BValue)BDynamicEnum.make((int)((BDynamicEnum)scheduleSelector.get(field)).getRange().tagToOrdinal(currentSchedule), (BEnumRange)((BDynamicEnum)scheduleSelector.get(field)).getRange()), this.noWriteContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            scheduleList = null;
            tag = null;
        }
    }

    private void linkSchedule(BComponent scheduleSelector, Property field, String selectedSchedule, int ordinal) {
        try {
            this.removeCurrentLink();
            if (ordinal != 0) {
                this.linkToContainerSchedule(scheduleSelector, field, selectedSchedule);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeCurrentLink() {
        BLink link = null;
        try {
            link = (BLink)this.get(SCHEDULE_CONTAINER_LINK);
            if (link != null) {
                link.deactivate();
                this.remove(SCHEDULE_CONTAINER_LINK);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            link = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void linkToContainerSchedule(BComponent scheduleSelector, Property field, String selectedSchedule) {
        block8: {
            BOrd containerOrd = null;
            BComponent scheduleContainer = null;
            BControlSchedule scheduleComponent = null;
            BOrd sourceOrd = null;
            Object linkToScheduleOrd = null;
            BLink link = null;
            try {
                containerOrd = this.getContainer();
                if (containerOrd == null || containerOrd.isNull()) break block8;
                try {
                    scheduleContainer = (BComponent)containerOrd.resolve().get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (scheduleContainer != null && (scheduleComponent = (BControlSchedule)scheduleContainer.get(SlotPath.escape((String)selectedSchedule))) != null) {
                    sourceOrd = scheduleComponent.getHandleOrd();
                    link = new BLink(sourceOrd, "out", "in", true);
                    this.add(SCHEDULE_CONTAINER_LINK, (BValue)link);
                    link.activate();
                    scheduleSelector.set(scheduleSelector.getProperty("facets"), (BValue)scheduleComponent.getFacets());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                containerOrd = null;
                scheduleContainer = null;
                scheduleComponent = null;
                sourceOrd = null;
                linkToScheduleOrd = null;
                link = null;
            }
        }
    }

    void handleComponentEvent(BComponentEvent event) {
        if (event.getId() == 1) {
            this.subscribeToContainer();
            this.fillInScheduleEnums(this, schedule);
            return;
        }
        if (event.getId() == 2) {
            this.subscribeToContainer();
            this.fillInScheduleEnums(this, schedule);
            return;
        }
        if (event.getId() == 3) {
            this.fillInScheduleEnums(this, schedule);
            return;
        }
        if (event.getId() == 0) {
            if (event.getSlotName().equals("facets")) {
                BComponent sourceComponent = null;
                sourceComponent = this.getCurrentScheduleComponent(this);
                if (sourceComponent != null) {
                    if (sourceComponent.equals((Object)event.getSourceComponent())) {
                        this.set(this.getProperty("facets"), (BValue)((BControlSchedule)event.getSourceComponent()).getFacets());
                    }
                    Object var2_2 = null;
                }
            }
            return;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    class ContainerSubscriber
    extends Subscriber {
        ContainerSubscriber() {
        }

        public void event(BComponentEvent e) {
            BAbstractScheduleSelector.this.handleComponentEvent(e);
        }
    }
}

