/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import java.util.GregorianCalendar;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BWeekday;

public class Chronometer
extends GregorianCalendar {
    public static final BRelTime _90_DAYS = BRelTime.make((long)7776000000L);
    public static final BRelTime _365_DAYS = BRelTime.make((long)31536000000L);

    public Chronometer() {
    }

    public Chronometer(long timeMillis) {
        this.setMillis(timeMillis);
    }

    public Chronometer(BAbsTime time) {
        this.setMillis(time.getMillis());
    }

    public Chronometer(int year, int month, int date, int hour, int min, int sec, int millis) {
        super(year, month, date, hour, min, sec);
        if (millis > 0) {
            this.set(14, millis);
        }
    }

    public void addDate() {
        int day = this.internalGet(5);
        day = day == this.getActualMaximum(5) ? 1 : ++day;
        this.set(5, day);
        if (day == 1) {
            int month = this.internalGet(2);
            month = month == 11 ? 0 : ++month;
            this.set(2, month);
            if (month == 0) {
                this.set(1, this.internalGet(1) + 1);
            }
        }
    }

    @Override
    public int compareTo(GregorianCalendar c) {
        return this.compareTo((Chronometer)c);
    }

    @Override
    public int compareTo(Chronometer c) {
        return this.compareTo(c.getMillis());
    }

    @Override
    public int compareTo(long timeMillis) {
        long me = this.getTimeInMillis();
        if (me > timeMillis) {
            return 1;
        }
        if (me < timeMillis) {
            return -1;
        }
        return 0;
    }

    public BAbsTime getAbsTime() {
        return BAbsTime.make((long)this.getTimeInMillis());
    }

    public long getMillis() {
        return this.getTimeInMillis();
    }

    public BMonth getMonth() {
        return BMonth.make((int)this.internalGet(2));
    }

    public BWeekday getWeekday() {
        return BWeekday.make((int)(this.internalGet(7) - 1));
    }

    public void setMillis(long time) {
        this.setTimeInMillis(time);
    }

    public void subtractDate() {
        int day = this.internalGet(5);
        if (day > 1) {
            this.set(5, --day);
            return;
        }
        int month = this.internalGet(2);
        if (month == 0) {
            this.set(2, 11);
            this.set(1, this.internalGet(1) - 1);
        } else {
            this.set(2, --month);
        }
        this.set(5, this.getActualMaximum(5));
    }
}

