/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui.terminal;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.job.BAaPhpVirtualTerminalJob;
import com.tridium.aaphp.ui.terminal.AaPhpTextController;
import com.tridium.platform.ui.util.BTextOutputPane;
import com.tridium.platform.ui.util.LimitedTextModel;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

public class BAaPhpVirtualTerminal
extends BWbComponentView {
    public static final Property displayText = BAaPhpVirtualTerminal.newProperty((int)0, (String)"", null);
    public static final Action finalScrollFix = BAaPhpVirtualTerminal.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAaPhpVirtualTerminal.class);
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BAaPhpVirtualTerminal.class);
    static final BImage icon = BImage.make((String)"module://icons/x16/textFileEditor.png");
    public static final int BUFFER_SIZE = 500;
    BTextOutputPane console;
    StartConsole cmdStartConsole = new StartConsole((BWidget)this);
    StopConsole cmdStopConsole = new StopConsole((BWidget)this);
    BAaPhpDevice device;
    boolean consoleJobComplete = false;
    BAaPhpVirtualTerminalJob consoleJob = null;
    BOrd jobOrd = null;
    private Clock.Ticket scrollFixTicket;

    public String getDisplayText() {
        return this.getString(displayText);
    }

    public void setDisplayText(String v) {
        this.setString(displayText, v, null);
    }

    public void finalScrollFix() {
        this.invoke(finalScrollFix, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAaPhpVirtualTerminal() {
        this.console = new BTextOutputPane();
        this.console.setUseAutoScroll(true);
        this.console.getEditor().setController((TextController)new AaPhpTextController(this));
        this.console.getEditor().setModel((TextModel)new LimitedTextModel());
        this.setTransferWidget((BTransferWidget)this.console.getEditor());
        BGridPane buttonPane = new BGridPane();
        buttonPane.setColumnCount(2);
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdStartConsole));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdStopConsole));
        this.cmdStopConsole.setEnabled(false);
        this.cmdStartConsole.setEnabled(true);
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)this.console);
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)edge);
        this.registerForComponentEvents((BComponent)this.console);
        this.console.getEditor().requestFocus();
    }

    public void doLoadValue(BObject object, Context cx) {
        this.device = (BAaPhpDevice)object;
    }

    public void deactivated() {
        if (this.cmdStopConsole.isEnabled()) {
            try {
                this.cmdStopConsole.doInvoke();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void exec(String cmd) {
        cmd = cmd.replace('\n', '\r');
        try {
            if (this.consoleJob != null) {
                this.consoleJob.setCommand(BString.make((String)cmd));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        if (this.consoleJob == null) {
            return;
        }
        if (event.getSourceComponent() == this.console) {
            // empty if block
        }
        if (event.getSourceComponent() == this.consoleJob) {
            if (this.consoleJob.getJobState().isComplete() && !this.consoleJobComplete) {
                this.consoleJobComplete = true;
                this.cmdStartConsole.setEnabled(true);
                this.cmdStopConsole.setEnabled(false);
            } else {
                if (event.getId() == 0) {
                    // empty if block
                }
                if (event.getId() == 5 && event.getSlotName() == "textReceived") {
                    if (this.scrollFixTicket != null) {
                        this.scrollFixTicket.cancel();
                    }
                    this.scrollFixTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)1), (Action)finalScrollFix, null);
                    String newFrag = ((BString)event.getValue()).getString();
                    if (newFrag.indexOf(8) != -1) {
                        this.appendStringWithBackspace(newFrag);
                    } else {
                        this.console.append(newFrag);
                    }
                    this.console.getEditor().requestFocus();
                }
            }
            return;
        }
    }

    private void appendStringWithBackspace(String special) {
        String bs = special;
        if (bs.length() == 1) {
            this.backspace();
            return;
        }
        int index = 0;
        try {
            while (index != -1) {
                System.out.println(ByteArrayUtil.toHexString((byte[])bs.getBytes()));
                index = bs.indexOf(8);
                System.out.println("index:" + index);
                if (index != 0) {
                    this.console.append(bs.substring(0, index));
                }
                this.backspace();
                bs = bs.substring(index + 1);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void backspace() {
        Position pos = this.console.getEditor().getCaretPosition();
        this.console.getEditor().getModel().remove(new Position(pos.line, pos.column - 1), new Position(pos.line, pos.column - 1));
    }

    public void scrollToEnd() {
        this.console.scrollToEnd();
    }

    public void doFinalScrollFix() {
        this.console.scrollToEnd();
        this.scrollFixTicket = null;
    }

    class StopConsole
    extends Command {
        StopConsole(BWidget owner) {
            super(owner, (Lexicon)lexicon, "stopVirtualTerminal");
        }

        public CommandArtifact doInvoke() throws Exception {
            BAaPhpVirtualTerminal.this.consoleJob.cancel();
            BAaPhpVirtualTerminal.this.consoleJob = null;
            BAaPhpVirtualTerminal.this.jobOrd = null;
            BAaPhpVirtualTerminal.this.cmdStartConsole.setEnabled(true);
            this.setEnabled(false);
            return null;
        }
    }

    class StartConsole
    extends Command {
        StartConsole(BWidget owner) {
            super(owner, (Lexicon)lexicon, "startVirtualTerminal");
        }

        public CommandArtifact doInvoke() throws Exception {
            BAaPhpVirtualTerminal.this.cmdStopConsole.setEnabled(true);
            this.setEnabled(false);
            BAaPhpVirtualTerminal.this.jobOrd = BAaPhpVirtualTerminal.this.device.submitVirtualTerminalJob();
            BAaPhpVirtualTerminal.this.device.getComponentSpace().sync();
            BAaPhpVirtualTerminal.this.consoleJob = (BAaPhpVirtualTerminalJob)BAaPhpVirtualTerminal.this.jobOrd.get((BObject)BAaPhpVirtualTerminal.this.device);
            BAaPhpVirtualTerminal.this.registerForComponentEvents((BComponent)BAaPhpVirtualTerminal.this.consoleJob);
            return null;
        }
    }
}

