/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui.editors;

import com.tridium.aaphp.util.AaPhpOrdParser;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BAaPhpFileOrdEditor
extends BWbFieldEditor {
    public static final Action byPathChanged = BAaPhpFileOrdEditor.newAction((int)0, null);
    public static final Action byDriveChanged = BAaPhpFileOrdEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAaPhpFileOrdEditor.class);
    private boolean init = false;
    public static String COLON_PIPE = ":|";
    ToggleCommandGroup<ToggleCommand> byDrivePathGroup = new ToggleCommandGroup();
    BRadioButton byDrive = new BRadioButton(this.byDrivePathGroup, "By Drive", true);
    BTextField drive = new BTextField("", 2);
    BTextField fileName = new BTextField("", 9);
    BTextField ext = new BTextField("", 4);
    BTextField dnum = new BTextField("0", 2);
    BRadioButton byPath = new BRadioButton(this.byDrivePathGroup, "By Path", false);
    BTextField filePath = new BTextField("", 20);
    BTextField pnum = new BTextField("0", 2);

    public void byPathChanged() {
        this.invoke(byPathChanged, null, null);
    }

    public void byDriveChanged() {
        this.invoke(byDriveChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    void addGraphic(BGridPane p, String label, String cname, BComponent c) {
        p.add(cname + "Label", (BValue)new BLabel(label));
        p.add(cname, (BValue)c);
    }

    void addRadioButton(BGridPane p, String cname, BRadioButton rb) {
        p.add(cname, (BValue)rb);
        p.add(cname + "Label", (BValue)new BLabel());
        p.add(cname + "Blank", (BValue)new BLabel(""));
        p.add(cname + "Blank", (BValue)new BLabel(""));
        p.add(cname + "Blank", (BValue)new BLabel(""));
        p.add(cname + "Blank", (BValue)new BLabel(""));
        p.add(cname + "Blank", (BValue)new BLabel(""));
        p.add(cname + "Blank", (BValue)new BLabel(""));
        p.add(cname + "Blank", (BValue)new BLabel(""));
    }

    public void initFullGui() {
        BGridPane outerPane = new BGridPane(2);
        outerPane.add("byDrive", (BValue)this.byDrive);
        BFlowPane byDrivePane = new BFlowPane();
        byDrivePane.add("drive", (BValue)this.drive);
        byDrivePane.add("fnameLabel", (BValue)new BLabel(":"));
        byDrivePane.add("fileName", (BValue)this.fileName);
        byDrivePane.add("extLabel", (BValue)new BLabel("."));
        byDrivePane.add("ext", (BValue)this.ext);
        byDrivePane.add("dnumLable", (BValue)new BLabel("#"));
        byDrivePane.add("dnum", (BValue)this.dnum);
        outerPane.add("r1c2", (BValue)byDrivePane);
        outerPane.add("byPath", (BValue)this.byPath);
        BFlowPane byPathPane = new BFlowPane();
        byPathPane.add("filePath", (BValue)this.filePath);
        byPathPane.add("pnumLabel", (BValue)new BLabel("#"));
        byPathPane.add("pnum", (BValue)this.pnum);
        outerPane.add("r2c2", (BValue)byPathPane);
        this.setContent((BWidget)outerPane);
        this.linkTo("l0", (BComponent)this.byDrive, (Slot)BRadioButton.actionPerformed, (Slot)setModified);
        this.linkTo("l1", (BComponent)this.byDrive, (Slot)BRadioButton.actionPerformed, (Slot)byDriveChanged);
        this.linkTo("l2", (BComponent)this.drive, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("l3", (BComponent)this.fileName, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("l4", (BComponent)this.ext, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("l5", (BComponent)this.dnum, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("l6", (BComponent)this.byPath, (Slot)BRadioButton.actionPerformed, (Slot)setModified);
        this.linkTo("l7", (BComponent)this.byPath, (Slot)BRadioButton.actionPerformed, (Slot)byPathChanged);
        this.linkTo("l8", (BComponent)this.filePath, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("l9", (BComponent)this.pnum, (Slot)BTextField.textModified, (Slot)setModified);
        this.init = true;
    }

    protected void doSetReadonly(boolean readonly) {
        this.init = false;
        if (readonly) {
            this.setContent((BWidget)new BTextField("", 45, false));
        }
    }

    protected void doLoadValue(BObject value, Context cx) {
        String aaphpOrd = ((BString)value).toString();
        if (this.isReadonly()) {
            ((BTextField)this.getContent()).setText(value.toString());
        } else {
            if (!this.init) {
                this.initFullGui();
            }
            try {
                AaPhpOrdParser p = new AaPhpOrdParser(aaphpOrd);
                if (p.isFileDrive()) {
                    this.byDrive.setSelected(true);
                    this.drive.setText("" + p.getDrive());
                    this.fileName.setText(p.getFName());
                    this.ext.setText(p.getExt());
                    this.dnum.setText("" + p.getFileNum());
                    this.byPath.setSelected(false);
                    this.enableDrive();
                } else if (p.isFilePath()) {
                    this.byPath.setSelected(true);
                    this.filePath.setText(p.getFilePath());
                    this.pnum.setText("" + p.getFileNum());
                    this.byDrive.setSelected(false);
                    this.enablePath();
                } else {
                    this.byDrive.setSelected(true);
                    this.enableDrive();
                }
            }
            catch (BajaRuntimeException bre) {
                this.byDrive.setSelected(true);
                this.enableDrive();
            }
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        StringBuffer aaphpOrdBuf = new StringBuffer().append("aaphp").append(COLON_PIPE).append("file").append(COLON_PIPE);
        if (this.byDrive.isSelected()) {
            aaphpOrdBuf.append("drv").append(':').append(this.drive.getText()).append('|');
            aaphpOrdBuf.append("fname").append(':').append(this.fileName.getText()).append('|');
            aaphpOrdBuf.append("ext").append(':').append(this.ext.getText()).append('|');
            aaphpOrdBuf.append("n").append(':').append(this.dnum.getText());
        } else if (this.byPath.isSelected()) {
            aaphpOrdBuf.append("path").append(':').append(this.filePath.getText()).append('|');
            aaphpOrdBuf.append("n").append(':').append(this.pnum.getText());
        }
        return BString.make((String)aaphpOrdBuf.toString());
    }

    public void doByPathChanged() {
        if (this.byPath.isSelected()) {
            this.enablePath();
        }
    }

    void enableDrive() {
        this.drive.setEditable(true);
        this.fileName.setEditable(true);
        this.ext.setEditable(true);
        this.dnum.setEditable(true);
        this.filePath.setEditable(false);
        this.pnum.setEditable(false);
        if (this.byPath.isSelected()) {
            this.byPath.setSelected(false);
        }
    }

    void enablePath() {
        this.drive.setEditable(false);
        this.fileName.setEditable(false);
        this.ext.setEditable(false);
        this.dnum.setEditable(false);
        this.filePath.setEditable(true);
        this.pnum.setEditable(true);
        if (this.byDrive.isSelected()) {
            this.byDrive.setSelected(false);
        }
    }

    public void doByDriveChanged() {
        if (this.byDrive.isSelected()) {
            this.enableDrive();
        }
    }
}

