/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.datatypes.BAaPhpSendFileJobParam;
import com.tridium.aaphp.datatypes.BAaPhpSendFileParam;
import com.tridium.aaphp.ui.BAaPhpDeviceManager;
import com.tridium.aaphp.util.AaPhpFileSupport;
import com.tridium.aaphp.util.AaPhpOrdParser;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBlob;
import javax.baja.sys.BObject;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrController;

public class AaPhpSendFileCommand
extends MgrController.MgrCommand {
    final BAaPhpDeviceManager aaphpDeviceManager;

    public AaPhpSendFileCommand(BAaPhpDeviceManager aaphpDeviceManager) {
        super((BWidget)aaphpDeviceManager, BAaPhpDevice.LEXICON, "sendFile");
        this.aaphpDeviceManager = aaphpDeviceManager;
    }

    private boolean validateSyntax(BAaPhpSendFileParam aaphpSendFileParam) {
        if (aaphpSendFileParam != null) {
            try {
                new AaPhpOrdParser(aaphpSendFileParam.getDestination());
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.aaphpDeviceManager, (String)"sendFile", (Object)"Unrecognized AaPhp File Ord", (Throwable)e);
                return false;
            }
            return aaphpSendFileParam.getSource() != null && aaphpSendFileParam.getSource() != BOrd.NULL;
        }
        return false;
    }

    private BBlob readFileIfLocal(BAaPhpSendFileParam param) {
        return AaPhpFileSupport.getFirmwareBlob((BOrd)param.getSource());
    }

    public CommandArtifact doInvoke() throws Exception {
        BAaPhpSendFileParam aaphpSendFileParam;
        this.aaphpDeviceManager.getController().learnMode.setSelected(true);
        BAaPhpDevice[] devices = this.aaphpDeviceManager.getSelectedDevices();
        if (devices != null && devices.length > 0 && this.validateSyntax(aaphpSendFileParam = (BAaPhpSendFileParam)BWbFieldEditor.dialog((BWidget)this.aaphpDeviceManager, (String)"sendFile", (BObject)this.aaphpDeviceManager.getAaPhpNetwork().getLastSendFileParam().newCopy()))) {
            BAaPhpSendFileJobParam param = new BAaPhpSendFileJobParam();
            param.setSendFileParam((BAaPhpSendFileParam)aaphpSendFileParam.newCopy());
            param.setFileBytes(this.readFileIfLocal(aaphpSendFileParam));
            BOrd sendFileJobOrd = devices[0].submitSendFileJob(param);
            this.aaphpDeviceManager.getLearn().setJob(sendFileJobOrd);
            this.aaphpDeviceManager.getController().doLearnMode(true);
        }
        return null;
    }
}

