/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.datatypes.BAaPhpGatherSetupInfoJobParam;
import com.tridium.aaphp.ui.BAaPhpDeviceManager;
import com.tridium.aaphp.util.AaPhpFileSupport;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.file.BNFileChooser;
import com.tridium.util.TimeFormat;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.xml.XParser;

public class AaPhpExamineSetupCommand
extends MgrController.MgrCommand {
    public static final String RESULTS_FILE_TIME_FORMAT = "YYYYMMDDHHmmss";
    final BAaPhpNetwork aaPhpNet;
    final BAaPhpDeviceManager aaphpDeviceManager;
    final String aaPhpStationHostName;
    public static final String MODULE_NAME = BAaPhpNetwork.TYPE.getModule().getModuleName();
    static final IFileFilter XML_FILE_FILTER = new IFileFilter(){

        public boolean accept(BIFile file) {
            if (file == null || file.getExtension() == null) {
                return false;
            }
            return file.getExtension().equalsIgnoreCase("xml");
        }

        public String getDescription(Context cx) {
            return "Xml Files (*.xml)";
        }
    };

    public AaPhpExamineSetupCommand(BAaPhpDeviceManager aaphpDeviceManager) {
        super((BWidget)aaphpDeviceManager, BAaPhpDevice.LEXICON, "examineSetup");
        this.aaphpDeviceManager = aaphpDeviceManager;
        this.aaPhpNet = aaphpDeviceManager.getAaPhpNetwork();
        this.aaPhpStationHostName = this.aaPhpNet.getHost().getNavName();
    }

    public CommandArtifact doInvoke() throws Exception {
        this.aaphpDeviceManager.getController().learnMode.setSelected(true);
        BOrd userTerminalCommandsFile = this.promptForTerminalCommandsFileOrd();
        if (userTerminalCommandsFile != null) {
            BBlob userTerminalCommandsFileBytes = this.getTerminalCommandsFileBytes(userTerminalCommandsFile);
            BOrd resultsFileOrd = this.promptForResultsFileOrd();
            if (resultsFileOrd != null) {
                BAaPhpGatherSetupInfoJobParam gatherSetupInfoParam = this.makeGatherChangesJobParam(userTerminalCommandsFile, userTerminalCommandsFileBytes, resultsFileOrd);
                this.aaphpDeviceManager.getLearn().setJob(this.aaphpDeviceManager.getSelectedDevices()[0].submitGatherSetupInfoJob(gatherSetupInfoParam));
                this.aaPhpNet.setLastTerminalCommandsFileOrd(userTerminalCommandsFile);
                BAaPhpDevice selectedDevice = this.aaphpDeviceManager.getSelectedDevices()[0];
                selectedDevice.setEarlierSetupInfoFileOrd(selectedDevice.getRecentSetupInfoFileOrd());
                selectedDevice.setRecentSetupInfoFileOrd(resultsFileOrd);
            }
        }
        return null;
    }

    private BOrd promptForResultsFileOrd() throws Exception {
        String deviceName = this.aaphpDeviceManager.getSelectedDevices()[0].getName();
        StringBuffer defaultFileNameBuffer = new StringBuffer();
        defaultFileNameBuffer.append(TextUtil.capitalize((String)MODULE_NAME));
        defaultFileNameBuffer.append(TextUtil.capitalize((String)this.aaPhpStationHostName));
        defaultFileNameBuffer.append(TextUtil.capitalize((String)deviceName));
        defaultFileNameBuffer.append("SetupInfo");
        defaultFileNameBuffer.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)RESULTS_FILE_TIME_FORMAT)).append(".txt");
        BNFileChooser saveDialog = (BNFileChooser)BNFileChooser.makeSave((BWidget)this.aaphpDeviceManager);
        saveDialog.setTitle(this.aaphpDeviceManager.getLexicon().getText("examineSetup.results.prompt"));
        saveDialog.setDefaultFileName(defaultFileNameBuffer.toString());
        saveDialog.setCurrentNavDirectory((BINavNode)BFileSystem.INSTANCE.getSysHome());
        BOrd userOrd = saveDialog.show();
        return userOrd;
    }

    public boolean ifIsOnClient(BOrd saveOrd) {
        try {
            ((BIFile)saveOrd.resolve().get()).getInputStream();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    String getFoxSession(BOrd clientSaveOrd) {
        BFoxSession session = (BFoxSession)BOrd.toSession((BObject)this.aaPhpNet);
        return session.getConnection().session().getRemoteId();
    }

    private BAaPhpGatherSetupInfoJobParam makeGatherChangesJobParam(BOrd userTerminalCommandsFile, BBlob userTerminalCommandsFileBytes, BOrd resultsFileOrd) {
        BAaPhpGatherSetupInfoJobParam gatherChangesParam = new BAaPhpGatherSetupInfoJobParam();
        if (userTerminalCommandsFileBytes == null) {
            gatherChangesParam.setTerminalCommandsfileBlob(BBlob.DEFAULT);
            gatherChangesParam.setTerminalCommandsFileOrd(userTerminalCommandsFile);
        } else {
            gatherChangesParam.setTerminalCommandsfileBlob(userTerminalCommandsFileBytes);
            gatherChangesParam.setTerminalCommandsFileOrd(BOrd.NULL);
        }
        gatherChangesParam.setResultsFileOrd(resultsFileOrd);
        if (this.ifIsOnClient(resultsFileOrd)) {
            gatherChangesParam.setResultsFileFoxId(this.getFoxSession(resultsFileOrd));
        }
        return gatherChangesParam;
    }

    private BBlob getTerminalCommandsFileBytes(BOrd userTerminalCommandsFile) throws Exception {
        BBlob userTerminalCommandsFileContents = AaPhpFileSupport.getFirmwareBlob((BOrd)userTerminalCommandsFile);
        if (userTerminalCommandsFileContents != null && userTerminalCommandsFileContents != BBlob.DEFAULT) {
            XParser validater = XParser.make((String)new String(userTerminalCommandsFileContents.copyBytes()));
            validater.parse();
            return userTerminalCommandsFileContents;
        }
        return null;
    }

    private BOrd promptForTerminalCommandsFileOrd() throws Exception {
        BOrd def = this.aaPhpNet.getLastTerminalCommandsFileOrd();
        BNFileChooser openDialog = (BNFileChooser)BNFileChooser.makeOpen((BWidget)this.aaphpDeviceManager);
        openDialog.setTitle(this.aaphpDeviceManager.getLexicon().getText("examineSetup.terminalCommands.prompt"));
        openDialog.setCurrentDirectory(def);
        openDialog.setCurrentFilter(XML_FILE_FILTER);
        return openDialog.show();
    }
}

