/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.aaphp.BAaPhpStarDevice;
import com.tridium.aaphp.datatypes.BAaPhpLearnStarPointsParam;
import com.tridium.aaphp.datatypes.BAaPhpStarAttribute;
import com.tridium.aaphp.job.BAaPhpLearnStarPointsJob;
import com.tridium.aaphp.ui.AaPhpTextFileCompare;
import com.tridium.aaphp.ui.BAaPhpPointManager;
import com.tridium.aaphp.ui.BAaPhpStarPointManager;
import com.tridium.aaphp.ui.BAaPhpVisualDiffDialog;
import com.tridium.aaphp.ui.BAaPhpVisualDiffPane;
import com.tridium.ui.file.BNFileChooser;
import com.tridium.util.TimeFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.io.ValueDocEncoder;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BFolder;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class AaPhpExaminePointDiscoveryCommand
extends MgrController.MgrCommand {
    final BAaPhpStarPointManager pointMgr;
    final BAaPhpStarDevice starDevice;
    final String starDeviceName;
    final String aaPhpStationHostName;
    public static final String MODULE_NAME = BAaPhpStarDevice.TYPE.getModule().getModuleName();
    static final String TITLE1 = BAaPhpStarPointManager.TYPE.getModule().getLexicon().getText("examinePointDiscovery.label");
    static final String QUESTION1 = BAaPhpStarPointManager.TYPE.getModule().getLexicon().getText("examinePointDiscovery.question1");
    static final String TITLE2 = BAaPhpStarPointManager.TYPE.getModule().getLexicon().getText("examinePointDiscovery.comparing");
    static final String TITLE3 = BAaPhpStarPointManager.TYPE.getModule().getLexicon().getText("examinePointDiscovery.compare.prompt");
    static final IFileFilter BOG_FILE_FILTER = new IFileFilter(){

        public boolean accept(BIFile file) {
            return file.getExtension().equalsIgnoreCase("bog");
        }

        public String getDescription(Context cx) {
            return "Bog Files (*.bog)";
        }
    };
    static final IFileFilter TXT_FILE_FILTER = new IFileFilter(){

        public boolean accept(BIFile file) {
            return file.getExtension().equalsIgnoreCase("txt");
        }

        public String getDescription(Context cx) {
            return "Text Files(*.txt)";
        }
    };

    public AaPhpExaminePointDiscoveryCommand(BAaPhpStarPointManager mgr) {
        super((BWidget)mgr, BAaPhpPointManager.TYPE.getModule().getLexicon(), "examinePointDiscovery");
        this.pointMgr = mgr;
        this.starDevice = mgr.getAaPhpStarDevice();
        this.starDeviceName = this.starDevice.getName();
        this.aaPhpStationHostName = this.starDevice.getHost().getNavName();
    }

    public CommandArtifact doInvoke() throws Exception {
        BJob learnJob = this.pointMgr.getLearn().getJob();
        if (learnJob != null && learnJob.getJobState() == BJobState.success && learnJob instanceof BAaPhpLearnStarPointsJob) {
            this.doInvoke((BAaPhpLearnStarPointsJob)learnJob);
        }
        return null;
    }

    private BOrd promptForSaveDisOrd() throws Exception {
        StringBuffer defaultFileNameBuffer = new StringBuffer();
        defaultFileNameBuffer.append(TextUtil.capitalize((String)MODULE_NAME));
        defaultFileNameBuffer.append(TextUtil.capitalize((String)this.aaPhpStationHostName));
        defaultFileNameBuffer.append(TextUtil.capitalize((String)this.starDeviceName));
        defaultFileNameBuffer.append("Dis");
        defaultFileNameBuffer.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYYYMMDDHHmmss")).append(".txt");
        BNFileChooser saveDialog = (BNFileChooser)BNFileChooser.makeSave((BWidget)this.pointMgr);
        saveDialog.setTitle(this.starDevice.getLexicon().getText("examinePointDiscovery.save.prompt"));
        saveDialog.setDefaultFileName(defaultFileNameBuffer.toString());
        saveDialog.setCurrentNavDirectory((BINavNode)BFileSystem.INSTANCE.getSysHome());
        saveDialog.setCurrentFilter(TXT_FILE_FILTER);
        BOrd userOrd = saveDialog.show();
        return userOrd;
    }

    private static void getSummary(String name, BComponent root, PrintWriter pw) {
        if (root instanceof BAaPhpStarAttribute) {
            pw.println(name + " " + root.toString(null));
        }
        BComponent[] childComponents = root.getChildComponents();
        for (int i = 0; i < childComponents.length; ++i) {
            AaPhpExaminePointDiscoveryCommand.getSummary(childComponents[i].getPropertyInParent().getName(), childComponents[i], pw);
        }
    }

    private static void reorderByName(BComponent root) {
        Object[] props = root.getDynamicPropertiesArray();
        if (props != null && props.length > 0) {
            int i;
            Object[] keys = new String[props.length];
            for (i = 0; i < keys.length; ++i) {
                keys[i] = props[i].getName();
            }
            SortUtil.sort((Object[])keys, (Object[])props, (boolean)true);
            root.reorder((Property[])props);
            for (i = 0; i < props.length; ++i) {
                BValue valueI = root.get((Property)props[i]);
                if (!(valueI instanceof BComponent)) continue;
                AaPhpExaminePointDiscoveryCommand.reorderByName((BComponent)valueI);
            }
        }
    }

    private static BComponent cloneDynamically(BAaPhpLearnStarPointsParam c) {
        BComponent output = new BComponent();
        Property[] props = c.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            output.add(props[i].getName(), c.get(props[i]).newCopy());
        }
        return output;
    }

    private void saveToTextFile(BAaPhpLearnStarPointsJob starDisJob, BOrd saveDisOrd) throws Exception {
        BFolder learnedPoints = (BFolder)starDisJob.getLearnedPoints().newCopy();
        AaPhpExaminePointDiscoveryCommand.reorderByName((BComponent)learnedPoints);
        BIFile saveDisFile = (BIFile)saveDisOrd.get();
        OutputStream saveDisOut = saveDisFile.getOutputStream();
        PrintWriter pw = new PrintWriter(saveDisOut);
        pw.println("Discovery List: " + starDisJob.getDiscoveryParameters().toString(null));
        pw.println("--------------------------------------------------------------------------------");
        AaPhpExaminePointDiscoveryCommand.getSummary(null, (BComponent)learnedPoints, pw);
        pw.flush();
        pw.close();
    }

    private void saveToBog(BAaPhpLearnStarPointsJob starDisJob, BOrd saveDisOrd) throws Exception {
        BFolder learnedPoints = (BFolder)starDisJob.getLearnedPoints().newCopy();
        AaPhpExaminePointDiscoveryCommand.reorderByName((BComponent)learnedPoints);
        BFolder saveMe = new BFolder();
        saveMe.add("Discovered", (BValue)learnedPoints);
        saveMe.add("Parameters", (BValue)AaPhpExaminePointDiscoveryCommand.cloneDynamically(starDisJob.getDiscoveryParameters()));
        ByteArrayOutputStream starDisBogInMemory = new ByteArrayOutputStream();
        ValueDocEncoder job2bog = new ValueDocEncoder((OutputStream)starDisBogInMemory);
        job2bog.setZipped(false);
        job2bog.setEncodeComments(false);
        job2bog.encodeDocument((BValue)saveMe);
        job2bog.flush();
        job2bog.close();
        XElem root = XParser.make((InputStream)new ByteArrayInputStream(starDisBogInMemory.toByteArray())).parse();
        AaPhpExaminePointDiscoveryCommand.removeHandles(root);
        BIFile saveDisFile = (BIFile)saveDisOrd.get();
        OutputStream saveDisOut = saveDisFile.getOutputStream();
        XWriter w = new XWriter(saveDisOut);
        root.write(w);
        w.flush();
        w.close();
        saveDisOut.flush();
        saveDisOut.close();
    }

    private static void removeHandles(XElem root) {
        root.removeAttr("h");
        XElem[] children = root.elems();
        for (int i = 0; i < children.length; ++i) {
            AaPhpExaminePointDiscoveryCommand.removeHandles(children[i]);
        }
    }

    private void doInvoke(BAaPhpLearnStarPointsJob starDisJob) throws Exception {
        BOrd saveDisOrd = this.promptForSaveDisOrd();
        if (saveDisOrd != null) {
            BOrd earlierDisOrd;
            this.saveToTextFile(starDisJob, saveDisOrd);
            if (BDialog.confirm((BWidget)this.pointMgr, (String)TITLE1, (Object)QUESTION1) == 4 && (earlierDisOrd = AaPhpTextFileCompare.promptForFile((BWidget)this.pointMgr, TITLE3, this.starDevice.getLastDiscoverySaveOrd(), TXT_FILE_FILTER)) != null) {
                this.showComparison(saveDisOrd, earlierDisOrd);
            }
            this.starDevice.setLastDiscoverySaveOrd(saveDisOrd);
        }
    }

    private void showComparison(BOrd saveDisOrd, BOrd earlierDisOrd) throws IOException {
        StringBuffer defSaveCompareFileName = new StringBuffer();
        defSaveCompareFileName.append(TextUtil.capitalize((String)MODULE_NAME));
        defSaveCompareFileName.append(TextUtil.capitalize((String)this.aaPhpStationHostName));
        defSaveCompareFileName.append(TextUtil.capitalize((String)this.starDeviceName));
        defSaveCompareFileName.append("DisComp");
        defSaveCompareFileName.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYYYMMDDHHmmss")).append(".txt");
        BAaPhpVisualDiffPane visualDiffPane = new BAaPhpVisualDiffPane();
        visualDiffPane.computeDiff((BIFile)earlierDisOrd.resolve().get(), (BIFile)saveDisOrd.resolve().get());
        BAaPhpVisualDiffDialog compareWindow = new BAaPhpVisualDiffDialog((BWidget)this.pointMgr, TITLE2, visualDiffPane, defSaveCompareFileName.toString());
        compareWindow.open();
        this.starDevice.setLastDiscoverySaveOrd(saveDisOrd);
    }
}

