/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.ui;

import com.tridium.exporttags.category.BCategoryFilter;
import com.tridium.exporttags.category.BCategoryFilterExt;
import com.tridium.exporttags.ui.JobTracker;
import com.tridium.workbench.category.Category;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public final class BCategoryFilterManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BCategoryFilterManager.class);
    private MgrColumn colName = new MgrColumn.Name();
    private MgrColumn colType = new MgrColumn.Type(2);
    private MgrColumn colPropertyFilters = new PropFiltersCol();
    private MgrColumn colCategoryMask = new CategoryMaskCol();
    private MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colPropertyFilters, this.colCategoryMask};
    private static final Lexicon lex = Lexicon.make(BCategoryFilterManager.class);

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    private class CategoryMaskCol
    extends MgrColumn.Prop {
        private CategoryMaskCol() {
            super(BCategoryFilter.categoryMask, 1);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BWbShell shell = BCategoryFilterManager.this.getWbShell();
            BCategoryMask mask = (BCategoryMask)value;
            if (mask.isWildcard()) {
                return mask.toString(cx);
            }
            Category.Result result = Category.load((BWbShell)shell, (int)(mask.size() + 1));
            StringBuilder buff = new StringBuilder();
            for (int i = 1; i < result.categories.length; ++i) {
                if (!mask.get(result.categories[i].index)) continue;
                if (buff.length() > 0) {
                    buff.append(" ,");
                }
                buff.append(result.categories[i].display);
            }
            return buff.toString();
        }
    }

    private static class PropFiltersCol
    extends MgrColumn.Prop {
        private PropFiltersCol() {
            super(BCategoryFilter.stationInfoPropertyFilters, 1);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            String s = super.toDisplayString(row, value, cx);
            if (s.length() > 50) {
                return s.substring(0, 49) + "...";
            }
            return s;
        }
    }

    private class TestCmd
    extends MgrController.MgrCommand {
        public TestCmd() {
            super((BWidget)BCategoryFilterManager.this, lex, "commands.testCategoryFilters");
        }

        public CommandArtifact doInvoke() throws Exception {
            BComponent[] comps = BCategoryFilterManager.this.getController().getSelectedComponents();
            BOrd[] ords = new BOrd[comps.length];
            for (int i = 0; i < comps.length; ++i) {
                ords[i] = comps[i].getHandleOrd();
            }
            BCategoryFilterExt ext = (BCategoryFilterExt)BCategoryFilterManager.this.getCurrentValue();
            JobTracker.open((BWidget)BCategoryFilterManager.this, (BComponent)ext, ext.submitCategoryFilterTest(BOrdList.make((BOrd[])ords)));
            return null;
        }
    }

    private class Controller
    extends MgrController {
        private TestCmd testCmd;

        public Controller(BCategoryFilterManager manager) {
            super((BAbstractManager)manager);
            this.testCmd = new TestCmd();
            this.testCmd.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return Controller.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.testCmd});
        }

        protected MgrController.IMgrCommand[] makeTagCommands() {
            return new MgrController.IMgrCommand[0];
        }

        public void updateCommands() {
            this.testCmd.setEnabled(BCategoryFilterManager.this.getController().getSelectedComponents().length > 0);
            super.updateCommands();
        }
    }

    private class Model
    extends MgrModel {
        public Model(BCategoryFilterManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return BCategoryFilterManager.this.cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BCategoryFilter.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BCategoryFilter.TYPE);
        }
    }
}

