/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.tool;

import com.tridium.lonworks.CancelOperationException;
import com.tridium.lonworks.resource.Conversion;
import com.tridium.lonworks.resource.CrossReference;
import com.tridium.lonworks.resource.ResourceFile;
import com.tridium.lonworks.resource.ResourceFileUtil;
import com.tridium.lonworks.resource.TypeFile;
import com.tridium.lonworks.ui.tool.BLonXmlCreate;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.util.XLonUtil;
import com.tridium.lonworks.util.xif.XifToXDevice;
import com.tridium.lonworks.xml.LonXMLWriter;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class LonXmlCreate {
    static OutputStream nullStream = new OutputStream(){

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int n) {
        }
    };
    static PrintStream nullOut = new PrintStream(nullStream);
    static String[] unitStrings = null;
    static String[] symbolStrings = null;
    static Hashtable<String, String> convStringMap = new Hashtable();
    static final UiLexicon lex = UiLexicon.makeUiLexicon(BLonXmlCreate.class);
    BDirectory workDir;
    BDataFile xifFile;
    BDirectory resDir;
    boolean useZero;
    PrintStream out;
    BWidget parent;

    public static void createLnml(BDirectory w, BDataFile x, BDirectory r, PrintStream o, BWidget p, boolean u) {
        LonXmlCreate lxc = new LonXmlCreate(w, x, r, o, p, u);
        lxc.create();
    }

    private LonXmlCreate(BDirectory w, BDataFile x, BDirectory r, PrintStream o, BWidget p, boolean u) {
        this.workDir = w;
        this.xifFile = x;
        this.resDir = r;
        this.out = o;
        this.parent = p;
        this.useZero = u;
    }

    private void create() {
        try {
            String devName = this.xifFile.getFileName();
            devName = NameUtil.toJavaName((String)devName.substring(0, devName.lastIndexOf(".")), (boolean)true);
            this.out.println("Parse xif file : " + this.xifFile.getFileName());
            XLonDevice xdev = XifToXDevice.convert((BIFile)this.xifFile, (PrintStream)nullOut, null);
            byte[] programId = xdev.deviceData.programID;
            this.out.println("Program id : " + LonByteArrayUtil.toString((byte[])programId) + "\n");
            CrossReference cr = null;
            if (this.resDir != null) {
                this.out.println("Create cross reference ");
                cr = new CrossReference(this.out);
                cr.setUnitPrompt((Conversion.UnitPrompt)new UnitDialog(cr));
                this.findDataFiles(programId, cr);
                xdev = XifToXDevice.convert((BIFile)this.xifFile, (PrintStream)this.out, (CrossReference)cr);
                this.out.println();
            }
            xdev.setName(devName);
            xdev.useZeroBasedArrays = this.useZero;
            XLonInterfaceFile xmlInterface = new XLonInterfaceFile();
            xmlInterface.setName(xdev.getName());
            xmlInterface.addAttribute("", (Object)xdev);
            if (cr != null) {
                this.processDataFile(xmlInterface, cr);
            }
            BIFile file = this.workDir.getFileSpace().makeFile(this.workDir.getFilePath().merge(new FilePath(devName + ".lnml")));
            this.out.println("create device file : " + file.getFilePath().getBody());
            OutputStream os = null;
            try {
                os = file.getOutputStream();
                LonXMLWriter writer = new LonXMLWriter(os, false);
                writer.encode((Object)xmlInterface);
                os.close();
            }
            catch (IOException ioe) {
                if (os != null) {
                    os.close();
                }
                throw ioe;
            }
        }
        catch (Throwable e) {
            this.out.println(e);
            e.printStackTrace();
        }
    }

    private void findDataFiles(byte[] programId, CrossReference cr) {
        BIFile[] files = this.resDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int lenToComp;
            String ext = files[i].getExtension();
            if (ext == null || !ext.equalsIgnoreCase("typ")) continue;
            TypeFile tFile = null;
            try {
                tFile = (TypeFile)ResourceFileUtil.getResourceFile((BIFile)files[i]);
            }
            catch (Throwable e) {
                this.out.println(e);
            }
            if (tFile == null || !this.compareArray(tFile.refId, programId, lenToComp = this.getLengthToComp(tFile.scope))) continue;
            String fName = files[i].getFileName();
            this.out.println("Add resouceFile " + fName);
            try {
                cr.addResource(this.resDir, fName, tFile);
                continue;
            }
            catch (CrossReference.DuplicateResourceException dre) {
                throw new BajaRuntimeException((Throwable)dre);
            }
        }
    }

    private void processDataFile(XLonInterfaceFile xmlDev, CrossReference cr) {
        try {
            BDirectory dataDir = this.workDir.getFileSpace().makeDir(this.workDir.getFilePath().merge(new FilePath("datatypes")));
            TypeFile[] a = cr.getTypeFiles(true);
            for (int i = 0; i < a.length; ++i) {
                TypeFile tf = a[i];
                String name = NameUtil.getFileNameFromPath((String)tf.fileName, (boolean)true);
                name = NameUtil.toJavaName((String)name, (boolean)true);
                XLonInterfaceFile xmlInterface = XLonUtil.resourceToXLonFile((ResourceFile)tf, (CrossReference)cr, (PrintStream)this.out);
                xmlInterface.setName(name);
                BIFile file = dataDir.getFileSpace().makeFile(dataDir.getFilePath().merge(new FilePath(name + ".lnml")));
                this.out.println("create data file : " + file.getFilePath().getBody());
                OutputStream os = file.getOutputStream();
                LonXMLWriter writer = new LonXMLWriter(os, false);
                writer.encode((Object)xmlInterface);
                os.close();
                xmlInterface.setFile("datatypes/" + name + ".lnml");
                xmlDev.addAttribute(name, (Object)xmlInterface);
                cr.flush();
                cr.clearMarks();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private boolean compareArray(byte[] a1, byte[] a2, int lenToComp) {
        if (lenToComp == 0) {
            return true;
        }
        if (a1[0] != 15) {
            if ((a1[0] & 0xF) != (a2[0] & 0xF)) {
                return false;
            }
            int a = a1[0] >> 4 & 0xF;
            int b = a2[0] >> 4 & 0xF;
            if (a != 8 && a != 9 || b != 8 && b != 9) {
                return false;
            }
        }
        for (int i = 1; i < lenToComp; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private int getLengthToComp(int scope) {
        switch (scope) {
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 8;
            }
        }
        throw new RuntimeException("Invalid scope " + scope);
    }

    void addUnitStrings(BList list) {
        if (unitStrings == null) {
            Array a = new Array(String.class);
            Array s = new Array(String.class);
            UnitDatabase.Quantity[] qa = UnitDatabase.getDefault().getQuantities();
            for (int i = 0; i < qa.length; ++i) {
                BUnit[] ua = qa[i].getUnits();
                for (int n = 0; n < ua.length; ++n) {
                    a.add((Object)ua[n].getUnitName());
                    s.add((Object)ua[n].getSymbol());
                }
            }
            unitStrings = (String[])a.trim();
            symbolStrings = (String[])s.trim();
            SortUtil.sort((Object[])unitStrings, (Object[])symbolStrings);
        }
        for (int i = 0; i < unitStrings.length; ++i) {
            list.addItem((Object)unitStrings[i]);
        }
    }

    int bestQuess(String s) {
        int i;
        if (unitStrings.length != symbolStrings.length) {
            return 0;
        }
        String ls = s.toLowerCase();
        if (ls.endsWith("s")) {
            ls = ls.substring(0, ls.length() - 1);
            for (i = 0; i < unitStrings.length; ++i) {
                if (!ls.equals(unitStrings[i])) continue;
                return i;
            }
        }
        for (i = 0; i < symbolStrings.length; ++i) {
            if (!ls.equalsIgnoreCase(symbolStrings[i])) continue;
            return i;
        }
        StringTokenizer st = new StringTokenizer(ls, " -_");
        String seg = st.nextToken();
        int bestMatch = Integer.MAX_VALUE;
        int bestNdx = -1;
        for (int i2 = 0; i2 < unitStrings.length; ++i2) {
            int n = unitStrings[i2].indexOf(seg);
            if (n < 0 || n >= bestMatch) continue;
            bestMatch = n;
            bestNdx = i2;
        }
        return bestNdx;
    }

    class UnitDialog
    extends Conversion.UnitPrompt {
        CrossReference cr;

        UnitDialog(CrossReference c) {
            this.cr = c;
        }

        public String getUserString(int scope, int index, String orginal) {
            BListDropDown euSel = new BListDropDown();
            BList list = euSel.getList();
            list.removeAllItems();
            list.addItem((Object)"");
            LonXmlCreate.this.addUnitStrings(list);
            if (convStringMap.containsKey(orginal)) {
                String last = convStringMap.get(orginal);
                list.setSelectedIndex(list.indexOfItem((Object)last));
            } else {
                list.setSelectedIndex(LonXmlCreate.this.bestQuess(orginal) + 1);
            }
            String filename = "unknown";
            try {
                filename = this.cr.getLanguageFile((int)scope).fileName;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            BGridPane a = new BGridPane(2);
            a.add(null, (BValue)new BLabel(lex.getText("lonXmlEngUnit.file")));
            a.add(null, (BValue)new BTextField(filename, 40, false));
            a.add(null, (BValue)new BLabel(lex.getText("lonXmlEngUnit.scopeIndex")));
            a.add(null, (BValue)new BTextField(Integer.toString(scope) + "/" + index, 40, false));
            a.add(null, (BValue)new BLabel(lex.getText("lonXmlEngUnit.original")));
            a.add(null, (BValue)new BTextField(orginal, 40, false));
            a.add(null, (BValue)new BLabel(lex.getText("lonXmlEngUnit.newText")));
            a.add(null, (BValue)euSel);
            BBorderPane content = new BBorderPane((BWidget)a);
            int resp = BDialog.open((BWidget)LonXmlCreate.this.parent, (String)lex.getText("lonXmlEngUnit.title"), (Object)content, (int)3, null, (String)lex.getText("lonXmlEngUnit.explain"));
            String newText = "???";
            if (resp == 1) {
                newText = (String)list.getSelectedItem();
            }
            if (resp == 2) {
                throw new CancelOperationException();
            }
            LonXmlCreate.this.out.println("Convert eu \"" + orginal + "\" to \"" + newText + "\"");
            convStringMap.put(orginal, newText);
            return newText;
        }
    }
}

