/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.tool;

import com.tridium.lonworks.ui.tool.BLonXmlOptions;
import com.tridium.lonworks.ui.tool.LonXmlCreate;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BLonXmlCreate
extends BWbView {
    public static final Type TYPE = Sys.loadType(BLonXmlCreate.class);
    static BImage openIcon = BImage.make((String)"module://icons/x16/open.png");
    static BImage compileIcon = BImage.make((String)"module://icons/x16/compile.png");
    static final UiLexicon lex = UiLexicon.makeUiLexicon(BLonXmlCreate.class);
    PrintStream out;
    BTextField workDirTf;
    BTextField xifFileTf;
    BTextField resDirTf;
    BCheckBox useZeroCb;
    BTextEditor textArea;
    BLonXmlOptions opts = BLonXmlOptions.make();

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) throws Exception {
        this.workDirTf = new BTextField(this.validFile(this.opts.getWorkDirTf()), 60);
        this.workDirTf.setEditable(false);
        BButton workDirBtn = new BButton((Command)new BrowseWorkDir((BWidget)this.getShell(), this.workDirTf));
        workDirBtn.setButtonStyle(BButtonStyle.toolBar);
        this.xifFileTf = new BTextField(this.validFile(this.opts.getXifFileTf()), 60);
        this.xifFileTf.setEditable(false);
        BButton xifBtn = new BButton((Command)new BrowseXifFile((BWidget)this.getShell(), this.xifFileTf));
        xifBtn.setButtonStyle(BButtonStyle.toolBar);
        this.resDirTf = new BTextField(this.validFile(this.opts.getResDirTf()), 60);
        this.resDirTf.setEditable(false);
        BButton resDirBtn = new BButton((Command)new BrowseResDir((BWidget)this.getShell(), this.resDirTf));
        resDirBtn.setButtonStyle(BButtonStyle.toolBar);
        BGridPane a = new BGridPane(3);
        a.add(null, (BValue)new BLabel(lex.getText("lonXmlCreate.workingDir")));
        a.add(null, (BValue)this.workDirTf);
        a.add(null, (BValue)workDirBtn);
        a.add(null, (BValue)new BLabel(lex.getText("lonXmlCreate.xifFile")));
        a.add(null, (BValue)this.xifFileTf);
        a.add(null, (BValue)xifBtn);
        a.add(null, (BValue)new BLabel(lex.getText("lonXmlCreate.resDir")));
        a.add(null, (BValue)this.resDirTf);
        a.add(null, (BValue)resDirBtn);
        this.useZeroCb = new BCheckBox((ToggleCommand)new UseZero((BWidget)this.getShell()));
        this.useZeroCb.setSelected(this.opts.getUseZeroBased());
        this.useZeroCb.setText(lex.getText("lonXmlCreate.zeroBased"));
        BGridPane b = new BGridPane(1);
        b.add(null, (BValue)a);
        b.add(null, (BValue)new BBorderPane((BWidget)this.useZeroCb, BInsets.make((double)5.0)));
        BButton comp = new BButton((Command)new Compile((BWidget)this.getShell()), true, true);
        BGridPane c = new BGridPane(1);
        c.setColumnAlign(BHalign.fill);
        c.add(null, (BValue)comp);
        BEdgePane top = new BEdgePane();
        top.setTop((BWidget)b);
        top.setBottom((BWidget)new BBorderPane((BWidget)c, BInsets.make((double)10.0)));
        this.textArea = new BTextEditor();
        this.textArea.setEditable(false);
        BScrollPane scr = new BScrollPane((BWidget)this.textArea);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)top);
        pane.setCenter((BWidget)scr);
        this.setContent((BWidget)new BBorderPane((BWidget)pane));
    }

    private String validFile(String filename) {
        boolean valid = false;
        String fname = filename;
        while (!valid) {
            try {
                BOrd.make((String)("file:" + fname)).resolve().get();
                valid = true;
            }
            catch (Throwable e) {
                if (fname.lastIndexOf("/") < 0) {
                    return "";
                }
                fname = fname.substring(0, fname.lastIndexOf("/"));
            }
        }
        return fname;
    }

    void clearText() {
        this.textArea.setText("");
    }

    void message(String s) {
        this.textArea.setText(this.textArea.getText() + "\n" + s);
    }

    class CreateStream
    extends OutputStream {
        ByteArrayOutputStream out = new ByteArrayOutputStream();

        CreateStream() {
        }

        @Override
        public void write(byte[] a) {
            this.write(a, 0, a.length);
        }

        @Override
        public void write(byte[] a, int offset, int len) {
            this.out.write(a, offset, len);
            BLonXmlCreate.this.textArea.setText(this.out.toString());
        }

        @Override
        public void write(int n) {
            this.out.write(n);
            BLonXmlCreate.this.textArea.setText(this.out.toString());
        }
    }

    class UseZero
    extends ToggleCommand {
        UseZero(BWidget owner) {
            super(owner, "");
        }

        public CommandArtifact doInvoke() {
            BLonXmlCreate.this.opts.setUseZeroBased(BLonXmlCreate.this.useZeroCb.isSelected());
            BLonXmlCreate.this.opts.save();
            return null;
        }
    }

    class Compile
    extends Command {
        Compile(BWidget owner) {
            super(owner, (Lexicon)lex, "lonXmlCreate.compile");
        }

        public CommandArtifact doInvoke() {
            BLonXmlCreate.this.out = new PrintStream(new CreateStream());
            try {
                BLonXmlCreate.this.clearText();
                String workDirName = BLonXmlCreate.this.workDirTf.getText();
                if (workDirName.length() <= 0) {
                    BLonXmlCreate.this.message("Must specify working directory.");
                    return null;
                }
                BOrd wrkDirOrd = BOrd.make((String)("file:" + workDirName));
                BDirectory workDir = (BDirectory)wrkDirOrd.resolve().get();
                String xifFileName = BLonXmlCreate.this.xifFileTf.getText();
                if (xifFileName.length() <= 0) {
                    BLonXmlCreate.this.message("Must specify xif file.");
                    return null;
                }
                BOrd xifOrd = BOrd.make((String)("file:" + xifFileName));
                BDataFile xifDataFile = (BDataFile)xifOrd.resolve().get();
                String resFileName = BLonXmlCreate.this.resDirTf.getText();
                BOrd resOrd = resFileName.length() > 0 ? BOrd.make((String)("file:" + resFileName)) : null;
                BDirectory resFile = resOrd != null ? (BDirectory)resOrd.resolve().get() : null;
                LonXmlCreate.createLnml(workDir, xifDataFile, resFile, BLonXmlCreate.this.out, this.getOwner(), BLonXmlCreate.this.useZeroCb.isSelected());
            }
            catch (Exception e) {
                BLonXmlCreate.this.out.println("Can not compile.\n" + e);
            }
            return null;
        }
    }

    class BrowseResDir
    extends Browse {
        BrowseResDir(BWidget owner, BTextField t) {
            super(owner, t);
        }

        @Override
        BOrd getOrd() {
            BDirectoryChooser c = BDirectoryChooser.make((BWidget)this.getShell());
            if (this.txt.getText().length() > 0) {
                c.setCurrentDirectory(BOrd.make((String)("file:" + this.txt.getText())));
            }
            return c.show();
        }

        @Override
        void saveOpt() {
            BLonXmlCreate.this.opts.setResDirTf(this.txt.getText());
            BLonXmlCreate.this.opts.save();
        }
    }

    class BrowseXifFile
    extends Browse {
        BrowseXifFile(BWidget owner, BTextField t) {
            super(owner, t);
        }

        @Override
        BOrd getOrd() {
            BFileChooser c = BFileChooser.makeOpen((BWidget)this.getShell());
            String t = this.txt.getText();
            if (t.indexOf(".") > 0) {
                t = t.substring(0, t.lastIndexOf("/"));
            }
            if (t.length() > 0) {
                c.setCurrentDirectory(BOrd.make((String)("file:" + t)));
            }
            return c.show();
        }

        @Override
        void saveOpt() {
            BLonXmlCreate.this.opts.setXifFileTf(this.txt.getText());
            BLonXmlCreate.this.opts.save();
        }
    }

    class BrowseWorkDir
    extends Browse {
        BrowseWorkDir(BWidget owner, BTextField t) {
            super(owner, t);
        }

        @Override
        BOrd getOrd() {
            BDirectoryChooser c = BDirectoryChooser.make((BWidget)this.getShell());
            if (this.txt.getText().length() > 0) {
                c.setCurrentDirectory(BOrd.make((String)("file:" + this.txt.getText())));
            }
            return c.show();
        }

        @Override
        void saveOpt() {
            BLonXmlCreate.this.opts.setWorkDirTf(this.txt.getText());
            BLonXmlCreate.this.opts.save();
        }
    }

    abstract class Browse
    extends Command {
        BTextField txt;

        Browse(BWidget owner, BTextField t) {
            super(owner, "");
            this.txt = t;
        }

        public String getText() {
            return null;
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BOrd file = null;
            try {
                file = this.getOrd();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (file != null) {
                OrdQuery[] q = file.parse();
                this.txt.setText(q[q.length - 1].getBody());
                this.txt.repaint();
            } else {
                this.txt.setText("");
            }
            this.saveOpt();
            return null;
        }

        abstract BOrd getOrd();

        abstract void saveOpt();
    }
}

