/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.router;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BRouterEntry;
import com.tridium.lonworks.datatypes.BRouterEntryTable;
import com.tridium.lonworks.datatypes.BServicePinData;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.ui.router.BLonRtrMgrTable;
import com.tridium.lonworks.ui.router.RouterController;
import com.tridium.lonworks.ui.router.RouterLearn;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BInsets;
import javax.baja.lonworks.BLonDeviceFolder;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.view.BWbComponentView;

public class BLonRouterManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BLonRouterManager.class);
    boolean initialized = false;
    private boolean useNetAddress = true;
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BLonRouterManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colStatus = new StatusColumn();
    MgrColumn colRouterType = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.rtrType"), new Property[]{BLonRouter.routerType}, 1);
    MgrColumn colRouterMode = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.rtrMode"), new Property[]{BLonRouter.routerMode}, 1);
    MgrColumn colState = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.state"), new Property[]{BLonRouter.nearDeviceData, BDeviceData.nodeState}, 5);
    MgrColumn colNearChannel = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.nearChannelId"), new Property[]{BLonRouter.nearDeviceData, BDeviceData.channelId}, 1);
    MgrColumn colNearSubnetNode = new SubNetNodeColumn(lexicon.getText("router.columnTitle.nearAdr"), new Property[]{BLonRouter.nearDeviceData, BDeviceData.subnetNodeId}, 1);
    MgrColumn colFarChannel = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.farChannelId"), new Property[]{BLonRouter.farDeviceData, BDeviceData.channelId}, 1);
    MgrColumn colFarSubnetNode = new SubNetNodeColumn(lexicon.getText("router.columnTitle.farAdr"), new Property[]{BLonRouter.farDeviceData, BDeviceData.subnetNodeId}, 1);
    MgrColumn colFaultCause = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.faultCause"), new Property[]{BLonRouter.faultCause}, 4);
    MgrColumn colNeuronId = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.neuronId"), new Property[]{BLonRouter.nearDeviceData, BDeviceData.neuronId}, 5);
    MgrColumn colFarNeuronId = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.farNeuronId"), new Property[]{BLonRouter.farDeviceData, BDeviceData.neuronId}, 7);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colStatus, this.colRouterType, this.colRouterMode, this.colState, this.colNearChannel, this.colNearSubnetNode, this.colFarChannel, this.colFarSubnetNode, this.colFaultCause, this.colNeuronId, this.colFarNeuronId};
    BJobBar jobBar;
    private BLonNetwork lon;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new LonRouterModel(this);
    }

    protected MgrLearn makeLearn() {
        return new RouterLearn(this);
    }

    protected MgrController makeController() {
        return new RouterController(this);
    }

    public BLonNetwork getNetwork() {
        if (this.lon == null) {
            Thread.dumpStack();
        }
        return this.lon;
    }

    public void doLoadValue(BObject value, Context cx) {
        this.lon = (BLonNetwork)((BIDeviceFolder)value).getNetwork();
        try {
            super.doLoadValue(value, cx);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.initialized) {
            this.initialized = true;
            this.jobBar = new BJobBar();
            this.attach((BWbComponentView.Attachable)this.jobBar);
            BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
            jobPane.setFill(Theme.widget().getWindowBackground());
            jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
            ((BEdgePane)this.getContent()).setTop((BWidget)jobPane);
        }
        this.registerFolder((BComponent)value);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
        this.registerForComponentEvents((BComponent)this.lon.netmgmt(), 1);
        this.updateDiscoveryRows(this.lon.netmgmt().getRouterDiscoverTable());
    }

    void registerRouter(BLonRouter rtr) {
        this.registerForComponentEvents((BComponent)rtr, 0);
        this.registerForComponentEvents((BComponent)rtr.getNearDeviceData(), 0);
        this.registerForComponentEvents((BComponent)rtr.getFarDeviceData(), 0);
    }

    void reloadValue() {
        BComponent target = this.getCurrentValue().asComponent();
        this.registerFolder(target);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
        this.updateDiscoveryRows(this.lon.netmgmt().getRouterDiscoverTable());
        this.repaint();
    }

    void loadDescendants() {
        BComponent target = this.getCurrentValue().asComponent();
        BLonDeviceFolder[] fa = this.getFolders(target);
        for (int i = 0; i < fa.length; ++i) {
            this.registerFolder((BComponent)fa[i]);
        }
    }

    private void registerFolder(BComponent c) {
        this.registerForComponentEvents(c, 1);
        BLonRouter[] rtrs = (BLonRouter[])c.getChildren(BLonRouter.class);
        BComponent[] a = new BComponent[rtrs.length * 2];
        int n = 0;
        for (int i = 0; i < rtrs.length; ++i) {
            a[n++] = rtrs[i].getNearDeviceData();
            a[n++] = rtrs[i].getFarDeviceData();
        }
        this.registerForComponentEvents(a, 0);
    }

    private BLonDeviceFolder[] getFolders(BComponent c) {
        Array a = new Array(BLonDeviceFolder.class);
        this.scanForFolders(c, (Array<BLonDeviceFolder>)a);
        return (BLonDeviceFolder[])a.trim();
    }

    private void scanForFolders(BComponent con, Array<BLonDeviceFolder> a) {
        SlotCursor c = con.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!p.getType().is(BLonDeviceFolder.TYPE)) continue;
            BComponent df = (BComponent)c.get();
            this.registerForComponentEvents(df, 0);
            a.add((Object)((BLonDeviceFolder)df));
            this.scanForFolders(df, a);
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        int id = event.getId();
        BComponent srcCmp = event.getSourceComponent();
        switch (id) {
            case 5: {
                if (srcCmp == this.getNetwork()) {
                    if (event.getSlot() != BLonNetwork.deviceChange) break;
                    this.repaint();
                    break;
                }
                if (srcCmp != this.getNetwork().netmgmt()) break;
                if (event.getSlot() == BLonNetmgmt.learnComplete) {
                    this.reloadValue();
                    break;
                }
                if (event.getSlot() == BLonNetmgmt.routerDiscoveryUpdated) {
                    this.updateDiscoveryRows((BRouterEntryTable)event.getValue());
                    break;
                }
                if (event.getSlot() != BLonNetmgmt.servicePinReceived) break;
                BNeuronId nid = ((BServicePinData)event.getValue()).getNeuronId();
                BMgrTable tab = this.getModel().getTable();
                int cnt = tab.getComponentModel().getRowCount();
                for (int i = 0; i < cnt; ++i) {
                    BComponent c = tab.getComponentAt(i);
                    if (!c.getType().is(BLonRouter.TYPE) || !((BLonRouter)c).getNeuronIdAddress().equals((Object)nid)) continue;
                    tab.getSelection().select(i, true);
                    break;
                }
                BRouterEntry[] le = (BRouterEntry[])this.getLearn().getRoots();
                for (int i = 0; i < le.length; ++i) {
                    if (!le[i].getNeuronId().equals((Object)nid)) continue;
                    this.getLearn().getTable().getSelection().select(i, true);
                }
                break;
            }
            case 0: {
                if (!srcCmp.getType().is(BLonRouter.TYPE) && !srcCmp.getType().is(BDeviceData.TYPE)) break;
                this.repaint();
            }
        }
        super.handleComponentEvent(event);
    }

    void updateDiscoveryRows(BRouterEntryTable entryTable) {
        Object[] discoveryRows = entryTable.getRouterEntries();
        this.getLearn().updateRoots(discoveryRows);
    }

    public BSubnetNode validate(MgrEditRow row, BSubnetNode sn) {
        BOrd ord = this.lon.getLonNetmgmt().deviceForSubnetNodeId(sn);
        BLonRouter rtr = (BLonRouter)row.getTarget();
        if (ord != null && !ord.equals((Object)rtr.getHandleOrd())) {
            if (rtr.isMounted()) {
                throw new BajaRuntimeException("Address " + sn + " already in use.");
            }
            return BSubnetNode.DEFAULT;
        }
        return sn;
    }

    public boolean isUseNetAddress() {
        return this.useNetAddress;
    }

    public void setUseNetAddress(boolean b) {
        this.useNetAddress = b;
    }

    static class SubNetNodeColumn
    extends MgrColumn.PropPath {
        Property prop;

        public SubNetNodeColumn(String name, Property[] props, int flags) {
            super(name, props, flags);
            this.prop = props[0];
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BLonRouterManager mgr = (BLonRouterManager)row.getManager();
            BSubnetNode sn = mgr.validate(row, (BSubnetNode)value);
            BDeviceData dd = (BDeviceData)((BLonRouter)row.getTarget()).get(this.prop);
            dd.setSubnetNodeId(sn);
        }
    }

    static class StatusColumn
    extends MgrColumn {
        public StatusColumn() {
            super(lexicon.getText("device.columnTitle.status"), 2);
        }

        public Object get(Object tgt) {
            return ((BLonRouter)tgt).getStatus().flagsToString(null);
        }
    }

    class LonRouterModel
    extends DeviceModel {
        LonRouterModel(BLonRouterManager manager) {
            super((BDeviceManager)manager);
        }

        public MgrTypeInfo[] getNewTypes() {
            TypeInfo[] types = new TypeInfo[]{BLonRouter.TYPE.getTypeInfo()};
            return MgrTypeInfo.makeArray((TypeInfo[])types);
        }

        protected MgrColumn[] makeColumns() {
            return BLonRouterManager.this.cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BLonRouter.TYPE, BLonDeviceFolder.TYPE};
        }

        protected BMgrTable makeTable() {
            return new BLonRtrMgrTable((MgrModel)this);
        }
    }
}

