/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.point;

import com.tridium.lonworks.ui.point.BLonCreationEntry;
import com.tridium.lonworks.ui.point.BLonPointManager;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.BLonObjectFolder;
import javax.baja.lonworks.londata.BLonBigInteger;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonDouble;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonLong;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.BLonSimple;
import javax.baja.lonworks.londata.BLonString;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class PointLearn
extends MgrLearn {
    BLonDevice dev;
    static Lexicon lex = BLonPointManager.lexicon;
    static BImage FloatElementIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
    static BImage BooleanElementIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
    static BImage EnumElementIcon = BImage.make((String)"module://icons/x16/statusEnum.png");
    static BImage StringElementIcon = BImage.make((String)"module://icons/x16/statusString.png");
    static BImage LonObjectIcon = BImage.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/object.png");
    static BImage LonObjectFolderIcon = BImage.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/objectFolder.png");

    public PointLearn(BAbstractManager manager) {
        super(manager);
    }

    public void load(BComponent target) {
        super.load(target);
        BComplex p = target.getParent();
        while (!p.getType().is(BLonDevice.TYPE)) {
            p = p.getParent();
        }
        this.dev = (BLonDevice)p;
        this.dev.getComponentSpace().update((BComponent)this.dev, Integer.MAX_VALUE);
        this.updateDiscoveryRows();
    }

    void updateDiscoveryRows() {
        ArrayList<BLonCreationEntry> list = new ArrayList<BLonCreationEntry>();
        this.doUpdateDiscoveryRows(list, (BComponent)this.dev, "");
        BLonCreationEntry[] rows = list.toArray(new BLonCreationEntry[list.size()]);
        this.updateRoots((Object[])rows);
    }

    private void doUpdateDiscoveryRows(ArrayList<BLonCreationEntry> list, BComponent tgtCntr, String objName) {
        SlotCursor c = tgtCntr.getProperties();
        while (c.nextObject()) {
            BLonCreationEntry objEntry;
            ArrayList<BLonCreationEntry> al;
            if (c.property().getType().is(BLonComponent.TYPE)) {
                BLonCreationEntry e;
                BLonComponent lc = (BLonComponent)c.get();
                BLonData ldat = lc.getData();
                String target = lc.getDisplayName(null);
                if (lc != ldat) {
                    target = target + "/" + ldat.getDisplayName(null);
                }
                if ((e = this.addElementRows(tgtCntr, ldat, target, objName)) == null) {
                    System.out.println("e==null");
                    continue;
                }
                list.add(e);
                continue;
            }
            if (c.property().getType().is(BLonObject.TYPE)) {
                BLonObject lo = (BLonObject)c.get();
                al = new ArrayList<BLonCreationEntry>();
                this.doUpdateDiscoveryRows(al, (BComponent)lo, lo.getDisplayName(null));
                objEntry = new BLonCreationEntry((BComponent)lo);
                objEntry.children = al.toArray(new BLonCreationEntry[al.size()]);
                list.add(objEntry);
                continue;
            }
            if (!c.property().getType().is(BLonObjectFolder.TYPE)) continue;
            BLonObjectFolder lof = (BLonObjectFolder)c.get();
            al = new ArrayList();
            this.doUpdateDiscoveryRows(al, (BComponent)lof, lof.getDisplayName(null));
            objEntry = new BLonCreationEntry((BComponent)lof);
            objEntry.children = al.toArray(new BLonCreationEntry[al.size()]);
            list.add(objEntry);
        }
    }

    private BLonCreationEntry addElementRows(BComponent tgtCntr, BLonData ldat, String prefix, String objName) {
        BLonCreationEntry firstEntry = null;
        ArrayList<BLonCreationEntry> list = null;
        SlotCursor c = ldat.getProperties();
        while (c.nextObject()) {
            Property p = c.property();
            BLonCreationEntry entry = null;
            if (p.getType().is(BLonPrimitive.TYPE)) {
                BFacets f = p.getFacets();
                BUnit devUnit = (BUnit)f.get("units");
                String unit = devUnit == null ? "" : devUnit.getSymbol();
                entry = new BLonCreationEntry(ldat, p.getName(), unit);
            } else if (p.getType().is(BLonData.TYPE)) {
                String pre = prefix + "/" + p.getDefaultDisplayName(null);
                entry = this.addElementRows(tgtCntr, (BLonData)c.get(), pre, objName);
            }
            if (entry == null) continue;
            if (firstEntry == null) {
                firstEntry = entry;
                continue;
            }
            if (list == null) {
                list = new ArrayList<BLonCreationEntry>();
            }
            list.add(entry);
        }
        if (list != null) {
            BLonCreationEntry[] rows = list.toArray(new BLonCreationEntry[list.size()]);
            firstEntry.children = rows;
        }
        return firstEntry;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(lex.getText("learn.columnTitle.targetName"), BLonCreationEntry.targetName, 1), new MgrColumn.Prop(lex.getText("learn.columnTitle.elementName"), BLonCreationEntry.elementName, 1), new MgrColumn.Prop(lex.getText("learn.columnTitle.units"), BLonCreationEntry.units, 1)};
    }

    public boolean isDepthExpandable(int depth) {
        return true;
    }

    public boolean hasChildren(Object discovery) {
        return ((BLonCreationEntry)((Object)discovery)).hasChildren();
    }

    public Object[] getChildren(Object discovery) {
        BLonCreationEntry[] a = ((BLonCreationEntry)((Object)discovery)).getChildren();
        if (a == null) {
            return new Object[0];
        }
        return a;
    }

    public BImage getIcon(Object discovery) {
        Type type = ((BLonCreationEntry)((Object)discovery)).getTarget().getType();
        if (type.is(BLonObject.TYPE)) {
            return LonObjectIcon;
        }
        if (type.is(BLonObjectFolder.TYPE)) {
            return LonObjectFolderIcon;
        }
        if (type == BLonFloat.TYPE || type == BLonInteger.TYPE || type == BLonDouble.TYPE || type == BLonLong.TYPE || type == BLonBigInteger.TYPE) {
            return FloatElementIcon;
        }
        if (type == BLonBoolean.TYPE) {
            return BooleanElementIcon;
        }
        if (type == BLonEnum.TYPE) {
            return EnumElementIcon;
        }
        if (type == BLonString.TYPE || type == BLonByteArray.TYPE || type == BLonSimple.TYPE) {
            return StringElementIcon;
        }
        return null;
    }

    public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
        BLonCreationEntry creatEntry = (BLonCreationEntry)((Object)discovery);
        ArrayList list = new ArrayList();
        boolean writable = creatEntry.getLonComponent().isWriteable();
        Type type = creatEntry.getTarget().getType();
        if (type == BLonFloat.TYPE || type == BLonInteger.TYPE || type == BLonDouble.TYPE || type == BLonLong.TYPE || type == BLonBigInteger.TYPE) {
            PointModel.addNumericPointTypes(list, (boolean)writable);
            PointModel.addBooleanPointTypes(list, (boolean)writable);
            PointModel.addStringPointTypes(list, (boolean)writable);
            PointModel.addEnumPointTypes(list, (boolean)writable);
        } else if (type == BLonBoolean.TYPE) {
            PointModel.addBooleanPointTypes(list, (boolean)writable);
            PointModel.addNumericPointTypes(list, (boolean)writable);
            PointModel.addStringPointTypes(list, (boolean)writable);
        } else if (type == BLonEnum.TYPE) {
            PointModel.addEnumPointTypes(list, (boolean)writable);
            PointModel.addStringPointTypes(list, (boolean)writable);
            PointModel.addNumericPointTypes(list, (boolean)writable);
            PointModel.addBooleanPointTypes(list, (boolean)writable);
        } else {
            PointModel.addStringPointTypes(list, (boolean)writable);
        }
        return list.toArray(new MgrTypeInfo[list.size()]);
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        BLonCreationEntry creatEntry = (BLonCreationEntry)((Object)discovery);
        BLonPointManager pm = (BLonPointManager)row.getManager();
        row.setDefaultName(creatEntry.getDefaultProxyName());
        row.setCell(pm.colTarget, (BValue)BString.make((String)creatEntry.getTargetPathName()));
        row.setCell(pm.colElement, (BValue)BString.make((String)creatEntry.getElementName()));
        row.setCell(pm.colFacets, (BValue)creatEntry.getFacets());
    }

    public boolean isExisting(Object discovery, BComponent component) {
        if (!(component instanceof BControlPoint)) {
            return false;
        }
        BLonCreationEntry creatEntry = (BLonCreationEntry)((Object)discovery);
        BControlPoint cp = (BControlPoint)component;
        BLonProxyExt ext = (BLonProxyExt)cp.getProxyExt();
        String targetName = ext.getTargetComp();
        return targetName.equals(creatEntry.getTargetName()) && ext.getTargetName().equals(creatEntry.getElementName());
    }
}

