/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.point;

import java.util.HashMap;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.BLonObjectFolder;
import javax.baja.lonworks.londata.BLonBigInteger;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonDouble;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonLong;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BLonCreationEntry
extends BStruct {
    public static final Property targetName = BLonCreationEntry.newProperty((int)0, (String)"", null);
    public static final Property elementName = BLonCreationEntry.newProperty((int)0, (String)"", null);
    public static final Property pointType = BLonCreationEntry.newProperty((int)0, (int)0, null);
    public static final Property units = BLonCreationEntry.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BLonCreationEntry.class);
    private static final int FLOAT_DATA = 0;
    private static final int BOOLEAN_DATA = 1;
    private static final int ENUM_DATA = 2;
    private static final int STRING_DATA = 3;
    BLonCreationEntry[] children = null;
    BOrd tgtOrd;
    BComponent target;
    Property targetProp;

    public String getTargetName() {
        return this.getString(targetName);
    }

    public void setTargetName(String v) {
        this.setString(targetName, v, null);
    }

    public String getElementName() {
        return this.getString(elementName);
    }

    public void setElementName(String v) {
        this.setString(elementName, v, null);
    }

    public int getPointType() {
        return this.getInt(pointType);
    }

    public void setPointType(int v) {
        this.setInt(pointType, v, null);
    }

    public String getUnits() {
        return this.getString(units);
    }

    public void setUnits(String v) {
        this.setString(units, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLonCreationEntry() {
    }

    public BLonCreationEntry(BComponent lo) {
        this.target = lo;
        this.setTargetName(lo.getName());
    }

    public BLonCreationEntry(BLonData ldat, String elementName, String units) {
        this.target = ldat;
        this.targetProp = ldat.getProperty(elementName);
        String targetName = this.getPathToParentType(this.target, BLonComponent.TYPE, true, "/");
        this.setTargetName(SlotPath.unescape((String)targetName));
        this.setElementName(SlotPath.unescape((String)elementName));
        this.setUnits(units);
    }

    private String getPathToParentType(BComponent tgt, Type baseTyp, boolean noDataInPath, String delimiter) {
        BComponent c = tgt;
        String path = "";
        boolean end = false;
        while (!end && !c.getType().is(BLonDevice.TYPE)) {
            if (!(noDataInPath && c.getName().equals("data") && c.getParent().getType().is(BLonComponent.TYPE))) {
                path = path.length() == 0 ? c.getName() : c.getName() + delimiter + path;
            }
            if (c.getType().is(baseTyp)) {
                end = true;
                continue;
            }
            c = (BComponent)c.getParent();
        }
        return path;
    }

    public BObject getTarget() {
        if (this.target.getType().is(BLonObject.TYPE)) {
            return this.target;
        }
        if (this.target.getType().is(BLonObjectFolder.TYPE)) {
            return this.target;
        }
        return this.target.get(this.getElementName());
    }

    public BLonComponent getLonComponent() {
        BComponent p = this.target;
        while (!(p instanceof BLonComponent)) {
            p = (BComponent)p.getParent();
        }
        return (BLonComponent)p;
    }

    String getDefaultProxyName() {
        String n = this.getPathToParentType(this.target, BLonDevice.TYPE, true, "_");
        BComponent lonData = this.target;
        int cnt = 0;
        lonData = this.target;
        Property[] a = lonData.getPropertiesArray();
        for (int i = 0; i < a.length; ++i) {
            if (!BLonData.isDataProp((Property)a[i])) continue;
            ++cnt;
        }
        if (cnt > 1) {
            n = n + "_" + this.getElementName();
        }
        return n;
    }

    String getTargetPathName() {
        return this.getPathToParentType(this.target, BLonDevice.TYPE, false, "/");
    }

    public BFacets getFacets() {
        Type type = this.getTarget().getType();
        if (type == BLonFloat.TYPE || type == BLonInteger.TYPE || type == BLonDouble.TYPE || type == BLonLong.TYPE || type == BLonBigInteger.TYPE) {
            return this.getFloatFacets();
        }
        if (type == BLonEnum.TYPE) {
            return this.getEnumFacets();
        }
        return BFacets.NULL;
    }

    private BFacets getFloatFacets() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BFacets f = this.targetProp.getFacets();
        BObject s = f.getFacet("units");
        if (s != null) {
            map.put("units", (BUnit)s);
        }
        map.put("precision", (s = f.getFacet("precision")) != null ? (BInteger)s : BInteger.make((int)2));
        s = f.getFacet("min");
        map.put("min", s != null ? (BNumber)s : BFloat.NEGATIVE_INFINITY);
        s = f.getFacet("max");
        map.put("max", s != null ? (BNumber)s : BFloat.POSITIVE_INFINITY);
        return BFacets.make(map);
    }

    private BFacets getEnumFacets() {
        BLonPrimitive p = (BLonPrimitive)this.target.get(this.targetProp);
        if (p.getType() == BLonEnum.TYPE) {
            BEnum e = ((BLonEnum)p).getEnum();
            return BFacets.makeEnum((BEnumRange)e.getRange());
        }
        return BFacets.makeEnum((BEnumRange)BEnumRange.DEFAULT);
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public BLonCreationEntry[] getChildren() {
        return this.children;
    }
}

