/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.lonlink;

import com.tridium.lonworks.datatypes.BLinkEntry;
import com.tridium.lonworks.datatypes.BLinkEntryTable;
import com.tridium.lonworks.datatypes.BSetServiceTypeParameter;
import com.tridium.lonworks.datatypes.BTagLinkEntry;
import com.tridium.lonworks.datatypes.BTagLinkEntryTable;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.ui.lonlink.LinkTableModel;
import com.tridium.lonworks.ui.lonlink.TagLinkTableModel;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import java.util.ArrayList;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

public class BLonLinkManager
extends BWbComponentView {
    public static final Action tabChanged = BLonLinkManager.newAction((int)0, null);
    public static final Action filterChanged = BLonLinkManager.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BLonLinkManager.class);
    private BLonNetmgmt netMgmt;
    private BLinkEntry[] entries = null;
    private BTabbedPane tabbedPane = new BTabbedPane();
    private BJobBar jobBar;
    private BTable nvTable = new BTable();
    private BTable mtTable = new BTable();
    private LinkTableModel nvTableModel;
    private TagLinkTableModel mtTableModel;
    private BButton bindBtn;
    private BButton selBindBtn;
    private BButton svcTypeBtn;
    private BCheckBox proxyLinkFilter;
    private BCheckBox netLinkFilter;
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BLonLinkManager.class);

    public void tabChanged() {
        this.invoke(tabChanged, null, null);
    }

    public void filterChanged() {
        this.invoke(filterChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLonLinkManager() {
        this.nvTable.setController((TableController)new Controller());
        this.mtTable.setController((TableController)new MtagController());
        this.autoRegisterForComponentEvents = false;
    }

    public void doLoadValue(BObject value, Context context) {
        this.netMgmt = ((BLonNetwork)value).getLonNetmgmt();
        this.linkTo((BComponent)this.tabbedPane, (Slot)BTabbedPane.selectionModified, (Slot)tabChanged);
        this.registerForComponentEvents((BComponent)this.netMgmt);
        Command refreshCommand = new Command((BWidget)this.getWbShell(), BLonLinkManager.lexicon.module, "lonlink.refresh"){

            public CommandArtifact doInvoke() {
                BLonLinkManager.this.refresh();
                return null;
            }
        };
        BButton refreshBtn = new BButton(refreshCommand, true, true);
        Command bindCommand = new Command((BWidget)this.getWbShell(), BLonLinkManager.lexicon.module, "lonlink.bind"){

            public CommandArtifact doInvoke() {
                BLonLinkManager.this.bind();
                return null;
            }
        };
        this.bindBtn = new BButton(bindCommand, true, true);
        this.bindBtn.setEnabled(this.netMgmt.getEnabled());
        Command selBindCommand = new Command((BWidget)this.getWbShell(), BLonLinkManager.lexicon.module, "lonlink.selectiveBind"){

            public CommandArtifact doInvoke() {
                BLonLinkManager.this.selectiveBind();
                return null;
            }
        };
        this.selBindBtn = new BButton(selBindCommand, true, true);
        this.selBindBtn.setEnabled(false);
        Command setSvcTypeCommand = new Command((BWidget)this.getWbShell(), BLonLinkManager.lexicon.module, "lonlink.setServiceType"){

            public CommandArtifact doInvoke() {
                BLonLinkManager.this.setServiceType();
                return null;
            }
        };
        this.svcTypeBtn = new BButton(setSvcTypeCommand, true, true);
        this.svcTypeBtn.setEnabled(false);
        this.nvTableModel = new LinkTableModel();
        this.nvTable.setModel((TableModel)this.nvTableModel);
        this.nvTable.setMultipleSelection(true);
        this.mtTableModel = new TagLinkTableModel();
        this.mtTable.setModel((TableModel)this.mtTableModel);
        this.mtTable.setMultipleSelection(true);
        BFlowPane buttonPane = new BFlowPane(BHalign.center);
        buttonPane.add("refresh", (BValue)refreshBtn);
        buttonPane.add("bind", (BValue)this.bindBtn);
        buttonPane.add("selectiveBind", (BValue)this.selBindBtn);
        buttonPane.add("setServiceType", (BValue)this.svcTypeBtn);
        this.proxyLinkFilter = new BCheckBox(new ToggleCommand((BWidget)this.getWbShell(), BLonLinkManager.lexicon.module, "lonlink.proxyLinkFilter"));
        this.netLinkFilter = new BCheckBox(new ToggleCommand((BWidget)this.getWbShell(), BLonLinkManager.lexicon.module, "lonlink.netLinkFilter"));
        BGridPane filterPane = new BGridPane(1);
        filterPane.add("proxyLink", (BValue)this.proxyLinkFilter);
        filterPane.add("netLink", (BValue)this.netLinkFilter);
        this.linkTo((BComponent)this.proxyLinkFilter, (Slot)BCheckBox.actionPerformed, (Slot)filterChanged);
        this.linkTo((BComponent)this.netLinkFilter, (Slot)BCheckBox.actionPerformed, (Slot)filterChanged);
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        BEdgePane bottomPane = new BEdgePane();
        bottomPane.setLeft((BWidget)new BBorderPane((BWidget)filterPane));
        bottomPane.setCenter((BWidget)new BBorderPane((BWidget)buttonPane));
        this.tabbedPane.addPane("NetworkVariableLinks", (BWidget)this.nvTable);
        this.tabbedPane.addPane("MessageTagLinks", (BWidget)this.mtTable);
        BEdgePane mainPane = new BEdgePane();
        mainPane.setTop((BWidget)jobPane);
        mainPane.setCenter((BWidget)this.tabbedPane);
        mainPane.setBottom((BWidget)bottomPane);
        this.setContent((BWidget)mainPane);
        this.netMgmt.refreshLinkTable();
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (event.getId() == 5 && event.getSourceComponent() == this.netMgmt) {
            if (event.getSlot() == BLonNetmgmt.linksUpdated) {
                this.updateLinks((BLinkEntryTable)event.getValue());
            } else if (event.getSlot() == BLonNetmgmt.tagLinksUpdated) {
                this.updateTagLinks((BTagLinkEntryTable)event.getValue());
            }
        } else {
            super.handleComponentEvent(event);
        }
    }

    public void updateLinks(BLinkEntryTable table) {
        this.entries = table.getLinkEntries();
        this.doUpdateLinks();
    }

    private synchronized void doUpdateLinks() {
        this.nvTableModel.removeAllRows();
        boolean proxy = !this.proxyLinkFilter.getSelected();
        boolean net = !this.netLinkFilter.getSelected();
        for (int i = 0; i < this.entries.length; ++i) {
            BLinkEntry e = this.entries[i];
            boolean isProxy = e.isProxy();
            if ((!proxy || !isProxy) && (!net || isProxy)) continue;
            this.nvTableModel.addRow(e);
        }
    }

    public void updateTagLinks(BTagLinkEntryTable table) {
        BTagLinkEntry[] entries = table.getLinkEntries();
        this.mtTableModel.removeAllRows();
        for (int i = 0; i < entries.length; ++i) {
            this.mtTableModel.addRow(entries[i]);
        }
    }

    public void doTabChanged() {
        boolean nvSelected = this.tabbedPane.getSelectedPane().equals((Object)this.nvTable);
        if (!nvSelected) {
            this.bindBtn.setEnabled(this.netMgmt.getEnabled());
            this.selBindBtn.setEnabled(false);
            this.svcTypeBtn.setEnabled(false);
        }
        this.proxyLinkFilter.setVisible(nvSelected);
        this.netLinkFilter.setVisible(nvSelected);
    }

    public void doFilterChanged() {
        if (this.entries != null) {
            this.doUpdateLinks();
        }
    }

    private void selectiveBind() {
        if (this.tabbedPane.getSelectedPane().equals((Object)this.nvTable)) {
            TableSelection sel = this.nvTable.getSelection();
            BString str = BString.make((String)this.getSelectors(sel.getRows()));
            this.setJob(this.netMgmt.bindLinkEntry(str));
        } else {
            TableSelection sel = this.mtTable.getSelection();
            int[] rows = sel.getRows();
            BTagLinkEntry lastEntry = null;
            for (int i = 0; i < rows.length; ++i) {
                BTagLinkEntry entry = ((TagLinkTableModel)this.mtTable.getModel()).getEntry(rows[i]);
                if (lastEntry != null && entry.sameOutput(lastEntry)) continue;
                this.setJob(this.netMgmt.bindTagLinkEntry(entry));
                lastEntry = entry;
            }
        }
    }

    private void bind() {
        this.setJob(this.netMgmt.bindLinkEntry(BString.DEFAULT));
    }

    private void setServiceType() {
        TableSelection sel = this.nvTable.getSelection();
        if (sel.getRows().length < 1) {
            return;
        }
        BGridPane p = new BGridPane(2);
        p.add("label", (BValue)new BLabel(lexicon.getText("lonlink.serviceTypeText")));
        BListDropDown linkType = new BListDropDown();
        BList list = linkType.getList();
        list.addItem((Object)BLonLinkType.standard);
        list.addItem((Object)BLonLinkType.reliable);
        list.addItem((Object)BLonLinkType.critical);
        list.addItem((Object)BLonLinkType.authenticated);
        list.addItem((Object)BLonLinkType.pollOnly);
        linkType.setSelectedIndex(0);
        p.add("comboBox", (BValue)linkType);
        BCheckBox priority = new BCheckBox(lexicon.getText("lonlink.priority"));
        p.add("priority", (BValue)priority);
        p.add(null, (BValue)new BWidget());
        int retVal = BDialog.open((BWidget)this, (String)lexicon.getText("lonlink.serviceTypeText"), (Object)p, (int)3);
        if (retVal == 2) {
            return;
        }
        int index = list.getSelectedIndex();
        BLonLinkType lnkType = BLonLinkType.make((int)(index + 1));
        if (lnkType == BLonLinkType.critical && this.checkCritical(sel.getRows())) {
            BDialog.error((BWidget)this, (Object)"Exceeded maximum targets in critical connection type.");
            return;
        }
        BSetServiceTypeParameter param = new BSetServiceTypeParameter();
        param.setSelector(this.getSelectors(sel.getRows()));
        param.setLinkType(lnkType);
        param.setPriority(priority.getSelected());
        this.setJob(this.netMgmt.setServiceType(param));
    }

    private String getSelectors(int[] rows) {
        StringBuffer selectors = new StringBuffer();
        int lastSel = -1;
        for (int i = 0; i < rows.length; ++i) {
            int sel = this.nvTableModel.getEntry(rows[i]).getSelector();
            if (i == 0) {
                selectors.append(sel);
                lastSel = sel;
                continue;
            }
            if (lastSel == sel) continue;
            selectors.append(',').append(sel);
            lastSel = sel;
        }
        return selectors.toString();
    }

    private boolean checkCritical(int[] rows) {
        int currSel = -1;
        int selCnt = 0;
        for (int i = 0; i < rows.length; ++i) {
            BLinkEntry e = this.nvTableModel.getEntry(rows[i]);
            if (e.isProxy()) continue;
            int sel = e.getSelector();
            if (sel != currSel) {
                selCnt = 0;
                currSel = sel;
                continue;
            }
            if (++selCnt <= 5) continue;
            return true;
        }
        return false;
    }

    private void refresh() {
        this.netMgmt.refreshLinkTable();
    }

    private void setJob(BOrd jobOrd) {
        try {
            BComponent base = (BComponent)this.getCurrentValue();
            base.getComponentSpace().sync();
            BJob job = (BJob)jobOrd.get((BObject)base);
            this.registerForComponentEvents((BComponent)job);
            this.jobBar.load(job);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    class MtagController
    extends TableController {
        MtagController() {
        }

        public void focusGained(BFocusEvent event) {
            BTable table = this.getTable();
            TableSelection sel = table.getSelection();
            boolean btnsEnabled = sel.getRows().length > 0;
            BLonLinkManager.this.bindBtn.setEnabled(!btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            BLonLinkManager.this.selBindBtn.setEnabled(btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            this.getTable().repaint();
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            boolean deselect;
            super.cellReleased(event, row, column);
            TableSelection sel = this.getTable().getSelection();
            int[] rows = sel.getRows();
            boolean btnsEnabled = sel.getRows().length > 0;
            BLonLinkManager.this.bindBtn.setEnabled(!btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            BLonLinkManager.this.selBindBtn.setEnabled(btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            if (!btnsEnabled) {
                return;
            }
            ArrayList<Integer> selectedRows = new ArrayList<Integer>();
            for (int i = 0; i < rows.length; ++i) {
                selectedRows.add(new Integer(rows[i]));
            }
            TableModel tm = this.getTable().getModel();
            boolean bl = deselect = !sel.isSelected(row);
            if (deselect) {
                this.deselect((String)tm.getValueAt(row, 1), (String)tm.getValueAt(row, 2), selectedRows);
            }
            rows = this.getSelectArray(selectedRows);
            for (int i = 0; i < rows.length; ++i) {
                this.select((String)tm.getValueAt(row, 1), (String)tm.getValueAt(row, 2), selectedRows);
            }
            sel.deselectAll();
            sel.select(this.getSelectArray(selectedRows));
        }

        protected void backgroundReleased(BMouseEvent event) {
            super.backgroundReleased(event);
            BLonLinkManager.this.bindBtn.setEnabled(BLonLinkManager.this.netMgmt.getEnabled());
            BLonLinkManager.this.selBindBtn.setEnabled(false);
            BLonLinkManager.this.svcTypeBtn.setEnabled(false);
        }

        private void select(String outputDevice, String outputTag, ArrayList<Integer> selectedRows) {
            TableModel tm = this.getTable().getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                Integer i;
                String sd = (String)tm.getValueAt(r, 1);
                String st = (String)tm.getValueAt(r, 2);
                if (!sd.equals(outputDevice) || !st.equals(outputTag) || selectedRows.indexOf(i = new Integer(r)) >= 0) continue;
                selectedRows.add(i);
            }
        }

        private void deselect(String outputDevice, String outputTag, ArrayList<Integer> selectedRows) {
            TableModel tm = this.getTable().getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                String sd = (String)tm.getValueAt(r, 1);
                String st = (String)tm.getValueAt(r, 2);
                if (!sd.equals(outputDevice) || !st.equals(outputTag)) continue;
                selectedRows.remove(new Integer(r));
            }
        }

        private int[] getSelectArray(ArrayList<Integer> selectedRows) {
            int[] newSelRows = new int[selectedRows.size()];
            for (int i = 0; i < selectedRows.size(); ++i) {
                newSelRows[i] = selectedRows.get(i);
            }
            return newSelRows;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void focusGained(BFocusEvent event) {
            BTable table = this.getTable();
            TableSelection sel = table.getSelection();
            boolean btnsEnabled = sel.getRows().length > 0;
            BLonLinkManager.this.bindBtn.setEnabled(!btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            BLonLinkManager.this.selBindBtn.setEnabled(btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            BLonLinkManager.this.svcTypeBtn.setEnabled(btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            this.getTable().repaint();
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            boolean deselect;
            super.cellReleased(event, row, column);
            TableSelection sel = this.getTable().getSelection();
            int[] rows = sel.getRows();
            boolean btnsEnabled = sel.getRows().length > 0;
            BLonLinkManager.this.bindBtn.setEnabled(!btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            BLonLinkManager.this.selBindBtn.setEnabled(btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            BLonLinkManager.this.svcTypeBtn.setEnabled(btnsEnabled && BLonLinkManager.this.netMgmt.getEnabled());
            if (!btnsEnabled) {
                return;
            }
            ArrayList<Integer> selectedRows = new ArrayList<Integer>();
            for (int i = 0; i < rows.length; ++i) {
                selectedRows.add(new Integer(rows[i]));
            }
            TableModel tm = this.getTable().getModel();
            boolean bl = deselect = !sel.isSelected(row);
            if (deselect) {
                this.deselectSel((Integer)tm.getValueAt(row, 0), selectedRows);
                this.deselectHub((String)tm.getValueAt(row, 2), (String)tm.getValueAt(row, 3), selectedRows);
            }
            rows = this.getSelectArray(selectedRows);
            for (int i = 0; i < rows.length; ++i) {
                this.selectSel((Integer)tm.getValueAt(rows[i], 0), selectedRows);
                this.selectHub((String)tm.getValueAt(rows[i], 2), (String)tm.getValueAt(rows[i], 3), selectedRows);
            }
            sel.deselectAll();
            sel.select(this.getSelectArray(selectedRows));
        }

        protected void backgroundReleased(BMouseEvent event) {
            super.backgroundReleased(event);
            BLonLinkManager.this.bindBtn.setEnabled(BLonLinkManager.this.netMgmt.getEnabled());
            BLonLinkManager.this.selBindBtn.setEnabled(false);
            BLonLinkManager.this.svcTypeBtn.setEnabled(false);
        }

        private void selectSel(Integer selector, ArrayList<Integer> selectedRows) {
            TableModel tm = this.getTable().getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                Integer i;
                Integer sr = (Integer)tm.getValueAt(r, 0);
                if (!sr.equals(selector) || selectedRows.indexOf(i = new Integer(r)) >= 0) continue;
                selectedRows.add(i);
                this.selectHub((String)tm.getValueAt(r, 2), (String)tm.getValueAt(r, 3), selectedRows);
            }
        }

        private void selectHub(String hubDevice, String hubNv, ArrayList<Integer> selectedRows) {
            if (hubDevice.equals("LocalDev")) {
                return;
            }
            TableModel tm = this.getTable().getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                Integer i;
                String hd = (String)tm.getValueAt(r, 2);
                String hv = (String)tm.getValueAt(r, 3);
                if (!hd.equals(hubDevice) || !hv.equals(hubNv) || selectedRows.indexOf(i = new Integer(r)) >= 0) continue;
                selectedRows.add(i);
                this.selectSel((Integer)tm.getValueAt(r, 0), selectedRows);
            }
        }

        private void deselectSel(Integer selector, ArrayList<Integer> selectedRows) {
            TableModel tm = this.getTable().getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                Integer sr = (Integer)tm.getValueAt(r, 0);
                if (!sr.equals(selector) || !selectedRows.remove(new Integer(r))) continue;
                this.deselectHub((String)tm.getValueAt(r, 2), (String)tm.getValueAt(r, 3), selectedRows);
            }
        }

        private void deselectHub(String hubDevice, String hubNv, ArrayList<Integer> selectedRows) {
            TableModel tm = this.getTable().getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                String hd = (String)tm.getValueAt(r, 2);
                String hv = (String)tm.getValueAt(r, 3);
                if (!hd.equals(hubDevice) || !hv.equals(hubNv) || !selectedRows.remove(new Integer(r))) continue;
                this.deselectSel((Integer)tm.getValueAt(r, 0), selectedRows);
            }
        }

        private int[] getSelectArray(ArrayList<Integer> selectedRows) {
            int[] newSelRows = new int[selectedRows.size()];
            for (int i = 0; i < selectedRows.size(); ++i) {
                newSelRows[i] = selectedRows.get(i);
            }
            return newSelRows;
        }
    }
}

