/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.device;

import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.ui.device.BLonDeviceManager;
import com.tridium.lonworks.util.DeviceDef;
import javax.baja.gx.BImage;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class DeviceLearn
extends MgrLearn {
    static Lexicon lex = BLonDeviceManager.lexicon;
    static BImage deviceIcon = BImage.make((BIcon)BIcon.std((String)"device.png"));

    DeviceLearn(BLonDeviceManager mgr) {
        super((BAbstractManager)mgr);
    }

    protected final BWidget makeJobBar() {
        return null;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(lex.getText("device.columnTitle.state"), BDeviceEntry.state, 0), new MgrColumn.Prop(lex.getText("device.columnTitle.channelId"), BDeviceEntry.channelId, 3), new MgrColumn.Prop(lex.getText("device.columnTitle.subnet"), BDeviceEntry.subnet, 1), new MgrColumn.Prop(lex.getText("device.columnTitle.node"), BDeviceEntry.node, 1), new MfgIdColumn(), new MgrColumn.Prop(lex.getText("device.columnTitle.programId"), BDeviceEntry.programId, 0), new MgrColumn.Prop(lex.getText("device.columnTitle.neuronId"), BDeviceEntry.neuronId, 0)};
    }

    public boolean isMatchable(Object dis, BComponent db) {
        BLonDevice dev = (BLonDevice)db;
        if (dev.isLocal()) {
            return false;
        }
        BProgramId disPid = ((BDeviceEntry)dis).getProgramId();
        BProgramId dbPid = dev.getDeviceData().getProgramId();
        return this.programIdsMatch(disPid, dbPid);
    }

    private boolean programIdsMatch(BProgramId p1, BProgramId p2) {
        if (p1.isZero() || p2.isZero() || p1.equals((Object)p2)) {
            return true;
        }
        DeviceDef dd = new DeviceDef(p1);
        return dd.wildCardMatch(p2);
    }

    public BImage getIcon(Object dis) {
        return deviceIcon;
    }

    public MgrTypeInfo[] toTypes(Object dis) {
        BProgramId pId = ((BDeviceEntry)dis).getProgramId();
        return ((BLonDeviceManager.LonDeviceModel)this.getManager().getModel()).getNewTypes(pId);
    }

    public void toRow(Object dis, MgrEditRow row) throws Exception {
        int chanId;
        int nodeId;
        int subnetId;
        BDeviceEntry devEntry = (BDeviceEntry)dis;
        BDeviceData dbDevDat = ((BLonDevice)row.getTarget()).getDeviceData();
        BLonDeviceManager dm = (BLonDeviceManager)row.getManager();
        if (dm.isUseNetAddress()) {
            subnetId = devEntry.getSubnet();
            nodeId = devEntry.getNode();
            chanId = devEntry.getChannelId();
            row.setCell(dm.colState, (BValue)devEntry.getState());
        } else {
            BSubnetNode sn = dbDevDat.getSubnetNodeId();
            subnetId = sn.getSubnetId();
            nodeId = sn.getNodeId();
            chanId = dbDevDat.getChannelId();
            row.setCell(dm.colState, (BValue)dbDevDat.getNodeState());
        }
        row.setDefaultName(row.getType().getDisplayName());
        row.setCell(dm.colChannelId, (BValue)BInteger.make((int)chanId));
        row.setCell(dm.colSubnet, (BValue)BInteger.make((int)subnetId));
        row.setCell(dm.colNode, (BValue)BInteger.make((int)nodeId));
        row.setCell(dm.colProgramId, (BValue)devEntry.getProgramId());
        row.setCell(dm.colNeuronId, (BValue)devEntry.getNeuronId());
        row.setCell(dm.colWorkDomain, (BValue)BInteger.make((int)devEntry.getWorkingDomain()));
    }

    static class MfgIdColumn
    extends MgrColumn {
        public MfgIdColumn() {
            super(lex.getText("device.columnTitle.mfgId"), 0);
        }

        public Object get(Object tgt) {
            return ((BDeviceEntry)tgt).getMfgId().getConvertedName();
        }
    }
}

