/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.device;

import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BDeviceEntryTable;
import com.tridium.lonworks.datatypes.BServicePinData;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.ui.device.BLonDevMgrTable;
import com.tridium.lonworks.ui.device.DeviceLearn;
import com.tridium.lonworks.ui.device.LonDeviceController;
import com.tridium.lonworks.util.DeviceDef;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonDeviceFolder;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.view.BWbComponentView;

public class BLonDeviceManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BLonDeviceManager.class);
    boolean initialized = false;
    private boolean useNetAddress = true;
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BLonDeviceManager.class);
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colStatus = new StatusColumn();
    MgrColumn colType = new MgrColumn.Type(1);
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BLonDevice());
    MgrColumn colState = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.state"), new Property[]{BLonDevice.deviceData, BDeviceData.nodeState}, 5);
    MgrColumn colChannelId = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.channelId"), new Property[]{BLonDevice.deviceData, BDeviceData.channelId}, 3);
    MgrColumn colSubnet = new SubnetColumn();
    MgrColumn colNode = new NodeColumn();
    MgrColumn colMfgId = new MfgIdColumn();
    MgrColumn colWorkDomain = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.workDomain"), new Property[]{BLonDevice.deviceData, BDeviceData.workingDomain}, 7);
    MgrColumn colProgramId = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.programId"), new Property[]{BLonDevice.deviceData, BDeviceData.programId}, 5);
    MgrColumn colNeuronId = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.neuronId"), new Property[]{BLonDevice.deviceData, BDeviceData.neuronId}, 5);
    MgrColumn colEnabled = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.enabled"), new Property[]{BLonDevice.enabled}, 5);
    MgrColumn colFaultCause = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.faultCause"), new Property[]{BLonDevice.faultCause}, 4);
    MgrColumn colXmlFile = new XmlColumn();
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colStatus, this.colType, this.colDeviceExts, this.colState, this.colChannelId, this.colSubnet, this.colNode, this.colWorkDomain, this.colFaultCause, this.colMfgId, this.colProgramId, this.colNeuronId, this.colEnabled, this.colXmlFile};
    private BLonNetwork lon;
    private BJobBar jobBar;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new LonDeviceModel(this);
    }

    protected MgrLearn makeLearn() {
        return new DeviceLearn(this);
    }

    protected MgrController makeController() {
        return new LonDeviceController(this);
    }

    public void doLoadValue(BObject value, Context cx) {
        this.lon = (BLonNetwork)((BIDeviceFolder)value).getNetwork();
        try {
            super.doLoadValue(value, cx);
        }
        catch (Throwable e) {
            System.out.println(e);
        }
        if (!this.initialized) {
            this.initialized = true;
            this.jobBar = new BJobBar();
            this.attach((BWbComponentView.Attachable)this.jobBar);
            BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
            jobPane.setFill(Theme.widget().getWindowBackground());
            jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
            ((BEdgePane)this.getContent()).setTop((BWidget)jobPane);
        }
        this.registerFolder((BComponent)value);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
        this.registerForComponentEvents((BComponent)this.lon.netmgmt(), 1);
        this.updateDiscoveryRows(this.lon.netmgmt().getDeviceDiscoverTable());
    }

    void reloadValue() {
        BComponent target = this.getCurrentValue().asComponent();
        this.registerFolder(target);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
        this.updateDiscoveryRows(this.lon.netmgmt().getDeviceDiscoverTable());
        this.repaint();
    }

    void loadDescendants() {
        BComponent target = this.getCurrentValue().asComponent();
        BLonDeviceFolder[] fa = this.getFolders(target);
        for (int i = 0; i < fa.length; ++i) {
            this.registerFolder((BComponent)fa[i]);
        }
    }

    private void registerFolder(BComponent c) {
        this.registerForComponentEvents(c, 1);
        BLonDevice[] devices = (BLonDevice[])c.getChildren(BLonDevice.class);
        BComponent[] a = new BComponent[devices.length];
        int n = 0;
        for (int i = 0; i < devices.length; ++i) {
            a[n++] = devices[i].getDeviceData();
        }
        this.registerForComponentEvents(a, 0);
    }

    private BLonDeviceFolder[] getFolders(BComponent c) {
        Array a = new Array(BLonDeviceFolder.class);
        this.scanForFolders(c, (Array<BLonDeviceFolder>)a);
        return (BLonDeviceFolder[])a.trim();
    }

    private void scanForFolders(BComponent con, Array<BLonDeviceFolder> a) {
        SlotCursor c = con.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!p.getType().is(BLonDeviceFolder.TYPE)) continue;
            BComponent df = (BComponent)c.get();
            this.registerForComponentEvents(df, 0);
            a.add((Object)((BLonDeviceFolder)df));
            this.scanForFolders(df, a);
        }
    }

    protected BJobBar getJobBar() {
        return this.jobBar;
    }

    public void handleComponentEvent(BComponentEvent event) {
        int id = event.getId();
        BComponent srcCmp = event.getSourceComponent();
        switch (id) {
            case 5: {
                if (srcCmp == this.getNetwork()) {
                    if (event.getSlot() != BLonNetwork.deviceChange) break;
                    this.repaint();
                    break;
                }
                if (srcCmp != this.getNetwork().netmgmt()) break;
                if (event.getSlot() == BLonNetmgmt.learnComplete) {
                    this.reloadValue();
                    break;
                }
                if (event.getSlot() == BLonNetmgmt.deviceDiscoveryUpdated) {
                    this.updateDiscoveryRows((BDeviceEntryTable)event.getValue());
                    break;
                }
                if (event.getSlot() != BLonNetmgmt.servicePinReceived) break;
                BNeuronId nid = ((BServicePinData)event.getValue()).getNeuronId();
                BMgrTable tab = this.getModel().getTable();
                int cnt = tab.getComponentModel().getRowCount();
                for (int i = 0; i < cnt; ++i) {
                    BComponent c = tab.getComponentAt(i);
                    if (!c.getType().is(BLonDevice.TYPE) || !((BLonDevice)c).getNeuronIdAddress().equals((Object)nid)) continue;
                    tab.getSelection().select(i, true);
                    break;
                }
                BDeviceEntry[] le = (BDeviceEntry[])this.getLearn().getRoots();
                for (int i = 0; i < le.length; ++i) {
                    if (!le[i].getNeuronId().equals((Object)nid)) continue;
                    this.getLearn().getTable().getSelection().select(i, true);
                }
                break;
            }
            case 1: 
            case 2: {
                if (!event.getValue().getType().is(BLonDevice.TYPE) && !event.getValue().getType().is(BLonDeviceFolder.TYPE)) break;
                this.reloadValue();
                break;
            }
            case 0: {
                if (!srcCmp.getType().is(BLonDevice.TYPE) && !srcCmp.getType().is(BDeviceData.TYPE)) break;
                this.repaint();
            }
        }
        super.handleComponentEvent(event);
    }

    protected void updateDiscoveryRows(BDeviceEntryTable entryTable) {
        Object[] discoveryRows = entryTable.getDeviceEntries();
        this.getLearn().updateRoots(discoveryRows);
    }

    public BLonNetwork getNetwork() {
        if (this.lon == null) {
            Thread.dumpStack();
        }
        return this.lon;
    }

    public boolean isUseNetAddress() {
        return this.useNetAddress;
    }

    public void setUseNetAddress(boolean b) {
        this.useNetAddress = b;
    }

    public void validate(MgrEditRow row) {
        int sub = ((BInteger)row.getCell(this.colSubnet)).getInt();
        int nod = ((BInteger)row.getCell(this.colNode)).getInt();
        BSubnetNode sn = BSubnetNode.make((int)sub, (int)nod);
        BLonDevice dev = (BLonDevice)row.getTarget();
        if (dev.getDeviceData().getSubnetNodeId().equals((Object)sn)) {
            return;
        }
        BOrd ord = this.lon.getLonNetmgmt().deviceForSubnetNodeId(sn);
        if (ord != null && !ord.equals((Object)dev.getHandleOrd())) {
            if (dev.isMounted()) {
                throw new BajaRuntimeException("Address " + sub + "/" + nod + " already in use.");
            }
            row.setCell(this.colSubnet, (BValue)BInteger.make((int)0));
            row.setCell(this.colNode, (BValue)BInteger.make((int)0));
        }
    }

    static abstract class IntColumn
    extends MgrColumn {
        public IntColumn(String displayName, int flags) {
            super(displayName, flags);
        }

        public BValue load(MgrEditRow row) {
            return ((BValue)this.get(row.getTarget())).newCopy();
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor e) {
            BValue v = rows[0].getCell(colIndex);
            if (e == null) {
                e = BWbFieldEditor.makeFor((BObject)v);
            }
            e.loadValue((BObject)v);
            return e;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            IntColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, null);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
        }
    }

    class XmlColumn
    extends MgrColumn {
        public XmlColumn() {
            super(lexicon.getText("device.columnTitle.xmlFile"), 1);
        }

        public Object get(Object tgt) {
            if (!(tgt instanceof BDynamicDevice)) {
                return BOrd.DEFAULT;
            }
            return ((BDynamicDevice)tgt).getXmlFile();
        }

        public BValue load(MgrEditRow row) {
            return ((BValue)this.get(row.getTarget())).newCopy();
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if (!(row.getTarget() instanceof BDynamicDevice)) {
                return;
            }
            BDynamicDevice dev = (BDynamicDevice)row.getTarget();
            BLonDeviceManager mgr = (BLonDeviceManager)row.getManager();
            BOrd xml = (BOrd)row.getCell(mgr.colXmlFile);
            if (dev.getXmlFile() == null || !dev.getXmlFile().equals((Object)xml)) {
                BImportParameters param = new BImportParameters(false, BLonDeviceManager.this.lon.getLonNetmgmt().getUseLonObjects());
                dev.setXmlFile(xml);
                try {
                    dev.doImportXml(param, BLonDeviceManager.this.getNetwork().log());
                }
                catch (UnresolvedException e) {
                    dev.importXml(param);
                }
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor e) {
            if (rows.length != 1) {
                return null;
            }
            if (!(rows[0].getTarget() instanceof BDynamicDevice)) {
                return null;
            }
            BValue v = rows[0].getCell(colIndex);
            if (e == null) {
                e = BWbFieldEditor.makeFor((BObject)v);
            }
            e.loadValue((BObject)v);
            return e;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            XmlColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, null);
        }
    }

    static class MfgIdColumn
    extends IntColumn {
        public MfgIdColumn() {
            super(lexicon.getText("device.columnTitle.mfgId"), 0);
        }

        public Object get(Object tgt) {
            return ((BLonDevice)tgt).getDeviceData().getProgramId().getMfgId().getConvertedName();
        }
    }

    static class NodeColumn
    extends IntColumn {
        public NodeColumn() {
            super(lexicon.getText("device.columnTitle.node"), 1);
        }

        public Object get(Object tgt) {
            return BInteger.make((int)((BLonDevice)tgt).getDeviceData().getSubnetNodeId().getNodeId());
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor e) {
            if (rows.length > 1) {
                return null;
            }
            return super.toEditor(rows, colIndex, e);
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
            BLonDeviceManager mgr = (BLonDeviceManager)row.getManager();
            mgr.validate(row);
            int nod = ((BInteger)row.getCell(mgr.colNode)).getInt();
            BDeviceData dd = ((BLonDevice)row.getTarget()).getDeviceData();
            BSubnetNode sn = dd.getSubnetNodeId();
            dd.setSubnetNodeId(BSubnetNode.make((int)sn.getSubnetId(), (int)nod));
        }
    }

    static class SubnetColumn
    extends IntColumn {
        public SubnetColumn() {
            super(lexicon.getText("device.columnTitle.subnet"), 1);
        }

        public Object get(Object tgt) {
            return BInteger.make((int)((BLonDevice)tgt).getDeviceData().getSubnetNodeId().getSubnetId());
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
            BLonDeviceManager mgr = (BLonDeviceManager)row.getManager();
            mgr.validate(row);
            int sub = ((BInteger)row.getCell(mgr.colSubnet)).getInt();
            BDeviceData dd = ((BLonDevice)row.getTarget()).getDeviceData();
            BSubnetNode sn = dd.getSubnetNodeId();
            dd.setSubnetNodeId(BSubnetNode.make((int)sub, (int)sn.getNodeId()));
        }
    }

    static class StatusColumn
    extends MgrColumn {
        public StatusColumn() {
            super(lexicon.getText("device.columnTitle.status"), 2);
        }

        public Object get(Object tgt) {
            return ((BLonDevice)tgt).getStatus().flagsToString(null);
        }
    }

    class LonTypeInfo
    extends MgrTypeInfo {
        TypeInfo ti;
        DeviceDef def;
        int ndx;

        LonTypeInfo(DeviceDef def, int ndx) {
            this.ti = def.getTypeInfo(ndx);
            this.ndx = ndx;
            this.def = def;
        }

        public String getDisplayName() {
            Context cx = BLonDeviceManager.this.getCurrentContext();
            Lexicon lex = Lexicon.make((String)this.def.getModule(this.ndx), (Context)cx);
            String n = this.def.getName(this.ndx);
            n = lex.get(n + ".displayName", n);
            return SlotPath.unescape((String)n);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.ti.getIcon(null));
        }

        public boolean isMatchable(BComponent db) {
            return db.getType().is(this.ti);
        }

        public BComponent newInstance() {
            BLonDevice dev = (BLonDevice)this.ti.getInstance();
            if (this.def.isXml(this.ndx)) {
                ((BDynamicDevice)dev).setXmlFile(this.def.getXmlOrd(this.ndx));
            }
            return dev;
        }

        public boolean isType(BLonDevice dev) {
            if (this.def.isClass(this.ndx) && this.def.getType(this.ndx).getClass() == dev.getClass()) {
                return true;
            }
            return dev instanceof BDynamicDevice && ((BDynamicDevice)dev).getXmlFile().equals((Object)this.def.getXmlOrd(this.ndx));
        }
    }

    public class LonDeviceModel
    extends DeviceModel {
        Hashtable<BComponent, MgrTypeInfo> hash;

        LonDeviceModel(BLonDeviceManager manager) {
            super((BDeviceManager)manager);
            this.hash = new Hashtable();
        }

        public MgrTypeInfo[] getNewTypes(BProgramId pId) {
            Array a = new Array(LonTypeInfo.class);
            DeviceDef def = new DeviceDef(pId);
            int cnt = def.entryCount();
            if (cnt == 0) {
                a.add((Object)new LonTypeInfo(def, -1));
            } else {
                for (int i = 0; i < cnt; ++i) {
                    a.add((Object)new LonTypeInfo(def, i));
                }
            }
            return (MgrTypeInfo[])a.trim();
        }

        public MgrTypeInfo[] getNewTypes() {
            int i;
            TypeInfo[] tia = Sys.getRegistry().getConcreteTypes(BLonDevice.TYPE.getTypeInfo());
            Array a = new Array(TypeInfo.class, tia.length - 2);
            for (i = 0; i < tia.length; ++i) {
                String s = tia[i].getTypeClassName();
                if (!s.startsWith("javax.baja.lonworks")) continue;
                if (s.equals("javax.baja.lonworks.BDynamicDevice")) {
                    a.add((Object)tia[i]);
                }
                tia[i] = null;
            }
            for (i = 0; i < tia.length; ++i) {
                if (tia[i] == null) continue;
                a.add((Object)tia[i]);
            }
            return MgrTypeInfo.makeArray((TypeInfo[])((TypeInfo[])a.trim()));
        }

        protected MgrColumn[] makeColumns() {
            return BLonDeviceManager.this.cols;
        }

        public Object[] prepareDeployMatch(Object[] discObj, BDevice[] addedDevices, Context cx) {
            ArrayList<BDeviceEntry> discList = new ArrayList<BDeviceEntry>();
            IntHashMap snHash = new IntHashMap();
            for (int i = 0; i < discObj.length; ++i) {
                Object disObj = discObj[i];
                BDeviceEntry de = (BDeviceEntry)disObj;
                BSubnetNode discSn = de.getSubnetNodeId();
                snHash.put(discSn.hashCode(), disObj);
                discList.add(de);
            }
            discList.sort((n1, n2) -> new Integer(n2.getSubnetNodeId().hashCode()).compareTo(new Integer(n1.getSubnetNodeId().hashCode())));
            return discList.toArray();
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            boolean templateMode;
            Array a = new Array(BDynamicDevice.class);
            IntHashMap snHash = new IntHashMap();
            boolean bl = templateMode = this.getManager().getController().templateMode.isSelected() && this.getManager().getMgrTemplate().getTable().getSelectedObjects().length == 1;
            if (templateMode) {
                return super.addInstances(rows, cx);
            }
            for (int i = 0; i < rows.length; ++i) {
                MgrEditRow r = rows[i];
                BLonDevice dev = (BLonDevice)r.getTarget();
                if (this.preProcess(r, r.getTargetParent(), r.getName(), dev, snHash, cx)) {
                    a.add((Object)((BDynamicDevice)dev));
                }
                super.addInstances(new MgrEditRow[]{r}, cx);
            }
            BDynamicDevice[] ddevs = (BDynamicDevice[])a.trim();
            BComponent base = (BComponent)this.getManager().getCurrentValue();
            if (ddevs.length > 0) {
                base.getComponentSpace().sync();
            }
            for (int i = 0; i < ddevs.length; ++i) {
                BOrd ord = BLonDeviceManager.this.lon.getLonNetmgmt().deviceForNeuronId(ddevs[i].getNeuronIdAddress());
                BDynamicDevice dd = (BDynamicDevice)ord.resolve((BObject)base).get();
                dd.learnNv();
            }
            return null;
        }

        private boolean preProcess(MgrEditRow row, BComponent parent, String name, BLonDevice dev, IntHashMap snHash, Context cx) throws Exception {
            BSubnetNode sn;
            this.hash.remove(dev);
            Object dis = row.getDiscovery();
            BLonNodeState ns = BLonNodeState.unknown;
            BDeviceEntry de = (BDeviceEntry)dis;
            if (de != null) {
                ns = de.getState();
            }
            BDeviceData dd = dev.getDeviceData();
            if (de != null) {
                dd.setAuthenticate(de.getAuthenticate());
            }
            if (snHash.put((sn = dd.getSubnetNodeId()).hashCode(), (Object)dev) != null || BLonDeviceManager.this.lon.getLonNetmgmt().deviceForSubnetNodeId(sn) != null) {
                dd.setSubnetNodeId(BSubnetNode.DEFAULT);
            }
            if (dd.getSubnetNodeId().equals((Object)BSubnetNode.DEFAULT) && ns.isConfigured()) {
                ns = BLonNodeState.unknown;
            }
            dd.setNodeState(ns);
            if (dev instanceof BDynamicDevice) {
                BDynamicDevice dynDev = (BDynamicDevice)dev;
                if (this.hasValidXml(dynDev)) {
                    BProgramId pid = dd.getProgramId();
                    BImportParameters param = new BImportParameters(false, BLonDeviceManager.this.lon.getLonNetmgmt().getUseLonObjects());
                    try {
                        dynDev.doImportXml(param, BLonDeviceManager.this.getNetwork().log());
                    }
                    catch (UnresolvedException e) {
                        dynDev.importXml(param);
                    }
                    if (!pid.isZero()) {
                        dynDev.getDeviceData().setProgramId(pid);
                    }
                } else if (!((BNeuronId)row.getCell(BLonDeviceManager.this.colNeuronId)).isZero()) {
                    return true;
                }
            }
            return false;
        }

        private boolean hasValidXml(BDynamicDevice dev) {
            try {
                if (dev.getXmlFile().get() != null) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        protected BMgrTable makeTable() {
            return new BLonDevMgrTable((MgrModel)this);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BComponent c = type.newInstance();
            this.hash.put(c, type);
            return c;
        }

        public MgrTypeInfo toType(BComponent c) {
            MgrTypeInfo info = this.hash.get(c);
            if (info != null) {
                return info;
            }
            if (c.getType() != BDynamicDevice.TYPE) {
                return MgrTypeInfo.make((BComponent)c);
            }
            BProgramId pId = ((BLonDevice)c).getDeviceData().getProgramId();
            LonTypeInfo[] infos = (LonTypeInfo[])this.getNewTypes(pId);
            for (int i = 0; i < infos.length; ++i) {
                if (!infos[i].isType((BLonDevice)c)) continue;
                return infos[i];
            }
            return infos[0];
        }
    }
}

