/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BRouterEntry;
import javax.baja.gx.BImage;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonDeviceFolder;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BLonDeviceFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BLonDeviceFE.class);
    BLonNetwork lon = null;
    BTextDropDown field = new BTextDropDown("", 20, true);
    Item[] items;

    public Type getType() {
        return TYPE;
    }

    public BLonDeviceFE() {
    }

    public BLonDeviceFE(BLonNetwork lon) {
        this.setContent((BWidget)this.field);
        this.linkTo("la", (BComponent)this.field, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lb", (BComponent)this.field, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
        this.lon = lon;
    }

    public BComplex[] list() throws Exception {
        Array a = new Array(BComplex.class);
        this.getListEntries((Array<BComplex>)a, (BComponent)this.lon, true);
        return (BComplex[])a.trim();
    }

    private void getListEntries(Array<BComplex> a, BComponent c, boolean top) {
        BLonDevice[] devs = (BLonDevice[])c.getChildren(BLonDevice.class);
        for (int i = 0; i < devs.length; ++i) {
            a.add((Object)devs[i]);
        }
        BLonRouter[] rtrs = (BLonRouter[])c.getChildren(BLonRouter.class);
        for (int i = 0; i < rtrs.length; ++i) {
            a.add((Object)rtrs[i]);
        }
        BLonDeviceFolder[] fds = (BLonDeviceFolder[])c.getChildren(BLonDeviceFolder.class);
        for (int i = 0; i < fds.length; ++i) {
            this.getListEntries(a, (BComponent)fds[i], false);
        }
        if (top) {
            BDeviceEntry[] devE = this.lon.netmgmt().getDeviceDiscoverTable().getDeviceEntries();
            for (int i = 0; i < devE.length; ++i) {
                a.add((Object)devE[i]);
            }
            BRouterEntry[] rtrE = this.lon.netmgmt().getRouterDiscoverTable().getRouterEntries();
            for (int i = 0; i < rtrE.length; ++i) {
                a.add((Object)rtrE[i]);
            }
        }
    }

    public BComplex getSelectedEntry() {
        String displayText = this.field.getText();
        if (this.items == null) {
            return null;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].displayName.equals(displayText)) continue;
            return this.items[i].obj;
        }
        return null;
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.getEditor().setEditable(!readonly);
        this.field.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue() {
        this.field.getList().removeAllItems();
        this.items = null;
        try {
            BComplex[] vals = this.list();
            this.items = new Item[vals.length];
            for (int i = 0; i < this.items.length; ++i) {
                Item item = this.items[i] = new Item(vals[i]);
                this.field.getList().addItem(item.icon, (Object)item);
            }
            if (this.items.length > 0) {
                this.field.setText(this.items[0].displayName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        return BString.make((String)this.field.getText());
    }

    static class Item {
        String displayName;
        BImage icon = null;
        BComplex obj;

        Item(BComplex c) {
            this.obj = c;
            BImage bImage = this.icon = c.isComponent() ? BImage.make((BIcon)((BComponent)c).getIcon()) : null;
            if (c.getType().is(BDeviceEntry.TYPE)) {
                BDeviceEntry e = (BDeviceEntry)c;
                this.displayName = e.getUtilName() + ", " + e.getNeuronId();
            } else if (c.getType().is(BRouterEntry.TYPE)) {
                BRouterEntry e = (BRouterEntry)c;
                this.displayName = e.getUtilName() + ", " + e.getNeuronId();
            } else if (c.getType().is(BLonDevice.TYPE)) {
                BLonDevice dev = (BLonDevice)c;
                this.displayName = dev.getDisplayName(null);
                if (!dev.isLocal()) {
                    this.displayName = this.displayName + ", " + dev.getSubnetNodeAddress();
                }
            } else {
                this.displayName = ((BComponent)c).getDisplayName(null);
            }
            this.displayName = SlotPath.unescape((String)this.displayName);
        }

        public String toString() {
            return this.displayName;
        }
    }
}

