/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui;

import com.tridium.workbench.fieldeditors.BFloatFE;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javax.baja.lonworks.londata.BLonBigInteger;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonLong;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.units.BUnit;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BLonBigIntegerFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BLonBigIntegerFE.class);
    private static final String NAN = "nan";
    private BTextField field = new BTextField("");
    private BLabel postlabel = new BLabel("");
    private BLabel prelabel = new BLabel("");
    private Values values;

    public Type getType() {
        return TYPE;
    }

    public BLonBigIntegerFE() {
        this.field.setController((TextController)new BFloatFE.Controller());
        BGridPane pane = new BGridPane(3);
        pane.add("prelabel", (BValue)this.prelabel);
        pane.add("field", (BValue)this.field);
        pane.add("postlabel", (BValue)this.postlabel);
        this.setContent((BWidget)pane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        if (value instanceof BLonInteger) {
            this.values = new IntValues(cx);
        } else if (value instanceof BLonLong) {
            this.values = new LongValues(cx);
        } else if (value instanceof BLonBigInteger) {
            this.values = new BigIntegerValues(cx);
        }
        this.field.setVisibleColumns(this.values.width);
        String s = this.values.toString(value);
        this.field.setText(s);
        this.prelabel.setText(this.values.premeta);
        this.postlabel.setText(this.values.postmeta);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String s = this.field.getText();
        BValue saved = this.values.fromString(s);
        this.field.setText(this.values.toString((BObject)saved));
        return saved;
    }

    class BigIntegerValues
    extends Values {
        BigInteger biMin;
        BigInteger biMax;
        BigInteger biInvalid;

        public BigIntegerValues(Context cx) {
            super(cx);
            if (this.width == 0) {
                this.width = 20;
            }
            this.biMin = BigInteger.valueOf(this.min.getLong());
            this.biMax = BigInteger.valueOf(this.max.getLong());
            this.biInvalid = this.invalid != null ? BigInteger.valueOf(this.invalid.getLong()) : null;
        }

        @Override
        String toString(BObject x) {
            BigInteger biVal = ((BLonBigInteger)x).getBigInteger();
            if (this.biInvalid != null && biVal.compareTo(this.biInvalid) == 0) {
                return BLonBigIntegerFE.NAN;
            }
            return this.toStringFormat.format(biVal);
        }

        @Override
        BValue fromString(String s) throws CannotSaveException {
            BigInteger x;
            try {
                if (BLonBigIntegerFE.NAN.equalsIgnoreCase(s)) {
                    if (this.biInvalid == null) {
                        throw new CannotSaveException(s + " is not valid.");
                    }
                    return BLonBigInteger.make((BigInteger)BigInteger.valueOf(this.invalid.getLong()), (boolean)true);
                }
                String stripped = s.startsWith("+") ? s.substring(1) : s;
                ParsePosition pos = new ParsePosition(0);
                x = BigInteger.valueOf(this.fromStringFormat.parse(stripped, pos).longValue());
                if (pos.getIndex() != stripped.length()) {
                    throw new CannotSaveException("Invalid format: " + s);
                }
            }
            catch (CannotSaveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CannotSaveException("Invalid format: " + s);
            }
            if (x.compareTo(this.biMin) < 0) {
                throw new CannotSaveException(s + " < " + this.biMin.toString() + " " + this.range);
            }
            if (x.compareTo(this.biMax) > 0) {
                throw new CannotSaveException(s + " > " + this.biMax.toString() + " " + this.range);
            }
            return BLonBigInteger.make((BigInteger)x, (boolean)false);
        }
    }

    class LongValues
    extends Values {
        public LongValues(Context cx) {
            super(cx);
            if (this.width == 0) {
                this.width = 20;
            }
        }

        @Override
        String toString(BObject x) {
            long lngVal = ((BLonLong)x).getLong();
            if (this.invalid != null && lngVal == this.invalid.getLong()) {
                return BLonBigIntegerFE.NAN;
            }
            return this.toStringFormat.format(lngVal);
        }

        @Override
        BValue fromString(String s) throws CannotSaveException {
            long x;
            try {
                if (BLonBigIntegerFE.NAN.equalsIgnoreCase(s)) {
                    if (this.invalid == null) {
                        throw new CannotSaveException(s + " is not valid.");
                    }
                    return BLonLong.make((long)this.invalid.getLong(), (boolean)true);
                }
                String stripped = s.startsWith("+") ? s.substring(1) : s;
                ParsePosition pos = new ParsePosition(0);
                x = this.fromStringFormat.parse(stripped, pos).longValue();
                if (pos.getIndex() != stripped.length()) {
                    throw new CannotSaveException("Invalid format: " + s);
                }
            }
            catch (CannotSaveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CannotSaveException("Invalid format: " + s);
            }
            if (x < this.min.getLong()) {
                throw new CannotSaveException(s + " < " + this.min.toString() + " " + this.range);
            }
            if (x > this.max.getLong()) {
                throw new CannotSaveException(s + " > " + this.max.toString() + " " + this.range);
            }
            return BLonLong.make((long)x, (boolean)false);
        }
    }

    class IntValues
    extends Values {
        public IntValues(Context cx) {
            super(cx);
            if (this.width == 0) {
                this.width = 14;
            }
        }

        @Override
        String toString(BObject x) {
            int intVal = ((BLonInteger)x).getInt();
            if (this.invalid != null && intVal == this.invalid.getInt()) {
                return BLonBigIntegerFE.NAN;
            }
            return this.toStringFormat.format(intVal);
        }

        @Override
        BValue fromString(String s) throws CannotSaveException {
            int x;
            try {
                if (BLonBigIntegerFE.NAN.equalsIgnoreCase(s)) {
                    if (this.invalid == null) {
                        throw new CannotSaveException(s + " is not valid.");
                    }
                    return BLonInteger.make((int)this.invalid.getInt());
                }
                String stripped = s.startsWith("+") ? s.substring(1) : s;
                ParsePosition pos = new ParsePosition(0);
                x = this.fromStringFormat.parse(stripped, pos).intValue();
                if (pos.getIndex() != stripped.length()) {
                    throw new CannotSaveException("Invalid format: " + s);
                }
            }
            catch (CannotSaveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CannotSaveException("Invalid format: " + s);
            }
            if (x < this.min.getInt()) {
                throw new CannotSaveException(s + " < " + this.min.toString() + " " + this.range);
            }
            if (x > this.max.getInt()) {
                throw new CannotSaveException(s + " > " + this.max.toString() + " " + this.range);
            }
            return BLonInteger.make((int)x);
        }
    }

    static abstract class Values {
        final boolean showSeparators;
        final boolean forceSign;
        final DecimalFormat toStringFormat;
        final DecimalFormat fromStringFormat;
        BNumber min = null;
        BNumber max = null;
        BNumber invalid = null;
        String range = "";
        String postmeta = "";
        String premeta = "";
        int width = 0;

        public Values(Context cx) {
            BInteger widthFacet;
            BFacets facets = cx == null ? BFacets.DEFAULT : cx.getFacets();
            BUnit u = (BUnit)cx.getFacet("units");
            if (u != null && !u.isNull()) {
                if (u.getIsPrefix()) {
                    this.premeta = u.getSymbol();
                } else {
                    this.postmeta = u.getSymbol();
                }
            }
            if ((widthFacet = (BInteger)cx.getFacet("fieldWidth")) != null) {
                this.width = widthFacet.getInt();
            }
            this.showSeparators = facets.getb("showSeparators", false);
            this.forceSign = facets.getb("forceSign", false);
            String pattern = null;
            pattern = this.showSeparators ? "#,##0" : "#0";
            this.fromStringFormat = new DecimalFormat(pattern);
            pattern = this.forceSign ? "+" + pattern + ";-" + pattern : pattern;
            this.toStringFormat = new DecimalFormat(pattern);
            this.min = (BNumber)cx.getFacet("min");
            this.max = (BNumber)cx.getFacet("max");
            this.invalid = (BNumber)cx.getFacet("invld");
            String minStr = this.min == null ? "min" : this.min.toString();
            String maxStr = this.max == null ? "max" : this.max.toString();
            this.range = "[" + minStr + " - " + maxStr + "]";
            if (this.postmeta.length() > 0) {
                this.postmeta = this.postmeta + ' ';
            }
            this.postmeta = this.postmeta + this.range;
        }

        abstract String toString(BObject var1);

        abstract BValue fromString(String var1) throws CannotSaveException;
    }
}

