/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.sys.Nre;
import javax.baja.chart.BChartPane;
import javax.baja.chart.Series;
import javax.baja.chart.TrendFlags;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.nre.util.SortUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIObject;
import javax.baja.sys.BNumber;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

public class TableSeries
extends Series {
    private final BIRandomAccessTable<BIObject> table;
    private final String seriesName;
    private final SeriesColumn[] seriesCols;
    private TrendFlagsColumn trendFlags;
    private final BITable<?> backingTable;
    private boolean interpolateTail = false;

    public TableSeries(String seriesName, BITable<?> backingTable, String column0, String column1) {
        this(seriesName, backingTable, BColumnIdentifier.makeTableColumn((String)column0), BColumnIdentifier.makeTableColumn((String)column1));
    }

    public TableSeries(String seriesName, BITable<?> backingTable, BColumnIdentifier id0, BColumnIdentifier id1) {
        this.setPen(BPen.make((double)1.0));
        this.setBrush(BChartPane.DEFAULT_COLORS[0].toBrush());
        this.backingTable = backingTable;
        this.table = Tables.slurp(backingTable);
        BFacets tableFacets = backingTable.getTableFacets();
        this.seriesName = seriesName == null ? (tableFacets != null ? tableFacets.gets("tableName", "") : "") : seriesName;
        this.seriesCols = new SeriesColumn[2];
        this.seriesCols[0] = this.toSeriesColumn(backingTable, id0);
        this.seriesCols[1] = this.toSeriesColumn(backingTable, id1);
        ColumnList cols = backingTable.getColumns();
        Column trendFlagsCol = cols.get("trendFlags");
        if (trendFlagsCol != null) {
            BIObject flagsValue;
            BIDataValue dv;
            Column sCol = cols.get("status");
            TrendFlagsColumn statusCol = null;
            if (sCol != null) {
                if (sCol.getType().is(BStatus.TYPE)) {
                    statusCol = new StatusToInt(sCol);
                } else if (sCol.getType().is(BNumber.TYPE)) {
                    statusCol = new NumberToInt(sCol, null);
                }
            }
            this.trendFlags = trendFlagsCol.getType().is(BNumber.TYPE) ? new NumberToInt(trendFlagsCol, statusCol) : (this.table.size() != 0 ? ((dv = (flagsValue = this.table.get(0).cell(trendFlagsCol)).toDataValue()) instanceof BNumber ? new DataValueToInt(trendFlagsCol, statusCol) : null) : null);
        }
    }

    public TableSeries(String seriesName, BITable<?> table, BColumnIdentifier id0, BColumnIdentifier id1, BBrush brush, BPen pen) {
        this(seriesName, table, id0, id1);
        this.setBrush(brush);
        this.setPen(pen);
    }

    @Override
    public String getName() {
        return this.seriesName;
    }

    @Override
    public int getRowCount() {
        return this.table.size();
    }

    @Override
    public String getColumnName(int index) {
        return this.seriesCols[index].getName();
    }

    @Override
    public String getColumnDisplayName(int index) {
        return this.seriesCols[index].getDisplayName(null);
    }

    @Override
    public Type getColumnType(int index) {
        return this.seriesCols[index].getType();
    }

    @Override
    public BFacets getColumnFacets(int index) {
        return this.seriesCols[index].getFacets();
    }

    @Override
    public Object getValue(int row, int column) {
        return this.seriesCols[column].getValue(this.table, row);
    }

    @Override
    public int getTrendFlags(int row) {
        if (this.trendFlags == null) {
            return 0;
        }
        return this.trendFlags.getFlags(this.table, row);
    }

    @Override
    public Object getMin(int column) {
        BAbsTime startTime;
        BFacets tableFacets;
        Type colType = this.getColumnType(column);
        if (colType == BAbsTime.TYPE && null != (tableFacets = this.table.getTableFacets()) && (startTime = (BAbsTime)tableFacets.getFacet("startTime")) != null && !startTime.isNull()) {
            return startTime;
        }
        Range range = this.seriesCols[column].getRange(this.table);
        return range.min;
    }

    @Override
    public Object getMax(int column) {
        BFacets tableFacets;
        Type colType = this.getColumnType(column);
        if (colType == BAbsTime.TYPE && null != (tableFacets = this.table.getTableFacets())) {
            BAbsTime endTime = (BAbsTime)tableFacets.getFacet("endTime");
            if (endTime != null && !endTime.isNull()) {
                return endTime;
            }
            if (this.shouldInterpolateTail()) {
                return BAbsTime.now();
            }
        }
        Range range = this.seriesCols[column].getRange(this.table);
        return range.max;
    }

    public boolean shouldInterpolateTail() {
        return this.interpolateTail;
    }

    public void setInterpolateTail(boolean value) {
        this.interpolateTail = value;
    }

    private SeriesColumn toSeriesColumn(BITable<?> table, BColumnIdentifier id) {
        if (id.isRowIndex()) {
            return new RowIndexColumn();
        }
        if (id.isTableColumn()) {
            ColumnList columns = table.getColumns();
            Column col = columns.get(id.getColumnName());
            if (col == null) {
                throw new IllegalArgumentException("Column does not exist: " + id.getColumnName());
            }
            return new TableColumn(col);
        }
        throw new IllegalArgumentException("Unsupported column identifier: " + id);
    }

    public Context getContext() {
        Context context = null;
        context = this.backingTable.cursor().getContext();
        if (context == null) {
            context = this.table.cursor().getContext();
        }
        return context;
    }

    private static class StatusToInt
    extends TrendFlagsColumn {
        Column column;

        public StatusToInt(Column column) {
            this.column = column;
        }

        @Override
        public int getFlags(BIRandomAccessTable<BIObject> table, int row) {
            return ((BStatus)table.get(row).cell(this.column)).getBits();
        }
    }

    private static class DataValueToInt
    extends TrendFlagsColumn {
        Column column;
        TrendFlagsColumn statusCol;

        public DataValueToInt(Column column, TrendFlagsColumn statusCol) {
            this.column = column;
            this.statusCol = statusCol;
        }

        @Override
        public int getFlags(BIRandomAccessTable<BIObject> table, int row) {
            if (this.statusCol != null && (this.statusCol.getFlags(table, row) & 0x10) != 0) {
                return ((BNumber)table.get(row).cell(this.column).toDataValue()).getInt() | 4;
            }
            return ((BNumber)table.get(row).cell(this.column).toDataValue()).getInt();
        }
    }

    private static class NumberToInt
    extends TrendFlagsColumn {
        Column column;
        TrendFlagsColumn statusCol;

        public NumberToInt(Column column, TrendFlagsColumn statusCol) {
            this.column = column;
            this.statusCol = statusCol;
        }

        @Override
        public int getFlags(BIRandomAccessTable<BIObject> table, int row) {
            if (this.statusCol != null && (this.statusCol.getFlags(table, row) & 0x10) != 0) {
                return ((BNumber)table.get(row).cell(this.column)).getInt() | 4;
            }
            return ((BNumber)table.get(row).cell(this.column)).getInt();
        }
    }

    private static abstract class TrendFlagsColumn {
        private TrendFlagsColumn() {
        }

        public abstract int getFlags(BIRandomAccessTable<BIObject> var1, int var2);
    }

    private class TableColumn
    extends SeriesColumn {
        Column col;
        BFacets colFacets;
        BUnit colFacetUnits;
        BUnit colDesiredUnits;

        public TableColumn(Column col) {
            this.colFacetUnits = null;
            this.colDesiredUnits = null;
            this.col = col;
            this.colFacets = col.getFacets();
            if (this.getType().is(BNumber.TYPE) && this.colFacets != null && !this.colFacets.isNull()) {
                this.colFacetUnits = (BUnit)this.colFacets.get("units");
                int convert = Nre.unitConversion;
                convert = this.colFacets.geti("unitConversion", convert);
                if (this.colFacetUnits != null && !this.colFacetUnits.isNull() && convert != 0) {
                    BUnitConversion c = BUnitConversion.make((int)convert);
                    this.colDesiredUnits = c.getDesiredUnit(this.colFacetUnits);
                    if (this.colDesiredUnits != this.colFacetUnits) {
                        this.colFacets = BFacets.make((BFacets)this.colFacets, (String)"units", (BIDataValue)this.colDesiredUnits);
                    }
                }
            }
        }

        @Override
        public String getDisplayName(Context cx) {
            return this.col.getDisplayName(cx);
        }

        @Override
        public String getName() {
            return this.col.getName();
        }

        @Override
        public Type getType() {
            return this.col.getType();
        }

        @Override
        public BFacets getFacets() {
            return this.colFacets;
        }

        @Override
        public Object getValue(BIRandomAccessTable<BIObject> table, int row) {
            BIObject val = table.get(row).cell(this.col);
            if (val instanceof BNumber && this.colDesiredUnits != null && this.colFacetUnits != null && this.colDesiredUnits != this.colFacetUnits) {
                val = BDouble.make((double)this.colFacetUnits.convertTo(this.colDesiredUnits, ((BNumber)val).getNumeric()));
            }
            return val;
        }
    }

    private class RowIndexColumn
    extends SeriesColumn {
        private RowIndexColumn() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getDisplayName(Context cx) {
            return null;
        }

        @Override
        public Type getType() {
            return BDouble.TYPE;
        }

        @Override
        public BFacets getFacets() {
            return BFacets.NULL;
        }

        @Override
        public Object getValue(BIRandomAccessTable<BIObject> table, int row) {
            return BDouble.make((double)row);
        }

        @Override
        public Range computeRange(BIRandomAccessTable<BIObject> table) {
            Range r = new Range();
            r.min = BDouble.make((double)0.0);
            r.max = BDouble.make((double)(table.size() - 1));
            return r;
        }
    }

    private abstract class SeriesColumn {
        private Range range;

        private SeriesColumn() {
        }

        public abstract String getName();

        public abstract Type getType();

        public abstract BFacets getFacets();

        public abstract Object getValue(BIRandomAccessTable<BIObject> var1, int var2);

        public String getDisplayName(Context cx) {
            return this.getName();
        }

        public Range getRange(BIRandomAccessTable<BIObject> table) {
            if (this.range == null) {
                this.range = this.computeRange(table);
            }
            return this.range;
        }

        public Range computeRange(BIRandomAccessTable<BIObject> table) {
            Range range = new Range();
            int rowCount = table.size();
            boolean first = true;
            for (int row = 0; row < rowCount; ++row) {
                double v;
                Double d;
                Object val;
                if (TrendFlags.isHidden((int)TableSeries.this.getTrendFlags(row)) || (val = this.getValue(table, row)) instanceof BINumeric && (d = new Double(v = ((BINumeric)val).getNumeric())).isNaN()) continue;
                if (first) {
                    range.min = val;
                    range.max = val;
                    first = false;
                    continue;
                }
                if (SortUtil.compare((Object)val, (Object)range.min) < 0) {
                    range.min = val;
                }
                if (SortUtil.compare((Object)val, (Object)range.max) <= 0) continue;
                range.max = val;
            }
            return range;
        }
    }

    private static class Range {
        Object min;
        Object max;
    }
}

