/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import java.util.ArrayList;
import javax.baja.chart.Series;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;

public class JoinTable {
    private Object[] keys;
    private Object[] columns;
    private Series[] seriesList;
    private Object minRow;
    private Object maxRow;

    public static JoinTable make(Series[] seriesList, int keyColumn) {
        if (keyColumn < 0 || keyColumn > 1) {
            throw new IllegalArgumentException("Invalid key column for join.");
        }
        int seriesColumn = keyColumn == 0 ? 1 : 0;
        int seriesCount = seriesList.length;
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int i = 0; i < seriesCount; ++i) {
            Series series = seriesList[i];
            int rowCount = series.getRowCount();
            for (int row = 0; row < rowCount; ++row) {
                Object keyValue = series.getValue(row, keyColumn);
                if (keyList.contains(keyValue)) continue;
                keyList.add(keyValue);
            }
        }
        Object[] keys = keyList.toArray(new Object[keyList.size()]);
        if (keys.length > 0 && keys[0] instanceof Comparable) {
            SortUtil.sort((Object[])keys);
        }
        Object[] columns = new Object[seriesCount];
        for (int i = 0; i < seriesCount; ++i) {
            Object[] thisSeries;
            columns[i] = thisSeries = new Object[keys.length];
            Series series = seriesList[i];
            int rowCount = series.getRowCount();
            block3: for (int row = 0; row < rowCount; ++row) {
                Object rowKey = series.getValue(row, keyColumn);
                Object rowValue = series.getValue(row, seriesColumn);
                for (int k = 0; k < keys.length; ++k) {
                    if (!rowKey.equals(keys[k])) continue;
                    thisSeries[k] = rowValue;
                    continue block3;
                }
            }
        }
        JoinTable table = new JoinTable();
        table.keys = keys;
        table.columns = columns;
        table.seriesList = seriesList;
        return table;
    }

    private JoinTable() {
    }

    public int getRowCount() {
        return this.keys.length;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Object getKey(int row) {
        return this.keys[row];
    }

    public Object getValue(int row, int col) {
        return ((Object[])this.columns[col])[row];
    }

    public Series getSeries(int col) {
        return this.seriesList[col];
    }

    public Object getMinRow() {
        if (this.minRow == null) {
            this.computeRowRange();
        }
        return this.minRow;
    }

    public Object getMaxRow() {
        if (this.maxRow == null) {
            this.computeRowRange();
        }
        return this.maxRow;
    }

    private void computeRowRange() {
        double min = 0.0;
        double max = 0.0;
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            double rowTotal = 0.0;
            for (int col = 0; col < colCount; ++col) {
                Object cell = this.getValue(row, col);
                if (cell == null) continue;
                rowTotal += ((BINumeric)cell).getNumeric();
            }
            if (row == 0) {
                min = rowTotal;
                max = rowTotal;
                continue;
            }
            min = Math.min(min, rowTotal);
            max = Math.max(max, rowTotal);
        }
        if (min == max) {
            if (min > 0.0) {
                min = 0.0;
            } else {
                max = min < 0.0 ? 0.0 : 10.0;
            }
        }
        this.minRow = BDouble.make((double)min);
        this.maxRow = BDouble.make((double)max);
    }

    private void dump() {
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            double total = 0.0;
            System.out.print(this.getKey(row) + ": ");
            for (int col = 0; col < colCount; ++col) {
                Object val = this.getValue(row, col);
                if (col != 0) {
                    System.out.print(", ");
                }
                System.out.print(val);
                if (!(val instanceof BINumeric)) continue;
                total += ((BINumeric)val).getNumeric();
            }
            System.out.println("   " + total);
        }
    }
}

