/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart.wb;

import com.tridium.chart.wb.BFlexPane;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.ui.theme.Theme;
import java.text.DecimalFormat;
import javax.baja.chart.AxisRenderer;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChartPane;
import javax.baja.chart.BLineChart;
import javax.baja.chart.BNumericAxis;
import javax.baja.chart.BPieChart;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.SimpleChartModel;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BDouble;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BResourceManager
extends BWbView {
    public static final Type TYPE = Sys.loadType(BResourceManager.class);
    static final BFont bold = Theme.widget().getBoldText();
    static final Lexicon lex = Lexicon.make((BModule)TYPE.getModule(), (Context)null);
    static final String lexChartTitle = lex.getText("resourceManager.chartTitle");
    static final String lexSysTitle = lex.getText("resourceManager.sysTitle");
    static final String lexPieTitle = lex.getText("resourceManager.pieTitle");
    static final String lexPropTitle = lex.getText("resourceManager.propTitle");
    static final String lexPropKey = lex.getText("resourceManager.propKey");
    static final String lexPropValue = lex.getText("resourceManager.propValue");
    static final String lexUpdate = lex.getText("resourceManager.update");
    BFoxSession session;
    BSysChannel channel;
    PollThread pollThread;
    Command update = new ReflectCommand((BWidget)this, lexUpdate, "remoteUpdate");
    String version = "";
    BChartPane sysChart;
    BChartPane pieChart;
    boolean sysBuilt;
    boolean pieBuilt;
    CpuSeries cpuSeries;
    MemSeries memSeries;
    BPieChart pie;
    BTable table;
    String[] propKeys = new String[0];
    String[] propValues = new String[0];

    public Type getType() {
        return TYPE;
    }

    public BResourceManager() {
        this.sysChart = new BChartPane();
        this.sysChart.setBorder(BBorder.none);
        this.sysChart.getHeader().setTitle(lexSysTitle);
        this.sysChart.setZoomEnabled(false);
        this.sysChart.getCanvas().setShowHorizontalGridLines(true);
        this.sysChart.getCanvas().setShowVerticalGridLines(true);
        this.pieChart = new BChartPane();
        this.pieChart.setBorder(BBorder.none);
        this.pieChart.getHeader().setTitle(lexPieTitle);
        this.pieChart.setZoomEnabled(false);
        BFlexPane charts = new BFlexPane((BWidget)this.sysChart, (BWidget)this.pieChart, 70);
        BBorderPane borderPane = new BBorderPane((BWidget)charts, BBorder.solid);
        borderPane.setFill(BBrush.make((String)"#eee"));
        BTitlePane chartPane = new BTitlePane(lexChartTitle, (BWidget)borderPane);
        this.table = new BTable((TableModel)new PropertyModel());
        BTitlePane tablePane = BTitlePane.makePane((String)lexPropTitle, (BTable)this.table);
        BGridPane actions = new BGridPane();
        actions.setUniformColumnWidth(true);
        actions.add(null, (BValue)new BButton(this.update));
        BSplitPane split = new BSplitPane(BOrientation.vertical, 50.0);
        split.setWidget1((BWidget)chartPane);
        split.setWidget2((BWidget)tablePane);
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)split);
        content.setBottom((BWidget)new BBorderPane((BWidget)actions, BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0)));
        this.setContent((BWidget)content);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopPoll();
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.session = (BFoxSession)value;
        this.channel = this.session.getConnection().getChannels().getSysChannel();
        this.poll();
        this.startPoll();
    }

    public void remoteUpdate() throws Exception {
        this.channel.stationCall("resource.update", null);
    }

    void poll() throws Exception {
        byte[] resp = this.channel.stationCall("resource.report", null);
        ResourceReport r = ResourceReport.decode((byte[])resp);
        this.updateSysChart(r);
        this.updatePieChart(r);
        this.updatePropertyTable(r);
    }

    void updatePropertyTable(ResourceReport r) {
        Object[] propKeys = r.props();
        String[] propValues = new String[propKeys.length];
        SortUtil.sort((Object[])propKeys, (Object[])propKeys);
        for (int i = 0; i < propKeys.length; ++i) {
            propValues[i] = r.prop((String)propKeys[i]);
        }
        this.propKeys = propKeys;
        this.propValues = propValues;
        this.table.getModel().updateTable();
    }

    void updateSysChart(ResourceReport r) {
        if (!this.sysBuilt) {
            BLineChart chart = new BLineChart();
            SimpleChartModel model = new SimpleChartModel();
            this.cpuSeries = new CpuSeries(r.cpu());
            BNumericAxis xaxis = new BNumericAxis(this.cpuSeries.getMin(0), this.cpuSeries.getMax(0));
            xaxis.setRenderer(new NullAxisRenderer());
            BNumericAxis yaxis = new BNumericAxis(this.cpuSeries.getMin(1), this.cpuSeries.getMax(1));
            yaxis.setDecimalFormat(new DecimalFormat("##0"));
            yaxis.setTitle(lex.getText("ResourceManager.cpuPercent"));
            model.add(new ChartSpec(this.cpuSeries, xaxis, yaxis));
            this.memSeries = new MemSeries(r.mem());
            yaxis = new BNumericAxis(this.memSeries.getMin(1), this.memSeries.getMax(1));
            yaxis.setDecimalFormat(new DecimalFormat("##0"));
            yaxis.setTitle(lex.getText("ResourceManager.memoryUsage"));
            model.add(new ChartSpec(this.memSeries, xaxis, yaxis));
            chart.setModel(model);
            this.sysChart.add("cpu", (BValue)chart);
            this.sysBuilt = true;
        }
        this.cpuSeries.setData(r.cpu());
        this.memSeries.setData(r.mem());
    }

    void updatePieChart(ResourceReport r) {
        if (!this.pieBuilt) {
            this.pie = new BPieChart();
            this.pieChart.add("pie", (BValue)this.pie);
            this.pieBuilt = true;
        }
        int free = -1;
        int limit = r.ruLimit();
        if (limit > 0 && limit >= r.ruTotal()) {
            free = limit - r.ruTotal();
        }
        int predefined = free > 0 ? 2 : 1;
        String[] cats = r.ruCategories();
        String[] keys = new String[cats.length + predefined];
        double[] vals = new double[cats.length + predefined];
        int n = 0;
        if (free > 0) {
            keys[n] = "free";
            vals[n] = free;
            ++n;
        }
        keys[n] = "components";
        vals[n] = r.ruDefault();
        ++n;
        for (int i = 0; i < cats.length; ++i) {
            keys[n] = cats[i];
            vals[n] = r.ru(cats[i]);
            ++n;
        }
        this.pie.setModel(keys, vals);
    }

    void startPoll() {
        this.stopPoll();
        this.pollThread = new PollThread();
        this.pollThread.start();
    }

    void stopPoll() {
        if (this.pollThread != null) {
            this.pollThread.kill();
        }
        this.pollThread = null;
    }

    public BChartPane getSysChart() {
        return this.sysChart;
    }

    public BChartPane getPieChart() {
        return this.pieChart;
    }

    class PollThread
    extends Thread {
        boolean isAlive;

        PollThread() {
            super("ui:ResourceManagerPoll");
            this.isAlive = true;
        }

        public void kill() {
            this.isAlive = false;
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.isAlive) {
                try {
                    Thread.sleep(1000L);
                    if (!this.isAlive || !BResourceManager.this.session.isConnected()) continue;
                    BResourceManager.this.poll();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class NullAxisRenderer
    extends AxisRenderer {
        private NullAxisRenderer() {
        }

        @Override
        public void paint(Graphics g, BAxis axis) {
        }

        @Override
        public double getPreferredAxisWidth(BAxis axis) {
            return 5.0;
        }
    }

    private class MemSeries
    extends Series {
        double[] data;
        double seriesMax;
        String seriesName;
        String colName0;
        String colName1;

        public MemSeries(int[] dataKb) {
            this.setData(dataKb);
            this.seriesName = lex.getText("ResourceManager.memoryUsage");
            this.colName0 = lex.getText("ResourceManager.time");
            this.colName1 = lex.getText("ResourceManager.memory");
        }

        public void setData(int[] dataKb) {
            this.seriesMax = 0.0;
            double max = 0.0;
            this.data = new double[dataKb.length];
            for (int i = 0; i < dataKb.length; ++i) {
                this.data[i] = (double)dataKb[i] / 1024.0;
                max = Math.max(this.data[i], this.seriesMax);
            }
            this.seriesMax = Math.round(max * 1.2 / 5.0 + 0.5) * 5L;
            while (max > this.seriesMax) {
                this.seriesMax += 1.0;
            }
            this.modified();
        }

        @Override
        public String getName() {
            return this.seriesName;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return this.colName0;
            }
            if (col == 1) {
                return this.colName1;
            }
            return "Error-" + col;
        }

        @Override
        public String getColumnDisplayName(int col) {
            return this.getColumnName(col);
        }

        @Override
        public Type getColumnType(int col) {
            if (col == 0) {
                return BDouble.TYPE;
            }
            if (col == 1) {
                return BDouble.TYPE;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValue(int row, int col) {
            if (col == 0) {
                return BDouble.make((double)row);
            }
            return BDouble.make((double)this.data[row]);
        }

        @Override
        public Object getMin(int col) {
            return BDouble.make((double)0.0);
        }

        @Override
        public Object getMax(int col) {
            if (col == 0) {
                return BDouble.make((double)(this.getRowCount() - 1));
            }
            if (col == 1) {
                return BDouble.make((double)this.seriesMax);
            }
            throw new IllegalArgumentException();
        }
    }

    private class CpuSeries
    extends Series {
        int[] data;
        String seriesName;
        String colName0;
        String colName1;

        public CpuSeries(int[] data) {
            this.data = data;
            this.seriesName = lex.getText("ResourceManager.cpuPercent");
            this.colName0 = lex.getText("ResourceManager.time");
            this.colName1 = lex.getText("ResourceManager.cpu");
        }

        public void setData(int[] data) {
            this.data = data;
            this.modified();
        }

        @Override
        public String getName() {
            return this.seriesName;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return this.colName0;
            }
            if (col == 1) {
                return this.colName1;
            }
            return "Error-" + col;
        }

        @Override
        public String getColumnDisplayName(int col) {
            return this.getColumnName(col);
        }

        @Override
        public Type getColumnType(int col) {
            if (col == 0) {
                return BDouble.TYPE;
            }
            if (col == 1) {
                return BDouble.TYPE;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValue(int row, int col) {
            if (col == 0) {
                return BDouble.make((double)row);
            }
            return BDouble.make((double)this.data[row]);
        }

        @Override
        public Object getMin(int col) {
            return BDouble.make((double)0.0);
        }

        @Override
        public Object getMax(int col) {
            if (col == 0) {
                return BDouble.make((double)(this.getRowCount() - 1));
            }
            if (col == 1) {
                return BDouble.make((double)100.0);
            }
            throw new IllegalArgumentException();
        }
    }

    class PropertyModel
    extends TableModel {
        PropertyModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            return col == 0 ? lexPropKey : lexPropValue;
        }

        public int getRowCount() {
            return BResourceManager.this.propKeys.length;
        }

        public Object getValueAt(int row, int col) {
            return col == 0 ? BResourceManager.this.propKeys[row] : BResourceManager.this.propValues[row];
        }
    }
}

