/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart.test;

import java.util.Random;
import javax.baja.chart.Series;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Type;

public class TestTimeSeries
extends Series {
    static Random rand = new Random();
    private String name;
    private double[] data;
    private BAbsTime[] times;
    private double min;
    private double max;

    public TestTimeSeries(String name, int rows, double maxValue, long timeIncrMillis) {
        this.name = name;
        this.data = new double[rows];
        this.times = new BAbsTime[rows];
        this.min = 0.0;
        this.max = 0.0;
        BAbsTime t = BAbsTime.now();
        BRelTime timeIncr = BRelTime.make((long)timeIncrMillis);
        for (int i = 0; i < rows; ++i) {
            this.times[i] = t;
            t = t.add(timeIncr);
            this.data[i] = maxValue * rand.nextDouble();
            if (i == 0) {
                this.max = this.min = this.data[i];
                continue;
            }
            this.max = Math.max(this.data[i], this.max);
            this.min = Math.min(this.data[i], this.min);
        }
        if (this.min == this.max) {
            this.min -= 5.0;
            this.max += 5.0;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        return "Column-" + col;
    }

    @Override
    public String getColumnDisplayName(int col) {
        return this.getColumnName(col);
    }

    @Override
    public Type getColumnType(int col) {
        if (col == 0) {
            return BAbsTime.TYPE;
        }
        return BDouble.TYPE;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public Object getValue(int row, int col) {
        if (col == 0) {
            return this.times[row];
        }
        return BDouble.make((double)this.data[row]);
    }

    @Override
    public Object getMin(int col) {
        if (col == 0) {
            return this.times[0];
        }
        return BDouble.make((double)this.min);
    }

    @Override
    public Object getMax(int col) {
        if (col == 0) {
            return this.times[this.times.length - 1];
        }
        return BDouble.make((double)this.max);
    }
}

