/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.ui;

import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.tagdictionary.ui.ExportUtil;
import com.tridium.tagdictionary.ui.TagDictionaryUiUtil;
import com.tridium.tagdictionary.util.ImportUtil;
import com.tridium.tagdictionary.util.TagDictionaryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.baja.file.BFileSystem;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BTagDictionaryManager
extends BAbstractManager {
    public static final Action updateCommands = BTagDictionaryManager.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BTagDictionaryManager.class);
    private static final Lexicon lex = Lexicon.make((String)"tagdictionary");
    private BWidget owner;
    private BTable table;
    static BOrd csvDir;
    static BOrd csvFile;
    private ImportCmd importCmd;
    private ExportCmd exportCmd;
    private TagGroupReport tagGroupReport;

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public void doUpdateCommands() {
        boolean hasSelections = this.table.getSelection().getRow() != -1;
        this.importCmd.setEnabled(hasSelections);
        this.exportCmd.setEnabled(hasSelections);
    }

    protected MgrTagDictionary makeTagDictionary() {
        return null;
    }

    public CommandArtifact doTagGroupReport() {
        BComponent target = this.getTarget();
        if (target instanceof BTagDictionaryService) {
            BTagDictionaryService tdService = (BTagDictionaryService)target;
            BComponent infoComp = tdService.tagsToTagGroup();
            try {
                List ctgChoices = TagDictionaryUtil.ComponentTagGroupChoices.decodeFromComponent((BComponent)infoComp, (BComponent)target);
                if (ctgChoices == null || ctgChoices.isEmpty()) {
                    BDialog.info((BWidget)this, (Object)lex.getText("tagGroupReport.nothingToDo"));
                    return null;
                }
                int results = TagDictionaryUiUtil.selectTagGroupChoicesFlat((BWidget)this, ctgChoices, lex);
                if (results == 1) {
                    ArrayList<String> keepTags = new ArrayList<String>();
                    ArrayList<BTagGroupInfo> addTagGroup = new ArrayList<BTagGroupInfo>();
                    ArrayList<BTagGroupInfo> dontAddTagGroup = new ArrayList<BTagGroupInfo>();
                    for (int i = 0; i < ctgChoices.size(); ++i) {
                        String removeName;
                        String qName;
                        boolean isComplete;
                        TagDictionaryUtil.ComponentTagGroupChoices ctgChoice = (TagDictionaryUtil.ComponentTagGroupChoices)ctgChoices.get(i);
                        TagDictionaryUtil.ComponentTagGroupChoices nextCtgChoice = null;
                        if (i + 1 < ctgChoices.size()) {
                            nextCtgChoice = (TagDictionaryUtil.ComponentTagGroupChoices)ctgChoices.get(i + 1);
                        }
                        BComponent thisComp = ctgChoice.getComponent();
                        boolean bl = isComplete = i + 1 == ctgChoices.size() || nextCtgChoice != null && !thisComp.equals((Object)nextCtgChoice.getComponent());
                        if (ctgChoice.isSelected()) {
                            addTagGroup.add(ctgChoice.getTagGroupInfo());
                        } else {
                            dontAddTagGroup.add(ctgChoice.getTagGroupInfo());
                            if (!ctgChoice.isRemoveTags()) {
                                for (TagInfo tagInfo : ctgChoice.getTagGroupInfo().getTagList()) {
                                    keepTags.add(tagInfo.getTagId().getQName());
                                }
                            }
                        }
                        if (!isComplete) continue;
                        BComponent currentComp = thisComp;
                        currentComp.lease();
                        currentComp.loadSlots();
                        for (BTagGroupInfo tagGroupInfo : addTagGroup) {
                            Optional ord;
                            if (tagGroupInfo instanceof Entity && (ord = tagGroupInfo.getOrdToEntity()).isPresent()) {
                                BOrd slotPathOrd = ((BOrd)ord.get()).get((BObject)currentComp).asComponent().getSlotPathOrd();
                                BRelation tgRelation = new BRelation(BNiagaraTagDictionary.TAG_GROUP_RELATION, slotPathOrd);
                                currentComp.add("r?", (BValue)tgRelation);
                            }
                            currentComp.loadSlots();
                            for (TagInfo tagInfo : tagGroupInfo.getTagList()) {
                                BValue tagValue;
                                qName = tagInfo.getTagId().getQName();
                                if (keepTags.contains(qName) || (tagValue = currentComp.get(removeName = SlotPath.escape((String)qName))) == null) continue;
                                if (tagValue.equivalent((Object)tagInfo.getDefaultValue())) {
                                    currentComp.remove(removeName);
                                    continue;
                                }
                                keepTags.add(removeName);
                            }
                        }
                        currentComp.loadSlots();
                        for (BTagGroupInfo tagGroupInfo : dontAddTagGroup) {
                            for (TagInfo tagInfo : tagGroupInfo.getTagList()) {
                                qName = tagInfo.getTagId().getQName();
                                if (keepTags.contains(qName) || currentComp.get(removeName = SlotPath.escape((String)qName)) == null) continue;
                                currentComp.remove(removeName);
                            }
                        }
                        keepTags = new ArrayList();
                        addTagGroup = new ArrayList();
                        dontAddTagGroup = new ArrayList();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public CommandArtifact doExport(Context cx) {
        BComponent db = this.getModel().getTable().getSelectedComponent();
        return this.doExport((BTagDictionary)db, cx);
    }

    public CommandArtifact doExport(BTagDictionary dictionary, Context cx) {
        BOrd ord;
        BFileChooser chooser = BFileChooser.makeSave((BWidget)this.owner);
        csvFile = dictionary.getImportDictionaryOrd();
        csvDir = csvFile.getParent();
        chooser.setCurrentDirectory(csvDir);
        chooser.addFilter((IFileFilter)new ExtFileFilter("csv Files", new String[]{"csv", "CSV"}));
        BFileSystem space = BFileSystem.INSTANCE;
        if (space != null) {
            chooser.setSpaces(new BSpace[]{space});
        }
        if ((ord = chooser.show()) == null) {
            return null;
        }
        csvDir = chooser.getCurrentDirectory();
        csvFile = ord;
        dictionary.lease(Integer.MAX_VALUE);
        dictionary.setImportDictionaryOrd(csvFile);
        ArrayList<ImportUtil.ResultInfo> results = ExportUtil.ExportTagDictionary(dictionary, csvFile);
        this.displayResults(results);
        return null;
    }

    public CommandArtifact doImport(Context cx) {
        BComponent db = this.getModel().getTable().getSelectedComponent();
        return this.doImport((BTagDictionary)db, cx);
    }

    public CommandArtifact doImport(BTagDictionary dictionary, Context cx) {
        ArrayList results;
        int confirm = BDialog.confirm((BWidget)this.owner, (Object)lex.getText("import.overwrite.areYouSure", new Object[]{dictionary.getName()}));
        if (confirm != 4) {
            return null;
        }
        BTagDictionary newDictionary = dictionary.getStandardDictionary();
        if (newDictionary != null) {
            results = new ArrayList();
            if (ImportUtil.equivalent((BTagDictionary)dictionary, (BTagDictionary)newDictionary)) {
                results.add(ImportUtil.ResultInfo.make((String)lex.getText("import.uptodate", new Object[]{dictionary.getName()}), (BColor)BColor.black));
            } else {
                ArrayList savedDataPolicies = ImportUtil.saveDataPolicyInfo((BTagDictionary)dictionary, new ArrayList());
                ImportUtil.updateTagDictionary((BTagDictionary)newDictionary, (BTagDictionary)dictionary, (Context)BTagDictionary.importContext);
                ImportUtil.restoreDataPolicies((ArrayList)savedDataPolicies, (BTagDictionary)dictionary);
                results.add((ImportUtil.ResultInfo)ImportUtil.ResultInfo.make((String)lex.getText("import.reloaded", new Object[]{dictionary.getName()}), (BColor)BColor.black));
            }
        } else {
            BOrd ord;
            BFileChooser chooser = BFileChooser.makeOpen((BWidget)this.owner);
            csvFile = dictionary.getImportDictionaryOrd();
            csvDir = csvFile.getParent();
            chooser.setCurrentDirectory(csvDir);
            chooser.addFilter((IFileFilter)new ExtFileFilter("csv Files", new String[]{"csv", "CSV"}));
            BFileSystem space = BFileSystem.INSTANCE;
            if (space != null) {
                chooser.setSpaces(new BSpace[]{space});
            }
            if ((ord = chooser.show()) == null) {
                return null;
            }
            csvDir = chooser.getCurrentDirectory();
            csvFile = ord;
            dictionary.lease(Integer.MAX_VALUE);
            dictionary.setImportDictionaryOrd(csvFile);
            results = ImportUtil.ImportTagDictionary((BTagDictionary)dictionary, (BOrd)csvFile);
        }
        this.displayResults(results);
        return null;
    }

    public void displayResults(List<ImportUtil.ResultInfo> results) {
        BGridPane pane = new BGridPane(1);
        boolean hasError = false;
        for (ImportUtil.ResultInfo result : results) {
            BLabel infoLabel = new BLabel(result.getInfo(), BHalign.left);
            infoLabel.setForeground(BBrush.makeSolid((BColor)result.getForeground()));
            pane.add(null, (BValue)infoLabel);
            if (!result.getForeground().equals((Object)BColor.red)) continue;
            hasError = true;
        }
        pane.computePreferredSize();
        if (hasError) {
            BDialog.error((BWidget)this.owner, (String)"Results", (Object)pane);
        } else {
            BDialog.info((BWidget)this.owner, (String)"Results", (Object)pane);
        }
    }

    public class ExportCmd
    extends MgrController.MgrCommand {
        public ExportCmd(BWidget owner) {
            super(owner, BTagDictionary.TYPE.getModule().getLexicon(), "exportDictionary");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTagDictionaryManager.this.doExport(null);
        }
    }

    public class ImportCmd
    extends MgrController.MgrCommand {
        public ImportCmd(BWidget owner) {
            super(owner, BTagDictionary.TYPE.getModule().getLexicon(), "importDictionary");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTagDictionaryManager.this.doImport(BTagDictionary.importContext);
        }
    }

    public class TagGroupReport
    extends MgrController.MgrCommand {
        public TagGroupReport(BWidget owner) {
            super(owner, BTagDictionary.TYPE.getModule().getLexicon(), "tagGroupReport");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTagDictionaryManager.this.doTagGroupReport();
        }
    }

    private static class Prop
    extends MgrColumn.Prop {
        public Prop(Property prop, int flags) {
            super(prop, flags);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (this.props.length == 1 && this.props[0].equals(BTagDictionary.namespace) && (rows[0].getTarget().getFlags((Slot)this.props[0]) & 1) != 0) {
                return null;
            }
            return Prop.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])this.props);
        }
    }

    private class Controller
    extends MgrController {
        public Controller(BAbstractManager manager) {
            super(manager);
            BTagDictionaryManager.this.importCmd = new ImportCmd((BWidget)manager);
            BTagDictionaryManager.this.importCmd.setFlags(7);
            BTagDictionaryManager.this.exportCmd = new ExportCmd((BWidget)manager);
            BTagDictionaryManager.this.exportCmd.setFlags(7);
            BTagDictionaryManager.this.tagGroupReport = new TagGroupReport((BWidget)manager);
            BTagDictionaryManager.this.tagGroupReport.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return Controller.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])this.makeMyCommands());
        }

        private MgrController.IMgrCommand[] makeMyCommands() {
            return new MgrController.IMgrCommand[]{BTagDictionaryManager.this.importCmd, BTagDictionaryManager.this.exportCmd, BTagDictionaryManager.this.tagGroupReport};
        }

        public void updateCommands() {
            boolean hasSelections = this.getSelectedRows().length > 0;
            BTagDictionaryManager.this.importCmd.setEnabled(hasSelections);
            BTagDictionaryManager.this.exportCmd.setEnabled(hasSelections);
            BTagDictionaryManager.this.tagGroupReport.setEnabled(true);
        }
    }

    public static class Model
    extends MgrModel {
        public Model(BAbstractManager manager) {
            super(manager);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BTagDictionary.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BTagDictionary.TYPE), MgrTypeInfo.make((Type)BSmartTagDictionary.TYPE)};
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Path(2), new MgrColumn.Name(), new MgrColumn.Type(0), new MgrColumn.Prop(BTagDictionary.status), new MgrColumn.Prop(BTagDictionary.enabled, 3), new Prop(BTagDictionary.namespace, 1), new MgrColumn.Prop(BTagDictionary.faultCause)};
        }
    }
}

