/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.enums.BMbusDescription;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusHeaderTypes;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.utils.MbusDataDecoderIEC870;
import com.tridium.mbus.utils.MbusEnhancedVifExtensionConvertor;
import com.tridium.mbus.utils.MbusExtendedIndicatorVifConvertor;
import com.tridium.mbus.utils.MbusExtendedVifConvertor;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusTextUtil;
import com.tridium.mbus.utils.MbusToolkit;
import com.tridium.mbus.utils.MbusVifConvertor;
import java.util.ArrayList;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.BBaudRate;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;

public final class MbusDecodeVariableFrame {
    String identNumber = "";
    String secondaryAddress = "";
    String manufacturer = "No Manufacturer";
    String fabricationNumber = "";
    int versionNumber = 0;
    BMbusDeviceTypeId deviceTypeId = BMbusDeviceTypeId.other;
    int difeUnit = 0;
    int access = 0;
    String status = "";
    int storageNumber = 0;
    BMbusFunction function = BMbusFunction.instantaneous;
    int difeTariff = 0;
    int dataType = 0;
    String description = "None";
    BMbusOrthogonalDescription orthogonalDescription = BMbusOrthogonalDescription.none;
    BMbusUnit unitType = BMbusUnit.none;
    int exponent = 0;
    double offset = 0.0;
    boolean vifStringFlag = false;
    boolean status5 = false;
    boolean status6 = false;
    boolean status7 = false;
    String vifString = "";
    BStatusValue value = new BStatusString("No Data", BStatus.ok);
    int finishedAtIndex = 0;
    int recordNumber = 1;
    int lastRecordNumber = 1;
    BMbusDevice device = null;
    BAbstractMbusNetwork network = null;
    int inputSlot = 1;
    long blockSize = 0L;
    long blockDate = 0L;
    long blockInterval = 0L;
    boolean manufacturersData = false;
    int manufacturersIndex = -1;
    boolean specialFunctionFound = false;
    int maxSpecialFunctionQty = 0;
    int specialFunctionQty = 0;
    private ArrayList<BMbusPointData> activedataInformation = new ArrayList();

    public MbusDecodeVariableFrame(byte[] inputRawData, BAbstractMbusNetwork inputNetwork, BMbusDevice inputDevice, boolean allowMultipleReads, boolean mode2Active, int maxSpecialFunctionReads) {
        this(inputRawData, inputNetwork, inputDevice, allowMultipleReads, mode2Active, maxSpecialFunctionReads, (DecoderOverrides)null);
    }

    public MbusDecodeVariableFrame(byte[] inputRawData, BAbstractMbusNetwork inputNetwork, BMbusDevice inputDevice, boolean allowMultipleReads, boolean mode2Active, int maxSpecialFunctionReads, DecoderOverrides decoderOverrides) {
        int[] intHold = new int[inputRawData.length];
        for (int i = 0; i < inputRawData.length; ++i) {
            intHold[i] = inputRawData[i] & 0xFF;
        }
        this.init(intHold, inputNetwork, inputDevice, allowMultipleReads, mode2Active, maxSpecialFunctionReads, decoderOverrides);
    }

    public MbusDecodeVariableFrame(int[] inputData, BAbstractMbusNetwork inputNetwork, BMbusDevice inputDevice, boolean allowMultipleReads, boolean mode2Active, int maxSpecialFunctionReads) {
        this.init(inputData, inputNetwork, inputDevice, allowMultipleReads, mode2Active, maxSpecialFunctionReads, null);
    }

    public MbusDecodeVariableFrame(int[] inputData, BAbstractMbusNetwork inputNetwork, BMbusDevice inputDevice, boolean allowMultipleReads, boolean mode2Active, int maxSpecialFunctionReads, DecoderOverrides decoderOverrides) {
        this.init(inputData, inputNetwork, inputDevice, allowMultipleReads, mode2Active, maxSpecialFunctionReads, decoderOverrides);
    }

    private void init(int[] inputData, BAbstractMbusNetwork inputNetwork, BMbusDevice inputDevice, boolean allowMultipleReads, boolean mode2Active, int maxSpecialFunctionReads, DecoderOverrides decoderOverrides) {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN MbusDecodeVariableFrame ");
        }
        int index = 0;
        this.device = inputDevice;
        this.network = inputNetwork;
        this.maxSpecialFunctionQty = maxSpecialFunctionReads;
        this.specialFunctionQty = 0;
        if (this.device != null) {
            if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.zeroLength)) {
                inputData[6] = 120;
            } else if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.byte4)) {
                inputData[6] = 122;
            }
            if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.byte12)) {
                inputData[6] = 114;
            }
            if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.byte12Mode2)) {
                inputData[6] = 118;
            }
        }
        index = this.decodeFixedDataHeader(inputData);
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Returned from decodeFixedDataHeader ");
        }
        this.decodeVariableDataBlocks(inputData, index, inputDevice, allowMultipleReads, mode2Active, maxSpecialFunctionReads, decoderOverrides);
    }

    public int decodeFixedDataHeader(int[] inputData) {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN decodeFixedDataHeader ");
        }
        int index = 7;
        int accessHold = 0;
        int statusHold = 0;
        if (inputData[6] == 122 || inputData[6] == 114) {
            if (inputData[6] == 122) {
                accessHold = inputData[7];
                statusHold = inputData[8];
                index = 11;
            } else {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" IN 12 Byte Header ");
                }
                this.identNumber = MbusTextUtil.intToHexString((inputData[10] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(inputData[10] & 0xF, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString((inputData[9] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(inputData[9] & 0xF, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString((inputData[8] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(inputData[8] & 0xF, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString((inputData[7] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(inputData[7] & 0xF, 1);
                this.secondaryAddress = MbusTextUtil.intToHexString((inputData[11] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(inputData[11] & 0xF, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString((inputData[12] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(inputData[12] & 0xF, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString((inputData[13] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(inputData[13] & 0xF, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString((inputData[14] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(inputData[14] & 0xF, 1);
                this.secondaryAddress = this.identNumber + this.secondaryAddress;
                int tempHold = inputData[11] | inputData[12] << 8;
                byte[] letterHold = new byte[3];
                letterHold[2] = (byte)((tempHold & 0x1F) + 64);
                letterHold[1] = (byte)((tempHold >> 5 & 0x1F) + 64);
                letterHold[0] = (byte)((tempHold >> 10 & 0x1F) + 64);
                this.manufacturer = new String(letterHold);
                this.versionNumber = inputData[13];
                this.deviceTypeId = inputData[14] <= 25 ? BMbusDeviceTypeId.make(inputData[14]) : BMbusDeviceTypeId.reserved;
                accessHold = inputData[15];
                statusHold = inputData[16];
                index = 19;
            }
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" IN Common Header ");
            }
            this.access = accessHold;
            if ((statusHold & 0xF) == 0) {
                this.status = this.status + "No Application Error; ";
            } else if ((statusHold & 0xF) == 1) {
                this.status = this.status + "Application Busy; ";
            } else if ((statusHold & 0xF) == 2) {
                this.status = this.status + "Application Error; ";
            } else if ((statusHold & 0xF) == 3) {
                this.status = this.status + "Application Reserved State; ";
            }
            if ((statusHold & 8) != 0) {
                this.status = this.status + "Permanent Error; ";
            }
            if ((statusHold & 0x10) != 0) {
                this.status = this.status + "Temporary Error; ";
            }
            this.status5 = (statusHold & 0x20) != 0;
            this.status6 = (statusHold & 0x40) != 0;
            this.status7 = (statusHold & 0x80) != 0;
        }
        return index;
    }

    public void decodeVariableDataBlocks(int[] dataInput, int indexInput, BMbusDevice inputDevice, boolean allowMultipleReads, boolean mode2Active, int maxSpecialFunctionReads) {
        this.decodeVariableDataBlocks(dataInput, indexInput, inputDevice, allowMultipleReads, mode2Active, maxSpecialFunctionReads, null);
    }

    public void decodeVariableDataBlocks(int[] dataInput, int indexInput, BMbusDevice inputDevice, boolean allowMultipleReads, boolean mode2Active, int maxSpecialFunctionReads, DecoderOverrides decoderOverrides) {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN decodeVariableDataBlocks ");
        }
        int[] inputData = dataInput;
        int index = indexInput;
        boolean dataLeft = true;
        this.manufacturersData = false;
        boolean noValueDecode = false;
        if (inputDevice == null) {
            noValueDecode = true;
        }
        if (decoderOverrides != null) {
            this.recordNumber = decoderOverrides.recordNumber;
            this.inputSlot = decoderOverrides.inputSlot;
        }
        while (dataLeft) {
            this.finishedAtIndex = this.decodeDataInformationBlock(inputData, index, noValueDecode, mode2Active);
            if (this.finishedAtIndex == -1) {
                ++index;
                continue;
            }
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" Returned from decodeDataInformationBlock ");
            }
            if (this.recordNumber > this.lastRecordNumber && allowMultipleReads && this.specialFunctionQty < maxSpecialFunctionReads) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("MBUSDECODEVARIABLEFRAME: recordNumber = " + this.recordNumber + "  and lastRecordNumber= " + this.lastRecordNumber);
                }
                if (this.device != null && this.recordNumber > this.device.getMaxInputsPerCycleCount()) {
                    this.device.setMaxInputsPerCycleCount(this.recordNumber);
                }
                this.lastRecordNumber = this.recordNumber;
                if (this.network != null) {
                    MbusReqUd2Message commandMessage = new MbusReqUd2Message(this.device, this.network);
                    if (this.device != null) {
                        commandMessage.setMessageBaudRate(this.device.getBaudRate());
                    } else {
                        commandMessage.setMessageBaudRate(this.network.getSearchBaudRate());
                    }
                    MbusResponseMessage rsp = null;
                    if (this.network.getSendLockActive() == null && MbusLogInputOutput.log.isLoggable(2)) {
                        MbusLogInputOutput.log.warning("No lock active while reading continuation data");
                    }
                    long minRxTxTimes = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)commandMessage.getMessageBaudRate());
                    rsp = (MbusResponseMessage)this.network.sendMBusSyncActiveParams(commandMessage, minRxTxTimes += MBusTxTimings.calculateTxRxTime(commandMessage, (BBaudRate)commandMessage.getMessageBaudRate()));
                    if (rsp != null && rsp.getSuccessfulResponse()) {
                        if (MbusLogInputOutput.log.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Input(Multiple Records):- " + rsp.toDebugString());
                        }
                        byte[] byteHold = rsp.getBytes();
                        int[] intHold = new int[byteHold.length];
                        if (byteHold.length > 8) {
                            for (int i = 0; i < byteHold.length; ++i) {
                                intHold[i] = byteHold[i] & 0xFF;
                            }
                            index = this.decodeFixedDataHeader(intHold);
                            inputData = intHold;
                            continue;
                        }
                        dataLeft = false;
                        continue;
                    }
                    dataLeft = false;
                    continue;
                }
                dataLeft = false;
                continue;
            }
            if (this.manufacturersIndex == -1 && !this.specialFunctionFound) {
                int tempHold = 0;
                if (this.alreadyExists(this.description, this.orthogonalDescription, this.unitType, this.recordNumber, this.function, this.exponent)) {
                    tempHold = this.inputSlot;
                }
                if (this.storageNumber == 1) {
                    tempHold = 0;
                }
                BMbusPointData pointData = new BMbusPointData();
                pointData.setUnit(this.unitType);
                pointData.setDescription(this.description);
                pointData.setExponent(this.exponent);
                pointData.setValue((BStatusValue)this.value.newCopy());
                pointData.setStorageNumber(this.storageNumber);
                pointData.setFunction(this.function);
                pointData.setOrthogonalDescription(this.orthogonalDescription);
                pointData.setRecordNumber(this.recordNumber);
                pointData.setMessageSlotNumber(tempHold);
                if (this.description.equals(BMbusDescription.sizeOfStorageBlock.toString())) {
                    this.blockSize = (long)((BStatusNumeric)this.value).getValue();
                }
                if (this.description.equals(BMbusDescription.date.toString()) || this.description.equals(BMbusDescription.dateAndTime.toString()) || this.orthogonalDescription.equals((Object)BMbusOrthogonalDescription.startDate)) {
                    pointData.setNumberType(BMbusNumberType.dateIp);
                } else if (this.value instanceof BStatusNumeric) {
                    pointData.setNumberType(BMbusNumberType.numericIp);
                } else if (this.value instanceof BStatusBoolean) {
                    pointData.setNumberType(BMbusNumberType.booleanIp);
                } else if (this.value instanceof BStatusEnum) {
                    pointData.setNumberType(BMbusNumberType.enumIp);
                } else if (this.value instanceof BStatusString) {
                    pointData.setNumberType(BMbusNumberType.stringIp);
                } else {
                    pointData.setNumberType(BMbusNumberType.notKnown);
                }
                if (this.value.getStatus().equals((Object)BStatus.ok)) {
                    this.activedataInformation.add(pointData);
                    ++this.inputSlot;
                }
            }
            if (this.finishedAtIndex > inputData.length - 3) {
                if (MbusToolkit.isTraceOn()) {
                    if (this.finishedAtIndex - 1 < inputData.length) {
                        MbusToolkit.trace("MBUSDECODEVARIABLEFRAME-END-1: index = [" + (this.finishedAtIndex - 1) + "] with value 0x" + TextUtil.byteToHexString((int)inputData[this.finishedAtIndex - 1]) + " which is " + inputData[this.finishedAtIndex - 1]);
                    }
                    if (this.finishedAtIndex < inputData.length) {
                        MbusToolkit.trace("MBUSDECODEVARIABLEFRAME-END+0: index = [" + this.finishedAtIndex + "] with value 0x" + TextUtil.byteToHexString((int)inputData[this.finishedAtIndex]) + " which is " + inputData[this.finishedAtIndex]);
                    }
                    if (this.finishedAtIndex + 1 < inputData.length) {
                        MbusToolkit.trace("MBUSDECODEVARIABLEFRAME-END+1: index = [" + (this.finishedAtIndex + 1) + "] with value 0x" + TextUtil.byteToHexString((int)inputData[this.finishedAtIndex + 1]) + " which is " + inputData[this.finishedAtIndex + 1]);
                    }
                }
                dataLeft = false;
                continue;
            }
            index = this.finishedAtIndex;
        }
        if (decoderOverrides != null) {
            decoderOverrides.recordNumber = this.recordNumber;
            decoderOverrides.inputSlot = this.inputSlot;
        }
    }

    private int decodeDataInformationBlock(int[] input, int startIndex, boolean noValueFlag, boolean mode2Active) {
        int vifIndex;
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN decodeDataInformationBlock ");
            ByteBuffer byteBuf = new ByteBuffer(input.length);
            for (int i = 0; i < input.length; ++i) {
                byteBuf.write(input[i]);
            }
            MbusToolkit.trace(" IN RAW : 0x" + byteBuf.dumpToString());
        }
        int difIndex = startIndex;
        boolean extensionRequired = false;
        int difByte = input[difIndex];
        this.orthogonalDescription = BMbusOrthogonalDescription.none;
        this.description = "None";
        this.manufacturersIndex = -1;
        this.difeTariff = 0;
        this.difeUnit = 0;
        int difeUnitShift = 0;
        if ((difByte & 0xF) == 15) {
            switch (difByte) {
                case 31: {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace(" Found Special Functions  Data ");
                    }
                    this.specialFunctionFound = true;
                    ++this.specialFunctionQty;
                    ++this.recordNumber;
                    return input.length;
                }
                case 15: {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace(" Found Manufactures Data at " + startIndex);
                    }
                    this.manufacturersIndex = startIndex + 1;
                    return input.length;
                }
                case 47: {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace(" Found Idle Filler at " + startIndex);
                    }
                    return startIndex + 1;
                }
            }
        } else if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Decoding DIF Byte 0x" + TextUtil.byteToHexString((int)difByte));
        }
        this.specialFunctionFound = false;
        if ((difByte & 0x80) != 0) {
            extensionRequired = true;
        }
        this.storageNumber = (difByte & 0x40) != 0 ? 1 : 0;
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Decoding DIF Byte Storage number is " + this.storageNumber);
        }
        this.function = BMbusFunction.make(difByte >> 4 & 3);
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Decoding DIF Byte Function is " + (Object)((Object)this.function));
        }
        this.dataType = difByte & 0xF;
        int loopIndex = 0;
        int difeIndex = difIndex + 1;
        int difeByte = 0;
        int storageShift = 1;
        while (extensionRequired) {
            difeByte = input[difeIndex];
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" Processing DIF Extension 0x" + TextUtil.byteToHexString((int)difeByte) + " at index " + difeIndex);
            }
            if ((difeByte & 0x80) == 0) {
                extensionRequired = false;
            }
            int tempDifeUnit = 0;
            if ((difeByte & 0x40) != 0) {
                tempDifeUnit = 1;
            }
            this.difeUnit |= (tempDifeUnit <<= difeUnitShift);
            ++difeUnitShift;
            int tempTariff = difeByte >> 4 & 3;
            this.difeTariff = this.difeTariff << 2 | tempTariff;
            long tempStorage = (long)(difeByte & 0xF) << storageShift;
            storageShift += 4;
            this.storageNumber = (int)((long)this.storageNumber | tempStorage) & Short.MAX_VALUE;
            ++difeIndex;
            if (++loopIndex <= 9) continue;
            extensionRequired = false;
        }
        int vifeIndex = vifIndex = difeIndex;
        loopIndex = 0;
        extensionRequired = false;
        int vifByte = input[vifIndex];
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Processing VIF 0x" + TextUtil.byteToHexString((int)vifByte) + " at index " + vifIndex);
        }
        int vifeByte = 0;
        if ((vifByte & 0x80) != 0) {
            extensionRequired = true;
        }
        int expectedDataPos = vifIndex + 1;
        boolean furtherExtReq = extensionRequired;
        if (furtherExtReq) {
            expectedDataPos = vifIndex;
            while (furtherExtReq) {
                int currentVifByte = input[expectedDataPos];
                if ((currentVifByte & 0x80) != 0) {
                    furtherExtReq = true;
                    ++expectedDataPos;
                    continue;
                }
                furtherExtReq = false;
            }
            ++expectedDataPos;
        }
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Expected data start position = " + expectedDataPos);
        }
        int tempPrimaryVif = vifByte & 0x7F;
        if (extensionRequired) {
            if (vifByte == 253) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0xFD");
                }
                tempPrimaryVif = input[++vifeIndex] & 0x7F;
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 2 0x" + TextUtil.byteToHexString((int)tempPrimaryVif) + " at index " + vifeIndex);
                }
                if ((input[vifeIndex] & 0x80) == 0) {
                    extensionRequired = false;
                }
                this.description = MbusExtendedVifConvertor.getDescription(tempPrimaryVif).toString();
                this.unitType = MbusExtendedVifConvertor.getUnits(tempPrimaryVif);
                this.exponent = MbusExtendedVifConvertor.getValueExponent(tempPrimaryVif);
                ++vifIndex;
            } else if (vifByte == 251) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0xFB");
                }
                tempPrimaryVif = input[++vifeIndex] & 0x7F;
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 2 0x" + TextUtil.byteToHexString((int)tempPrimaryVif) + " at index " + vifeIndex);
                }
                if ((input[vifeIndex] & 0x80) == 0) {
                    extensionRequired = false;
                }
                this.description = MbusExtendedIndicatorVifConvertor.getDescription(tempPrimaryVif).toString();
                this.unitType = MbusExtendedIndicatorVifConvertor.getUnits(tempPrimaryVif);
                this.exponent = MbusExtendedIndicatorVifConvertor.getValueExponent(tempPrimaryVif);
                ++vifIndex;
            } else if (vifByte == 252) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0xFC");
                }
                int length = input[vifIndex + 1];
                char[] charHold = new char[length];
                for (int i = 0; i < length; ++i) {
                    charHold[length - i - 1] = (char)input[i + vifIndex + 2];
                }
                String stringHold = new String(charHold);
                this.value = new BStatusString(stringHold, BStatus.ok);
                vifIndex += input[vifIndex + 1];
                if ((input[vifeIndex] & 0x80) != 0) {
                    extensionRequired = true;
                }
                ++vifIndex;
            } else if (vifByte == 255) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0xFF");
                }
                tempPrimaryVif = input[++vifeIndex] & 0x7F;
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 2 0x" + TextUtil.byteToHexString((int)tempPrimaryVif) + " at index " + vifeIndex);
                }
                if ((input[vifeIndex] & 0x80) == 0) {
                    extensionRequired = false;
                }
                this.description = "ManufacturerSpecific";
                this.orthogonalDescription = MbusEnhancedVifExtensionConvertor.getDescription(127, input[vifeIndex]);
                this.unitType = BMbusUnit.none;
                this.exponent = 0;
                ++vifIndex;
            } else if (vifByte < 251) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0x" + TextUtil.byteToHexString((int)vifByte) + " at index " + vifeIndex);
                }
                this.description = MbusVifConvertor.getDescription(tempPrimaryVif, false).toString();
                this.unitType = MbusVifConvertor.getUnits(tempPrimaryVif, false);
                this.exponent = MbusVifConvertor.getValueExponent(tempPrimaryVif);
                ++vifIndex;
            }
            if (extensionRequired) {
                tempPrimaryVif = input[++vifeIndex];
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 3 0x" + TextUtil.byteToHexString((int)tempPrimaryVif) + " at index " + vifeIndex);
                }
                if ((input[vifeIndex] & 0x80) == 0) {
                    extensionRequired = false;
                }
                if (tempPrimaryVif == 61) {
                    this.unitType = MbusVifConvertor.getUnits(tempPrimaryVif, true);
                    this.description = MbusVifConvertor.getDescription(tempPrimaryVif, true).toString();
                } else if ((tempPrimaryVif = input[vifeIndex++] & 0x7F) == 125) {
                    this.exponent += 3;
                } else if (tempPrimaryVif > 111 && tempPrimaryVif < 120) {
                    int expHold = tempPrimaryVif & 7;
                    this.exponent = this.exponent + expHold - 6;
                } else if (tempPrimaryVif > 119 && tempPrimaryVif < 124) {
                    this.offset = (double)(tempPrimaryVif & 3) - 3.0;
                } else {
                    this.orthogonalDescription = tempPrimaryVif == 127 ? MbusEnhancedVifExtensionConvertor.getDescription(tempPrimaryVif, input[vifeIndex]) : MbusEnhancedVifExtensionConvertor.getDescription(tempPrimaryVif, 0);
                }
            }
        } else if (tempPrimaryVif < 123) {
            this.description = MbusVifConvertor.getDescription(tempPrimaryVif, false).toString();
            this.unitType = MbusVifConvertor.getUnits(tempPrimaryVif, false);
            this.exponent = MbusVifConvertor.getValueExponent(tempPrimaryVif);
            if (tempPrimaryVif == 120) {
                this.fabricationNumber = MbusTextUtil.intToHexString((input[vifIndex + 4] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(input[vifIndex + 4] & 0xF, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString((input[vifIndex + 3] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(input[vifIndex + 3] & 0xF, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString((input[vifIndex + 2] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(input[vifIndex + 2] & 0xF, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString((input[vifIndex + 1] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(input[vifIndex + 1] & 0xF, 1);
            }
        } else if (tempPrimaryVif == 124) {
            char[] charHold = new char[input[vifIndex + 1]];
            int charQty = charHold.length;
            for (int i = 0; i < charQty; ++i) {
                charHold[charQty - i - 1] = (char)input[i + vifIndex + 2];
            }
            String stringHold = new String(charHold) + "  ";
            vifIndex = vifIndex + input[vifIndex + 1] + 2;
            char[] charHold2 = new char[input[vifIndex]];
            charQty = charHold2.length;
            ++vifIndex;
            if (this.dataType == 13) {
                for (int i = 0; i < charQty; ++i) {
                    charHold2[charQty - i - 1] = (char)input[i + vifIndex];
                }
            } else {
                MbusDataDecoderIEC870.ValueData data = MbusDataDecoderIEC870.decode(vifIndex - 1, input, this.dataType, noValueFlag, mode2Active);
                String stringHold2 = new String(data.getValue().toString());
                stringHold = stringHold + stringHold2;
                this.value = new BStatusString(stringHold, BStatus.ok);
                return data.getIndex();
            }
            String stringHold2 = new String(charHold2);
            stringHold = stringHold + stringHold2;
            this.value = new BStatusString(stringHold, BStatus.ok);
            return vifIndex += charQty;
        }
        vifeIndex = vifIndex + 1;
        while (extensionRequired) {
            vifeByte = input[vifeIndex];
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" Processing addition VIFE 0x" + TextUtil.byteToHexString((int)vifeByte) + " at index " + vifeIndex);
            }
            if (vifeByte == 255) {
                this.orthogonalDescription = MbusEnhancedVifExtensionConvertor.getDescription(127, input[vifeIndex + 1]);
            }
            if ((vifeByte & 0x80) == 0) {
                extensionRequired = false;
            }
            ++vifeIndex;
            if (++loopIndex <= 9) continue;
            extensionRequired = false;
        }
        int dataIndex = vifeIndex;
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Processing data from index " + dataIndex);
        }
        if (this.description.equals(BMbusDescription.date.toString()) && this.dataType == 2) {
            this.dataType = 18;
        } else if (this.description.equals(BMbusDescription.dateAndTime.toString())) {
            if (this.dataType == 4) {
                this.dataType = 19;
            } else if (this.dataType == 3) {
                this.dataType = 21;
            } else if (this.dataType == 6) {
                this.dataType = 20;
            }
        }
        if (this.orthogonalDescription.equals((Object)BMbusOrthogonalDescription.startDate)) {
            this.dataType = this.dataType == 2 ? 18 : 19;
        }
        MbusDataDecoderIEC870.ValueData data = MbusDataDecoderIEC870.decode(expectedDataPos, input, this.dataType, noValueFlag, mode2Active);
        this.value = data.getValue();
        if (this.value instanceof BStatusNumeric) {
            BStatusNumeric valueHold = (BStatusNumeric)this.value;
            this.value = new BStatusNumeric((valueHold.getValue() + this.offset) * Math.pow(10.0, this.exponent), BStatus.ok);
        }
        if (this.difeTariff != 0) {
            this.description = this.description + " Tariff " + this.difeTariff;
        }
        if (this.difeUnit != 0) {
            this.description = this.description + " SubUnit " + this.difeUnit;
        }
        return data.getIndex();
    }

    private boolean alreadyExists(String description, BMbusOrthogonalDescription orthogonalDescription, BMbusUnit unitType, int recordNumber, BMbusFunction function, int exponent) {
        boolean match = false;
        for (int j = 0; j < this.activedataInformation.size(); ++j) {
            BMbusPointData dataInformation = this.activedataInformation.get(j);
            if (!dataInformation.getUnit().equals((Object)unitType) || !dataInformation.getDescription().equals(description) || dataInformation.getRecordNumber() != recordNumber || dataInformation.getFunction() != function || !dataInformation.getOrthogonalDescription().equals((Object)orthogonalDescription)) continue;
            match = true;
            break;
        }
        return match;
    }

    public String getIdentNumber() {
        return this.identNumber;
    }

    public String getSecondaryAddress() {
        return this.secondaryAddress;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public BMbusDeviceTypeId getDeviceTypeId() {
        return this.deviceTypeId;
    }

    public int getAccess() {
        return this.access;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean getStatusBit5() {
        return this.status5;
    }

    public boolean getStatusBit6() {
        return this.status6;
    }

    public boolean getStatusBit7() {
        return this.status7;
    }

    public int getDifeUnit() {
        return this.difeUnit;
    }

    public int getDifeTariff() {
        return this.difeTariff;
    }

    public ArrayList<BMbusPointData> getData() {
        return this.activedataInformation;
    }

    public long getStorageBlockSize() {
        return this.blockSize;
    }

    public long getStorageBlockDate() {
        return this.blockDate;
    }

    public long getStorageBlockInterval() {
        return this.blockInterval;
    }

    public int getManufacturersIndex() {
        return this.manufacturersIndex;
    }

    public String getFabricationNumber() {
        return this.fabricationNumber;
    }

    public boolean getSpecialFunctionFound() {
        return this.specialFunctionFound;
    }

    public int getInputSlot() {
        return this.inputSlot;
    }

    public void overrideParser(int newInputSlot) {
        this.inputSlot = newInputSlot;
    }

    public static class DecoderOverrides {
        public int inputSlot = 1;
        public int recordNumber = 1;
    }
}

