/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusCommandCodes;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.enums.BMbusVifCodes;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.mspec.BManuSpecDefElement;
import com.tridium.mbus.point.BMbusPointDeviceExt;
import com.tridium.mbus.point.BMbusPollGroup;
import com.tridium.mbus.utils.MbusDataDecoderIEC870;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.serial.BBaudRate;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public final class BMbusProxyExt
extends BBasicProxyExt {
    public static final Property mbusUnit = BMbusProxyExt.newProperty((int)0, (BValue)BMbusUnit.none, null);
    public static final Property description = BMbusProxyExt.newProperty((int)0, (String)"", null);
    public static final Property orthogonalDescription = BMbusProxyExt.newProperty((int)0, (BValue)BMbusOrthogonalDescription.none, null);
    public static final Property numberType = BMbusProxyExt.newProperty((int)0, (BValue)BMbusNumberType.notKnown, null);
    public static final Property messageSlotNumber = BMbusProxyExt.newProperty((int)0, (int)0, null);
    public static final Property recordNumber = BMbusProxyExt.newProperty((int)0, (int)0, null);
    public static final Property function = BMbusProxyExt.newProperty((int)0, (BValue)BMbusFunction.instantaneous, null);
    public static final Property cycleNumber = BMbusProxyExt.newProperty((int)4, (int)0, null);
    public static final Property storageNumber = BMbusProxyExt.newProperty((int)4, (int)0, null);
    public static final Property exponent = BMbusProxyExt.newProperty((int)0, (int)1, null);
    public static final Property manuSpecDefElementOrd = BMbusProxyExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"mbus:DualComponentOrdFE"), (String)"parentType", (BIDataValue)BString.make((String)"mbus:ManuSpecDef"), (String)"childType", (BIDataValue)BString.make((String)"mbus:ManuSpecDefElement")));
    public static final Property mbusDifCode = BMbusProxyExt.newProperty((int)4, (BValue)BMbusCommandCodes.none, null);
    public static final Property mbusVifCode = BMbusProxyExt.newProperty((int)4, (BValue)BMbusVifCodes.none, null);
    public static final Property deviceMode = BMbusProxyExt.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Action loadManuSpecData = BMbusProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BMbusProxyExt.class);
    protected Object lastPollGroupCode = null;
    protected BPollFrequency lastPollFrequency = null;

    public BMbusUnit getMbusUnit() {
        return (BMbusUnit)this.get(mbusUnit);
    }

    public void setMbusUnit(BMbusUnit v) {
        this.set(mbusUnit, (BValue)v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BMbusOrthogonalDescription getOrthogonalDescription() {
        return (BMbusOrthogonalDescription)this.get(orthogonalDescription);
    }

    public void setOrthogonalDescription(BMbusOrthogonalDescription v) {
        this.set(orthogonalDescription, (BValue)v, null);
    }

    public BMbusNumberType getNumberType() {
        return (BMbusNumberType)this.get(numberType);
    }

    public void setNumberType(BMbusNumberType v) {
        this.set(numberType, (BValue)v, null);
    }

    public int getMessageSlotNumber() {
        return this.getInt(messageSlotNumber);
    }

    public void setMessageSlotNumber(int v) {
        this.setInt(messageSlotNumber, v, null);
    }

    public int getRecordNumber() {
        return this.getInt(recordNumber);
    }

    public void setRecordNumber(int v) {
        this.setInt(recordNumber, v, null);
    }

    public BMbusFunction getFunction() {
        return (BMbusFunction)this.get(function);
    }

    public void setFunction(BMbusFunction v) {
        this.set(function, (BValue)v, null);
    }

    public int getCycleNumber() {
        return this.getInt(cycleNumber);
    }

    public void setCycleNumber(int v) {
        this.setInt(cycleNumber, v, null);
    }

    public int getStorageNumber() {
        return this.getInt(storageNumber);
    }

    public void setStorageNumber(int v) {
        this.setInt(storageNumber, v, null);
    }

    public int getExponent() {
        return this.getInt(exponent);
    }

    public void setExponent(int v) {
        this.setInt(exponent, v, null);
    }

    public BOrd getManuSpecDefElementOrd() {
        return (BOrd)this.get(manuSpecDefElementOrd);
    }

    public void setManuSpecDefElementOrd(BOrd v) {
        this.set(manuSpecDefElementOrd, (BValue)v, null);
    }

    public BMbusCommandCodes getMbusDifCode() {
        return (BMbusCommandCodes)this.get(mbusDifCode);
    }

    public void setMbusDifCode(BMbusCommandCodes v) {
        this.set(mbusDifCode, (BValue)v, null);
    }

    public BMbusVifCodes getMbusVifCode() {
        return (BMbusVifCodes)this.get(mbusVifCode);
    }

    public void setMbusVifCode(BMbusVifCodes v) {
        this.set(mbusVifCode, (BValue)v, null);
    }

    public int getDeviceMode() {
        return this.getInt(deviceMode);
    }

    public void setDeviceMode(int v) {
        this.setInt(deviceMode, v, null);
    }

    public void loadManuSpecData() {
        this.invoke(loadManuSpecData, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMbusProxyExt() {
        this.setFlags((Slot)deviceFacets, 1);
    }

    public BAbstractMbusNetwork getMbusNetwork() {
        return (BAbstractMbusNetwork)this.getNetwork();
    }

    public BMbusDevice getMbusDevice() {
        return (BMbusDevice)this.getDevice();
    }

    public BMbusPointDeviceExt getMbusPointDeviceExt() {
        return (BMbusPointDeviceExt)this.getDeviceExt();
    }

    public void started() throws Exception {
        super.started();
        this.setFlags((Slot)deviceFacets, 4);
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)conversion, 4);
            this.setFlags((Slot)tuningPolicyName, 4);
            this.setFlags((Slot)mbusUnit, 4);
            this.setFlags((Slot)description, 4);
            this.setFlags((Slot)orthogonalDescription, 4);
            this.setFlags((Slot)numberType, 4);
            this.setFlags((Slot)messageSlotNumber, 4);
            this.setFlags((Slot)function, 4);
            this.setFlags((Slot)manuSpecDefElementOrd, 4);
            this.setFlags((Slot)mbusDifCode, 0);
            this.setFlags((Slot)mbusVifCode, 0);
            this.setFlags((Slot)writeValue, 0);
            this.setFlags((Slot)readValue, 4);
        } else {
            int precision = 0;
            if (this.getExponent() < 0) {
                precision = -this.getExponent();
            }
            BUnit unitHold = BMbusUnit.getNiagaraUnits(this.getMbusUnit());
            this.setDeviceFacets(BFacets.makeNumeric((BUnit)unitHold, (int)precision));
            this.setFlags((Slot)conversion, 0);
            this.setFlags((Slot)tuningPolicyName, 0);
            this.setFlags((Slot)function, 1);
            this.setFlags((Slot)manuSpecDefElementOrd, 0);
            this.setFlags((Slot)mbusDifCode, 4);
            this.setFlags((Slot)mbusVifCode, 4);
            this.setFlags((Slot)writeValue, 4);
            this.setFlags((Slot)readValue, 0);
            BOrd ord = this.getManuSpecDefElementOrd();
            if (ord.isNull()) {
                this.setFlags((Slot)mbusUnit, 1);
                this.setFlags((Slot)description, 1);
                this.setFlags((Slot)orthogonalDescription, 1);
                this.setFlags((Slot)numberType, 1);
                this.setFlags((Slot)messageSlotNumber, 1);
                this.setFlags((Slot)function, 1);
            } else {
                this.setFlags((Slot)mbusUnit, 4);
                this.setFlags((Slot)description, 4);
                this.setFlags((Slot)orthogonalDescription, 4);
                this.setFlags((Slot)numberType, 4);
                this.setFlags((Slot)messageSlotNumber, 4);
            }
        }
        this.loadManuSpecData();
        if (Sys.isStationStarted()) {
            this.getMbusDevice().optimiseReads();
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property == manuSpecDefElementOrd) {
                this.loadManuSpecData();
            } else if (property == recordNumber) {
                this.getMbusDevice().optimiseReads();
            }
        }
        super.changed(property, context);
    }

    public void doLoadManuSpecData() throws Exception {
        BOrd ord = this.getManuSpecDefElementOrd();
        if (ord.isNull()) {
            if (this.getParentPoint().isWritablePoint()) {
                this.setFlags((Slot)mbusUnit, 4);
                this.setFlags((Slot)description, 4);
                this.setFlags((Slot)orthogonalDescription, 4);
                this.setFlags((Slot)numberType, 4);
                this.setFlags((Slot)messageSlotNumber, 4);
                this.setFlags((Slot)function, 4);
            } else {
                this.setFlags((Slot)mbusUnit, 1);
                this.setFlags((Slot)description, 1);
                this.setFlags((Slot)orthogonalDescription, 1);
                this.setFlags((Slot)numberType, 1);
                this.setFlags((Slot)messageSlotNumber, 1);
                this.setFlags((Slot)function, 1);
            }
            return;
        }
        this.setFlags((Slot)mbusUnit, 4);
        this.setFlags((Slot)description, 4);
        this.setFlags((Slot)orthogonalDescription, 4);
        this.setFlags((Slot)numberType, 4);
        this.setFlags((Slot)messageSlotNumber, 4);
        try {
            BManuSpecDefElement elementError = (BManuSpecDefElement)ord.get((BObject)this.getMbusNetwork());
            if (elementError == null) {
                this.readFail("Manufacturer Specific Data Ord not set up");
            }
        }
        catch (Exception e) {
            this.readFail("Failed to resolve Manufacturer Specific Data");
        }
    }

    public Type getDeviceExtType() {
        return BMbusPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    public Object getPollGroupCode() {
        if (this.isRunning()) {
            BMbusDevice device = (BMbusDevice)this.getDevice();
            String hold = new Integer(this.getDeviceMode() * 500).toString();
            if (device.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                this.lastPollGroupCode = this.getNetwork().getHandle().toString() + "_" + new Integer(device.getPrimaryAddress()).toString() + hold + "P";
                return this.lastPollGroupCode;
            }
            if (device.getAddressMode().equals((Object)BMbusAddressing.secondary)) {
                this.lastPollGroupCode = this.getNetwork().getHandle().toString() + "_" + device.getSecondaryAddress() + hold + "S";
                return this.lastPollGroupCode;
            }
            this.lastPollGroupCode = this.getNetwork().getHandle().toString() + "_" + device.getSecondaryAddress() + device.getFabricationNumber() + hold + "E";
            return this.lastPollGroupCode;
        }
        return this.lastPollGroupCode;
    }

    public Type getPollGroupType() {
        return BMbusPollGroup.TYPE;
    }

    public BPollFrequency getPollFrequency() {
        if (this.isRunning()) {
            this.lastPollFrequency = this.getMbusDevice().getPollFrequency();
        }
        return this.lastPollFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWrite(BStatusValue out) {
        if (this.getParentPoint().isWritablePoint()) {
            byte[] valueBytes = MbusDataDecoderIEC870.encode(out, this.getMbusDifCode());
            byte[] outputBytes = null;
            if (valueBytes != null) {
                if (this.getMbusDifCode().getOrdinal() > 14) {
                    outputBytes = valueBytes;
                } else {
                    outputBytes = new byte[valueBytes.length + 2];
                    for (int i = 0; i < valueBytes.length; ++i) {
                        outputBytes[i + 2] = valueBytes[i];
                    }
                    outputBytes[0] = (byte)this.getMbusDifCode().getOrdinal();
                    outputBytes[1] = (byte)this.getMbusVifCode().getOrdinal();
                }
            }
            String writeCmdLock = "write" + this.getHandle() + "" + Clock.ticks();
            BMbusDevice device = this.getMbusDevice();
            BAbstractMbusNetwork network = device.getMbusNetwork();
            try {
                long minRxTxTimes;
                if (device.getAddressMode() != BMbusAddressing.primary) {
                    MbusSndUdMessage message2 = new MbusSndUdMessage(device, network);
                    message2.setMessageBaudRate(device.getBaudRate());
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                    MbusResponseMessage mbusResp = (MbusResponseMessage)network.sendMBusSync(device.getTxTimingsReference(), writeCmdLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)device.getBaudRate()));
                    if (mbusResp != null && mbusResp.getCollisionDetected()) {
                        this.writeFail("Collision during secondary address selection");
                        network.unlockSends(writeCmdLock);
                        throw new Exception("Collision during secondary address selection");
                    }
                    device.setFcBitState(true);
                }
                if (valueBytes != null && outputBytes != null) {
                    MbusSndUdMessage message = new MbusSndUdMessage(this.getMbusDevice(), network, outputBytes);
                    message.setMessageBaudRate(device.getBaudRate());
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                    network.sendMBusSync(device.getTxTimingsReference(), writeCmdLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)device.getBaudRate()));
                    this.writeOk(out);
                } else {
                    this.writeFail("Incorrect MBusDifCode or MBusVifCode Selection");
                }
                network.unlockSends(writeCmdLock);
            }
            catch (Throwable e) {
                network.unlockSends(writeCmdLock);
            }
            finally {
                network.unlockSends(writeCmdLock);
            }
        }
    }
}

