/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.mspec;

import com.tridium.mbus.mspec.BManuSpecDefElement;
import com.tridium.mbus.utils.MbusTextUtil;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BManuSpecDefElementBit
extends BManuSpecDefElement {
    public static final Property bitMask = BManuSpecDefElementBit.newProperty((int)0, (String)"00", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Property byteMask = BManuSpecDefElementBit.newProperty((int)0, (String)"00", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Property orFlag = BManuSpecDefElementBit.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BManuSpecDefElementBit.class);

    public String getBitMask() {
        return this.getString(bitMask);
    }

    public void setBitMask(String v) {
        this.setString(bitMask, v, null);
    }

    public String getByteMask() {
        return this.getString(byteMask);
    }

    public void setByteMask(String v) {
        this.setString(byteMask, v, null);
    }

    public boolean getOrFlag() {
        return this.getBoolean(orFlag);
    }

    public void setOrFlag(boolean v) {
        this.setBoolean(orFlag, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BStatusValue getValue(int[] inputArray) {
        if (inputArray == null) {
            return null;
        }
        int bitMaskBits = 16 * MbusTextUtil.hexCharToInt(this.getBitMask().charAt(0)) + MbusTextUtil.hexCharToInt(this.getBitMask().charAt(1));
        int byteMaskBits = 16 * MbusTextUtil.hexCharToInt(this.getByteMask().charAt(0)) + MbusTextUtil.hexCharToInt(this.getByteMask().charAt(1));
        int hold = inputArray[this.getOffset()] & byteMaskBits & bitMaskBits;
        if (this.getOrFlag()) {
            if (hold == 0) {
                return new BStatusBoolean(false, BStatus.ok);
            }
            return new BStatusBoolean(true, BStatus.ok);
        }
        if (hold == bitMaskBits) {
            return new BStatusBoolean(true, BStatus.ok);
        }
        return new BStatusBoolean(false, BStatus.ok);
    }
}

