/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mbus.messages.MbusReceivedMessage;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.nre.util.ByteArrayUtil;

public class MbusResponseMessage
extends ReceivedMessage {
    private boolean collisionMarkerRead = false;
    private byte[] data = null;

    public MbusResponseMessage() {
        this.setSuccessfulResponse(false);
    }

    public MbusResponseMessage(byte[] data) {
        this.data = data;
        this.setSuccessfulResponse(true);
    }

    public MbusResponseMessage(int[] intData) {
        byte[] byteConvert = new byte[intData.length];
        for (int i = 0; i < intData.length; ++i) {
            byteConvert[i] = (byte)intData[i];
        }
        this.data = byteConvert;
        this.setSuccessfulResponse(true);
    }

    public MbusResponseMessage(MbusReceivedMessage input) {
        this.setBytes(input.getBytes());
        this.collisionMarkerRead = input.getCollisionFlag();
        this.setSuccessfulResponse(input.getSuccessfulResponse());
        if (this.data.length > 4) {
            this.setSuccessfulResponse(this.validate());
        }
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getLength() {
        return this.data.length;
    }

    public String toDebugString() {
        return ByteArrayUtil.toHexString((byte[])this.data, (int)0, (int)this.data.length);
    }

    public int getChecksum() {
        return this.data[this.data.length - 2] & 0xFF;
    }

    public int getPrimaryAddress() {
        if (this.data == null) {
            return 0;
        }
        if (this.data.length == 5) {
            return this.data[2] & 0xFF;
        }
        if (this.data.length > 5) {
            return this.data[5] & 0xFF;
        }
        return 0;
    }

    public void setBytes(byte[] data) {
        this.data = data;
    }

    public boolean getCollisionDetected() {
        return this.collisionMarkerRead;
    }

    private boolean validate() {
        if (this.getSuccessfulResponse()) {
            return true;
        }
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace("Response Message: read/write fail, null response");
        }
        return false;
    }
}

